/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.entity;

import com.dulcecontrol.bakery.features.admin.seguridad.entity.TipoDocumento;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="usuarios_tienda")
@SQLDelete(sql="UPDATE usuarios_tienda SET activo = false, eliminado_en = NOW() WHERE id = ?")
@SQLRestriction(value="activo = true")
public class UsuarioTienda {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="rol_id", nullable=false)
    private Long rolId;
    @Column(nullable=false, unique=true)
    private String correo;
    @Column(name="hash_contrasena", nullable=false)
    private String hashContrasena;
    @Enumerated(value=EnumType.STRING)
    @Column(name="tipo_doc", nullable=false, columnDefinition="ENUM('DNI','RUC')")
    private TipoDocumento tipoDoc;
    @Column(name="numero_doc", nullable=false, length=20)
    private String numeroDoc;
    @Column(name="nombres_doc", nullable=false)
    private String nombres;
    @Column(length=50)
    private String telefono;
    private Boolean activo = true;
    @Column(name="ultimo_acceso_en")
    private LocalDateTime ultimoAccesoEn;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;
    @Column(name="eliminado_en")
    private LocalDateTime eliminadoEn;

    @PrePersist
    protected void onCreate() {
        this.creadoEn = LocalDateTime.now();
        this.actualizadoEn = LocalDateTime.now();
        if (this.activo == null) {
            this.activo = true;
        }
    }

    @PreUpdate
    protected void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public UsuarioTienda() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getRolId() {
        return this.rolId;
    }

    @Generated
    public String getCorreo() {
        return this.correo;
    }

    @Generated
    public String getHashContrasena() {
        return this.hashContrasena;
    }

    @Generated
    public TipoDocumento getTipoDoc() {
        return this.tipoDoc;
    }

    @Generated
    public String getNumeroDoc() {
        return this.numeroDoc;
    }

    @Generated
    public String getNombres() {
        return this.nombres;
    }

    @Generated
    public String getTelefono() {
        return this.telefono;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getUltimoAccesoEn() {
        return this.ultimoAccesoEn;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public LocalDateTime getEliminadoEn() {
        return this.eliminadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setRolId(Long rolId) {
        this.rolId = rolId;
    }

    @Generated
    public void setCorreo(String correo) {
        this.correo = correo;
    }

    @Generated
    public void setHashContrasena(String hashContrasena) {
        this.hashContrasena = hashContrasena;
    }

    @Generated
    public void setTipoDoc(TipoDocumento tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @Generated
    public void setNumeroDoc(String numeroDoc) {
        this.numeroDoc = numeroDoc;
    }

    @Generated
    public void setNombres(String nombres) {
        this.nombres = nombres;
    }

    @Generated
    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setUltimoAccesoEn(LocalDateTime ultimoAccesoEn) {
        this.ultimoAccesoEn = ultimoAccesoEn;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public void setEliminadoEn(LocalDateTime eliminadoEn) {
        this.eliminadoEn = eliminadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UsuarioTienda)) {
            return false;
        }
        UsuarioTienda other = (UsuarioTienda)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Long this$rolId = this.getRolId();
        Long other$rolId = other.getRolId();
        if (this$rolId == null ? other$rolId != null : !((Object)this$rolId).equals(other$rolId)) {
            return false;
        }
        Boolean this$activo = this.getActivo();
        Boolean other$activo = other.getActivo();
        if (this$activo == null ? other$activo != null : !((Object)this$activo).equals(other$activo)) {
            return false;
        }
        String this$correo = this.getCorreo();
        String other$correo = other.getCorreo();
        if (this$correo == null ? other$correo != null : !this$correo.equals(other$correo)) {
            return false;
        }
        String this$hashContrasena = this.getHashContrasena();
        String other$hashContrasena = other.getHashContrasena();
        if (this$hashContrasena == null ? other$hashContrasena != null : !this$hashContrasena.equals(other$hashContrasena)) {
            return false;
        }
        TipoDocumento this$tipoDoc = this.getTipoDoc();
        TipoDocumento other$tipoDoc = other.getTipoDoc();
        if (this$tipoDoc == null ? other$tipoDoc != null : !this$tipoDoc.equals(other$tipoDoc)) {
            return false;
        }
        String this$numeroDoc = this.getNumeroDoc();
        String other$numeroDoc = other.getNumeroDoc();
        if (this$numeroDoc == null ? other$numeroDoc != null : !this$numeroDoc.equals(other$numeroDoc)) {
            return false;
        }
        String this$nombres = this.getNombres();
        String other$nombres = other.getNombres();
        if (this$nombres == null ? other$nombres != null : !this$nombres.equals(other$nombres)) {
            return false;
        }
        String this$telefono = this.getTelefono();
        String other$telefono = other.getTelefono();
        if (this$telefono == null ? other$telefono != null : !this$telefono.equals(other$telefono)) {
            return false;
        }
        LocalDateTime this$ultimoAccesoEn = this.getUltimoAccesoEn();
        LocalDateTime other$ultimoAccesoEn = other.getUltimoAccesoEn();
        if (this$ultimoAccesoEn == null ? other$ultimoAccesoEn != null : !((Object)this$ultimoAccesoEn).equals(other$ultimoAccesoEn)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        if (this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn)) {
            return false;
        }
        LocalDateTime this$actualizadoEn = this.getActualizadoEn();
        LocalDateTime other$actualizadoEn = other.getActualizadoEn();
        if (this$actualizadoEn == null ? other$actualizadoEn != null : !((Object)this$actualizadoEn).equals(other$actualizadoEn)) {
            return false;
        }
        LocalDateTime this$eliminadoEn = this.getEliminadoEn();
        LocalDateTime other$eliminadoEn = other.getEliminadoEn();
        return !(this$eliminadoEn == null ? other$eliminadoEn != null : !((Object)this$eliminadoEn).equals(other$eliminadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UsuarioTienda;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Long $rolId = this.getRolId();
        result = result * 59 + ($rolId == null ? 43 : ((Object)$rolId).hashCode());
        Boolean $activo = this.getActivo();
        result = result * 59 + ($activo == null ? 43 : ((Object)$activo).hashCode());
        String $correo = this.getCorreo();
        result = result * 59 + ($correo == null ? 43 : $correo.hashCode());
        String $hashContrasena = this.getHashContrasena();
        result = result * 59 + ($hashContrasena == null ? 43 : $hashContrasena.hashCode());
        TipoDocumento $tipoDoc = this.getTipoDoc();
        result = result * 59 + ($tipoDoc == null ? 43 : $tipoDoc.hashCode());
        String $numeroDoc = this.getNumeroDoc();
        result = result * 59 + ($numeroDoc == null ? 43 : $numeroDoc.hashCode());
        String $nombres = this.getNombres();
        result = result * 59 + ($nombres == null ? 43 : $nombres.hashCode());
        String $telefono = this.getTelefono();
        result = result * 59 + ($telefono == null ? 43 : $telefono.hashCode());
        LocalDateTime $ultimoAccesoEn = this.getUltimoAccesoEn();
        result = result * 59 + ($ultimoAccesoEn == null ? 43 : ((Object)$ultimoAccesoEn).hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        LocalDateTime $actualizadoEn = this.getActualizadoEn();
        result = result * 59 + ($actualizadoEn == null ? 43 : ((Object)$actualizadoEn).hashCode());
        LocalDateTime $eliminadoEn = this.getEliminadoEn();
        result = result * 59 + ($eliminadoEn == null ? 43 : ((Object)$eliminadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "UsuarioTienda(id=" + this.getId() + ", tiendaId=" + this.getTiendaId() + ", rolId=" + this.getRolId() + ", correo=" + this.getCorreo() + ", hashContrasena=" + this.getHashContrasena() + ", tipoDoc=" + String.valueOf(this.getTipoDoc()) + ", numeroDoc=" + this.getNumeroDoc() + ", nombres=" + this.getNombres() + ", telefono=" + this.getTelefono() + ", activo=" + this.getActivo() + ", ultimoAccesoEn=" + String.valueOf(this.getUltimoAccesoEn()) + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ", actualizadoEn=" + String.valueOf(this.getActualizadoEn()) + ", eliminadoEn=" + String.valueOf(this.getEliminadoEn()) + ")";
    }
}

