/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.dto;

import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioUpdateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.TipoDocumento;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Email;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.List;
import lombok.Generated;

public class UsuarioUpdateRequest {
    @NotNull
    private Long rolId;
    @NotEmpty
    private List<Long> sedeIds;
    @Email
    @NotBlank
    private String correo;
    @Size(min=8, max=64)
    private @Size(min=8, max=64) String nuevaContrasena;
    @NotNull
    private TipoDocumento tipoDoc;
    @NotBlank
    @Pattern(regexp="\\d{8}|\\d{11}", message="El n\u00famero de documento debe tener 8 d\u00edgitos para DNI o 11 para RUC")
    private @NotBlank @Pattern(regexp="\\d{8}|\\d{11}", message="El n\u00famero de documento debe tener 8 d\u00edgitos para DNI o 11 para RUC") String numeroDoc;
    @NotBlank
    private String nombres;
    @Size(max=50)
    private @Size(max=50) String telefono;
    private Boolean activo;

    @AssertTrue(message="El n\u00famero de documento no coincide con el tipo seleccionado")
    public @AssertTrue(message="El n\u00famero de documento no coincide con el tipo seleccionado") boolean isNumeroDocConsistenteConTipo() {
        if (this.tipoDoc == null || this.numeroDoc == null) {
            return true;
        }
        return switch (1.$SwitchMap$com$dulcecontrol$bakery$features$admin$seguridad$entity$TipoDocumento[this.tipoDoc.ordinal()]) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.numeroDoc.matches("\\d{8}");
            case 2 -> this.numeroDoc.matches("\\d{11}");
        };
    }

    @Generated
    public Long getRolId() {
        return this.rolId;
    }

    @Generated
    public List<Long> getSedeIds() {
        return this.sedeIds;
    }

    @Generated
    public String getCorreo() {
        return this.correo;
    }

    @Generated
    public String getNuevaContrasena() {
        return this.nuevaContrasena;
    }

    @Generated
    public TipoDocumento getTipoDoc() {
        return this.tipoDoc;
    }

    @Generated
    public String getNumeroDoc() {
        return this.numeroDoc;
    }

    @Generated
    public String getNombres() {
        return this.nombres;
    }

    @Generated
    public String getTelefono() {
        return this.telefono;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public void setRolId(Long rolId) {
        this.rolId = rolId;
    }

    @Generated
    public void setSedeIds(List<Long> sedeIds) {
        this.sedeIds = sedeIds;
    }

    @Generated
    public void setCorreo(String correo) {
        this.correo = correo;
    }

    @Generated
    public void setNuevaContrasena(String nuevaContrasena) {
        this.nuevaContrasena = nuevaContrasena;
    }

    @Generated
    public void setTipoDoc(TipoDocumento tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @Generated
    public void setNumeroDoc(String numeroDoc) {
        this.numeroDoc = numeroDoc;
    }

    @Generated
    public void setNombres(String nombres) {
        this.nombres = nombres;
    }

    @Generated
    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }
}

