/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.seguridad.controller;

import com.dulcecontrol.bakery.features.admin.seguridad.dto.PerfilUpdateRequest;
import com.dulcecontrol.bakery.features.admin.seguridad.dto.UsuarioResponse;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.service.IUsuarioAdminService;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/admin/perfil"})
public class PerfilController {
    private final IUsuarioAdminService usuarioService;
    private final UsuarioTiendaRepository usuarioTiendaRepository;

    private Long resolveUsuarioId(Authentication authentication) {
        String correo = authentication.getName();
        return this.usuarioTiendaRepository.findByCorreo(correo).map(usuario -> usuario.getId()).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<UsuarioResponse> obtenerMiPerfil(Authentication authentication) {
        Long usuarioId = this.resolveUsuarioId(authentication);
        UsuarioResponse perfil = this.usuarioService.obtenerMiPerfil(usuarioId);
        return ResponseEntity.ok((Object)perfil);
    }

    @PutMapping(value={"/me"})
    public ResponseEntity<UsuarioResponse> actualizarMiPerfil(Authentication authentication, @Valid @RequestBody PerfilUpdateRequest request) {
        Long usuarioId = this.resolveUsuarioId(authentication);
        UsuarioResponse perfil = this.usuarioService.actualizarMiPerfil(usuarioId, request);
        return ResponseEntity.ok((Object)perfil);
    }

    @Generated
    public PerfilController(IUsuarioAdminService usuarioService, UsuarioTiendaRepository usuarioTiendaRepository) {
        this.usuarioService = usuarioService;
        this.usuarioTiendaRepository = usuarioTiendaRepository;
    }
}

