/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.produccion.service.impl;

import com.dulcecontrol.bakery.features.admin.produccion.dto.StockIdealCreateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.dto.StockIdealResponse;
import com.dulcecontrol.bakery.features.admin.produccion.dto.StockIdealUpdateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.entity.StockIdeal;
import com.dulcecontrol.bakery.features.admin.produccion.repository.StockIdealRepository;
import com.dulcecontrol.bakery.features.admin.produccion.service.IStockIdealAdminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StockIdealAdminService
implements IStockIdealAdminService {
    private final StockIdealRepository stockIdealRepository;

    @Transactional(readOnly=true)
    public List<StockIdealResponse> listarPorTienda(Long tiendaId, Long sedeId) {
        List registros = sedeId == null ? this.stockIdealRepository.findByTiendaId(tiendaId) : this.stockIdealRepository.findByTiendaIdAndSedeId(tiendaId, sedeId);
        return registros.stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public StockIdealResponse obtenerPorId(Long tiendaId, Long stockId) {
        StockIdeal stockIdeal = this.obtenerEntidad(tiendaId, stockId);
        return this.toResponse(stockIdeal);
    }

    @Transactional
    public StockIdealResponse crear(Long tiendaId, StockIdealCreateRequest request) {
        this.validarUnicidad(tiendaId, null, request.getSedeId(), request.getProductoId());
        StockIdeal stockIdeal = new StockIdeal();
        stockIdeal.setTiendaId(tiendaId);
        stockIdeal.setSedeId(request.getSedeId());
        stockIdeal.setProductoId(request.getProductoId());
        stockIdeal.setCantidadIdeal(request.getCantidadIdeal());
        stockIdeal.setPuntoReposicion(request.getPuntoReposicion());
        StockIdeal guardado = (StockIdeal)this.stockIdealRepository.save((Object)stockIdeal);
        return this.toResponse(guardado);
    }

    @Transactional
    public StockIdealResponse actualizar(Long tiendaId, Long stockId, StockIdealUpdateRequest request) {
        StockIdeal stockIdeal = this.obtenerEntidad(tiendaId, stockId);
        this.validarUnicidad(tiendaId, stockId, request.getSedeId(), request.getProductoId());
        stockIdeal.setSedeId(request.getSedeId());
        stockIdeal.setProductoId(request.getProductoId());
        stockIdeal.setCantidadIdeal(request.getCantidadIdeal());
        stockIdeal.setPuntoReposicion(request.getPuntoReposicion());
        StockIdeal actualizado = (StockIdeal)this.stockIdealRepository.save((Object)stockIdeal);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long stockId) {
        StockIdeal stockIdeal = this.obtenerEntidad(tiendaId, stockId);
        this.stockIdealRepository.delete((Object)stockIdeal);
    }

    private void validarUnicidad(Long tiendaId, Long id, Long sedeId, Long productoId) {
        boolean existe;
        boolean bl = existe = id == null ? this.stockIdealRepository.existsByTiendaIdAndSedeIdAndProductoId(tiendaId, sedeId, productoId) : this.stockIdealRepository.existsByTiendaIdAndSedeIdAndProductoIdAndIdNot(tiendaId, sedeId, productoId, id);
        if (existe) {
            throw new BadRequestException("Ya existe un stock ideal configurado para este producto en la sede indicada");
        }
    }

    private StockIdeal obtenerEntidad(Long tiendaId, Long stockId) {
        return (StockIdeal)this.stockIdealRepository.findByIdAndTiendaId(stockId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("El registro de stock ideal solicitado no existe"));
    }

    private StockIdealResponse toResponse(StockIdeal stockIdeal) {
        return StockIdealResponse.builder().id(stockIdeal.getId()).tiendaId(stockIdeal.getTiendaId()).sedeId(stockIdeal.getSedeId()).productoId(stockIdeal.getProductoId()).cantidadIdeal(stockIdeal.getCantidadIdeal()).puntoReposicion(stockIdeal.getPuntoReposicion()).actualizadoEn(stockIdeal.getActualizadoEn()).build();
    }

    @Generated
    public StockIdealAdminService(StockIdealRepository stockIdealRepository) {
        this.stockIdealRepository = stockIdealRepository;
    }
}

