/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.produccion.service;

import com.dulcecontrol.bakery.features.admin.catalogo.entity.Producto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioInsumoSede;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.MovimientoInventarioInsumo;
import com.dulcecontrol.bakery.features.admin.inventario.entity.MovimientoInventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.MotivoMovimientoProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.TipoMovimientoInsumo;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioInsumoSedeRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioProductoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.MovimientoInventarioInsumoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.MovimientoInventarioProductoRepository;
import com.dulcecontrol.bakery.features.admin.produccion.dto.DetallePlanProduccionResponse;
import com.dulcecontrol.bakery.features.admin.produccion.dto.DetallePlanProduccionUpdateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.dto.PlanProduccionCreateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.dto.PlanProduccionResponse;
import com.dulcecontrol.bakery.features.admin.produccion.dto.PlanProduccionUpdateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.entity.DetallePlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.PlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.Receta;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.EstadoItemProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.EstadoPlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.OrigenItemProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.repository.DetallePlanProduccionRepository;
import com.dulcecontrol.bakery.features.admin.produccion.repository.PlanProduccionRepository;
import com.dulcecontrol.bakery.features.admin.produccion.repository.RecetaRepository;
import com.dulcecontrol.bakery.features.admin.ventas.entity.DetallePedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.Pedido;
import com.dulcecontrol.bakery.features.admin.ventas.entity.enums.EstadoPedido;
import com.dulcecontrol.bakery.features.admin.ventas.repository.DetallePedidoRepository;
import com.dulcecontrol.bakery.features.admin.ventas.repository.PedidoRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlanProduccionAdminService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PlanProduccionAdminService.class);
    private final PlanProduccionRepository planRepository;
    private final DetallePlanProduccionRepository detalleRepository;
    private final ProductoRepository productoRepository;
    private final RecetaRepository recetaRepository;
    private final InventarioInsumoSedeRepository inventarioInsumoRepository;
    private final InventarioProductoRepository inventarioProductoRepository;
    private final MovimientoInventarioInsumoRepository movimientoInsumoRepository;
    private final MovimientoInventarioProductoRepository movimientoProductoRepository;
    private final PedidoRepository pedidoRepository;
    private final DetallePedidoRepository detallePedidoRepository;

    @Transactional
    public PlanProduccionResponse createPlan(Long tiendaId, PlanProduccionCreateRequest request) {
        this.planRepository.findBySedeIdAndFechaProduccion(request.getSedeId(), request.getFechaProduccion()).ifPresent(plan -> {
            throw new IllegalStateException("Ya existe un plan de producci\u00f3n para esta sede y fecha");
        });
        PlanProduccion plan2 = new PlanProduccion();
        plan2.setTiendaId(tiendaId);
        plan2.setSedeId(request.getSedeId());
        plan2.setFechaProduccion(request.getFechaProduccion());
        plan2.setEstado(EstadoPlanProduccion.BORRADOR);
        plan2.setNotasMaestro(request.getNotasMaestro());
        PlanProduccion savedPlan = (PlanProduccion)this.planRepository.save((Object)plan2);
        if (request.getDetalles() != null && !request.getDetalles().isEmpty()) {
            List detalles = request.getDetalles().stream().map(item -> {
                DetallePlanProduccion detalle = new DetallePlanProduccion();
                detalle.setPlanId(savedPlan.getId());
                detalle.setProductoId(item.getProductoId());
                detalle.setOrigen(OrigenItemProduccion.STOCK_DIARIO);
                detalle.setEsPersonalizado(Boolean.FALSE);
                detalle.setCantidadSugerida(Integer.valueOf(item.getCantidadSugerida() != null ? item.getCantidadSugerida() : 0));
                detalle.setCantidadPlanificada(item.getCantidadPlanificada());
                detalle.setCantidadProducida(Integer.valueOf(0));
                detalle.setCantidadMerma(Integer.valueOf(0));
                detalle.setEstado(EstadoItemProduccion.PENDIENTE);
                detalle.setObservaciones(item.getObservaciones());
                return detalle;
            }).collect(Collectors.toList());
            this.detalleRepository.saveAll(detalles);
        }
        return this.getPlanBySedeAndFecha(tiendaId, request.getSedeId(), request.getFechaProduccion());
    }

    @Transactional(readOnly=true)
    public PlanProduccionResponse getPlanBySedeAndFecha(Long tiendaId, Long sedeId, LocalDate fecha) {
        PlanProduccion plan = (PlanProduccion)this.planRepository.findBySedeIdAndFechaProduccion(sedeId, fecha).orElseThrow(() -> new RuntimeException("No se encontr\u00f3 plan de producci\u00f3n para esta fecha"));
        if (!plan.getTiendaId().equals(tiendaId)) {
            throw new RuntimeException("Plan no pertenece a la tienda especificada");
        }
        List detalles = this.detalleRepository.findByPlanIdOrderByIdAsc(plan.getId());
        List productoIds = detalles.stream().map(DetallePlanProduccion::getProductoId).distinct().collect(Collectors.toList());
        Map productosMap = this.productoRepository.findAllById(productoIds).stream().collect(Collectors.toMap(Producto::getId, Function.identity()));
        List detallePedidoIds = detalles.stream().filter(d -> d.getDetallePedidoId() != null).map(DetallePlanProduccion::getDetallePedidoId).distinct().collect(Collectors.toList());
        Map notasClienteMap = detallePedidoIds.isEmpty() ? Map.of() : this.detallePedidoRepository.findAllById(detallePedidoIds).stream().filter(dp -> dp.getNotasItem() != null && !dp.getNotasItem().isBlank()).collect(Collectors.toMap(DetallePedido::getId, DetallePedido::getNotasItem));
        List detalleResponses = detalles.stream().map(d -> {
            Producto producto = (Producto)productosMap.get(d.getProductoId());
            String notasCliente = d.getDetallePedidoId() != null ? (String)notasClienteMap.get(d.getDetallePedidoId()) : null;
            return DetallePlanProduccionResponse.builder().id(d.getId()).planId(d.getPlanId()).productoId(d.getProductoId()).productoNombre(producto != null ? producto.getNombre() : "Producto desconocido").origen(d.getOrigen()).pedidoClienteId(d.getPedidoClienteId()).detallePedidoId(d.getDetallePedidoId()).esPersonalizado(d.getEsPersonalizado()).personalizacionId(d.getPersonalizacionId()).cantidadSugerida(d.getCantidadSugerida()).cantidadPlanificada(d.getCantidadPlanificada()).cantidadProducida(d.getCantidadProducida()).cantidadMerma(d.getCantidadMerma()).estado(d.getEstado()).horaTermino(d.getHoraTermino()).observaciones(d.getObservaciones()).notasCliente(notasCliente).build();
        }).collect(Collectors.toList());
        return PlanProduccionResponse.builder().id(plan.getId()).tiendaId(plan.getTiendaId()).sedeId(plan.getSedeId()).fechaProduccion(plan.getFechaProduccion()).estado(plan.getEstado()).generadoPor(plan.getGeneradoPor()).confirmadoPor(plan.getConfirmadoPor()).horaInicioReal(plan.getHoraInicioReal()).horaFinReal(plan.getHoraFinReal()).notasMaestro(plan.getNotasMaestro()).creadoEn(plan.getCreadoEn()).actualizadoEn(plan.getActualizadoEn()).detalles(detalleResponses).build();
    }

    @Transactional
    public PlanProduccionResponse updatePlan(Long tiendaId, Long planId, PlanProduccionUpdateRequest request) {
        PlanProduccion plan = (PlanProduccion)this.planRepository.findById((Object)planId).orElseThrow(() -> new RuntimeException("Plan no encontrado"));
        if (!plan.getTiendaId().equals(tiendaId)) {
            throw new RuntimeException("Plan no pertenece a la tienda especificada");
        }
        EstadoPlanProduccion estadoAnterior = plan.getEstado();
        if (request.getEstado() != null) {
            plan.setEstado(request.getEstado());
            if (request.getEstado() == EstadoPlanProduccion.EN_PROCESO && plan.getHoraInicioReal() == null) {
                plan.setHoraInicioReal(LocalDateTime.now());
            }
            if (request.getEstado() == EstadoPlanProduccion.FINALIZADO && plan.getHoraFinReal() == null) {
                plan.setHoraFinReal(LocalDateTime.now());
            }
        }
        if (request.getNotasMaestro() != null) {
            plan.setNotasMaestro(request.getNotasMaestro());
        }
        this.planRepository.save((Object)plan);
        if (request.getEstado() == EstadoPlanProduccion.FINALIZADO && estadoAnterior != EstadoPlanProduccion.FINALIZADO) {
            this.registrarMovimientosInventarioAlFinalizar(tiendaId, plan);
            this.actualizarEstadoPedidosAsociados(plan);
        }
        return this.getPlanBySedeAndFecha(tiendaId, plan.getSedeId(), plan.getFechaProduccion());
    }

    @Transactional
    public DetallePlanProduccionResponse updateDetalle(Long tiendaId, Long detalleId, DetallePlanProduccionUpdateRequest request) {
        DetallePlanProduccion detalle = (DetallePlanProduccion)this.detalleRepository.findById((Object)detalleId).orElseThrow(() -> new RuntimeException("Detalle no encontrado"));
        PlanProduccion plan = (PlanProduccion)this.planRepository.findById((Object)detalle.getPlanId()).orElseThrow(() -> new RuntimeException("Plan no encontrado"));
        if (!plan.getTiendaId().equals(tiendaId)) {
            throw new RuntimeException("Detalle no pertenece a la tienda especificada");
        }
        if (plan.getEstado() != EstadoPlanProduccion.EN_PROCESO) {
            throw new RuntimeException("Solo se pueden editar detalles cuando el plan est\u00e1 EN_PROCESO. Estado actual: " + String.valueOf(plan.getEstado()));
        }
        EstadoItemProduccion estadoAnterior = detalle.getEstado();
        if (request.getCantidadProducida() != null) {
            detalle.setCantidadProducida(request.getCantidadProducida());
        }
        if (request.getCantidadMerma() != null) {
            detalle.setCantidadMerma(request.getCantidadMerma());
        }
        if (request.getEstado() != null) {
            detalle.setEstado(request.getEstado());
            if (request.getEstado() == EstadoItemProduccion.TERMINADO && detalle.getHoraTermino() == null) {
                detalle.setHoraTermino(LocalDateTime.now());
            }
        }
        if (request.getObservaciones() != null) {
            detalle.setObservaciones(request.getObservaciones());
        }
        DetallePlanProduccion saved = (DetallePlanProduccion)this.detalleRepository.save((Object)detalle);
        if (request.getEstado() != null && request.getEstado() != estadoAnterior && request.getEstado() == EstadoItemProduccion.EN_HORNO && estadoAnterior != EstadoItemProduccion.EN_HORNO) {
            this.descontarInsumosProduccion(tiendaId, plan.getSedeId(), saved);
        }
        Producto producto = this.productoRepository.findById((Object)saved.getProductoId()).orElse(null);
        String notasCliente = null;
        if (saved.getDetallePedidoId() != null) {
            notasCliente = this.detallePedidoRepository.findById((Object)saved.getDetallePedidoId()).map(DetallePedido::getNotasItem).filter(nota -> nota != null && !nota.isBlank()).orElse(null);
        }
        return DetallePlanProduccionResponse.builder().id(saved.getId()).planId(saved.getPlanId()).productoId(saved.getProductoId()).productoNombre(producto != null ? producto.getNombre() : "Producto desconocido").origen(saved.getOrigen()).pedidoClienteId(saved.getPedidoClienteId()).detallePedidoId(saved.getDetallePedidoId()).esPersonalizado(saved.getEsPersonalizado()).personalizacionId(saved.getPersonalizacionId()).cantidadSugerida(saved.getCantidadSugerida()).cantidadPlanificada(saved.getCantidadPlanificada()).cantidadProducida(saved.getCantidadProducida()).cantidadMerma(saved.getCantidadMerma()).estado(saved.getEstado()).horaTermino(saved.getHoraTermino()).observaciones(saved.getObservaciones()).notasCliente(notasCliente).build();
    }

    @Transactional
    public List<PlanProduccionResponse> listPlanesByTienda(Long tiendaId, Long sedeId) {
        Optional planMananaOpt;
        LocalDate manana = LocalDate.now().plusDays(1L);
        if (sedeId != null && (planMananaOpt = this.planRepository.findBySedeIdAndFechaProduccion(sedeId, manana)).isEmpty()) {
            log.info("\ud83c\udf86 No existe plan para ma\u00f1ana ({}) en sede {}. Generando autom\u00e1ticamente...", (Object)manana, (Object)sedeId);
            PlanProduccion planManana = new PlanProduccion();
            planManana.setTiendaId(tiendaId);
            planManana.setSedeId(sedeId);
            planManana.setFechaProduccion(manana);
            planManana.setEstado(EstadoPlanProduccion.BORRADOR);
            planManana.setNotasMaestro("Plan generado autom\u00e1ticamente para el d\u00eda siguiente");
            this.planRepository.save((Object)planManana);
            log.info("\u2705 Plan para ma\u00f1ana generado autom\u00e1ticamente");
        }
        List planes = sedeId != null ? this.planRepository.findByTiendaIdAndSedeIdOrderByFechaProduccionDesc(tiendaId, sedeId) : this.planRepository.findByTiendaIdOrderByFechaProduccionDesc(tiendaId);
        List planIds = planes.stream().map(PlanProduccion::getId).collect(Collectors.toList());
        List todosDetalles = planIds.isEmpty() ? List.of() : this.detalleRepository.findByPlanIdInOrderByPlanIdAscIdAsc(planIds);
        Map<Long, List<DetallePlanProduccion>> detallesPorPlan = todosDetalles.stream().collect(Collectors.groupingBy(DetallePlanProduccion::getPlanId));
        List productoIds = todosDetalles.stream().map(DetallePlanProduccion::getProductoId).distinct().collect(Collectors.toList());
        Map productosMap = productoIds.isEmpty() ? Map.of() : this.productoRepository.findAllById(productoIds).stream().collect(Collectors.toMap(Producto::getId, Function.identity()));
        List detallePedidoIds = todosDetalles.stream().filter(d -> d.getDetallePedidoId() != null).map(DetallePlanProduccion::getDetallePedidoId).distinct().collect(Collectors.toList());
        Map notasClienteMap = detallePedidoIds.isEmpty() ? Map.of() : this.detallePedidoRepository.findAllById(detallePedidoIds).stream().filter(dp -> dp.getNotasItem() != null && !dp.getNotasItem().isBlank()).collect(Collectors.toMap(DetallePedido::getId, DetallePedido::getNotasItem));
        return planes.stream().map(plan -> {
            List detalles = detallesPorPlan.getOrDefault(plan.getId(), List.of());
            List detalleResponses = detalles.stream().map(d -> {
                Producto producto = (Producto)productosMap.get(d.getProductoId());
                String notasCliente = d.getDetallePedidoId() != null ? (String)notasClienteMap.get(d.getDetallePedidoId()) : null;
                return DetallePlanProduccionResponse.builder().id(d.getId()).planId(d.getPlanId()).productoId(d.getProductoId()).productoNombre(producto != null ? producto.getNombre() : "Producto desconocido").origen(d.getOrigen()).pedidoClienteId(d.getPedidoClienteId()).detallePedidoId(d.getDetallePedidoId()).esPersonalizado(d.getEsPersonalizado()).personalizacionId(d.getPersonalizacionId()).cantidadSugerida(d.getCantidadSugerida()).cantidadPlanificada(d.getCantidadPlanificada()).cantidadProducida(d.getCantidadProducida()).cantidadMerma(d.getCantidadMerma()).estado(d.getEstado()).horaTermino(d.getHoraTermino()).observaciones(d.getObservaciones()).notasCliente(notasCliente).build();
            }).collect(Collectors.toList());
            return PlanProduccionResponse.builder().id(plan.getId()).tiendaId(plan.getTiendaId()).sedeId(plan.getSedeId()).fechaProduccion(plan.getFechaProduccion()).estado(plan.getEstado()).generadoPor(plan.getGeneradoPor()).confirmadoPor(plan.getConfirmadoPor()).horaInicioReal(plan.getHoraInicioReal()).horaFinReal(plan.getHoraFinReal()).notasMaestro(plan.getNotasMaestro()).creadoEn(plan.getCreadoEn()).actualizadoEn(plan.getActualizadoEn()).detalles(detalleResponses).build();
        }).collect(Collectors.toList());
    }

    private void registrarMovimientosInventarioAlFinalizar(Long tiendaId, PlanProduccion plan) {
        log.info("\ud83d\udce6 Plan {} finalizado. Registrando movimientos de inventario basados en cantidad planificada...", (Object)plan.getId());
        List detalles = this.detalleRepository.findByPlanIdOrderByIdAsc(plan.getId());
        for (DetallePlanProduccion detalle : detalles) {
            if (detalle.getCantidadPlanificada() != null && detalle.getCantidadPlanificada() > 0) {
                this.sumarProductosInventarioPorPlanificado(tiendaId, plan.getSedeId(), detalle);
            }
            if (detalle.getCantidadMerma() == null || detalle.getCantidadMerma() <= 0) continue;
            this.registrarMovimientoMerma(tiendaId, plan.getSedeId(), detalle);
        }
        log.info("\u2705 Movimientos de inventario registrados para plan {}", (Object)plan.getId());
    }

    private void registrarMovimientoMerma(Long tiendaId, Long sedeId, DetallePlanProduccion detalle) {
        log.info("\u26a0\ufe0f Registrando merma de {} unidades del producto {}", (Object)detalle.getCantidadMerma(), (Object)detalle.getProductoId());
        MovimientoInventarioProducto movimiento = new MovimientoInventarioProducto();
        movimiento.setTiendaId(tiendaId);
        movimiento.setSedeId(sedeId);
        movimiento.setProductoId(detalle.getProductoId());
        movimiento.setTipoMovimiento(TipoMovimientoInsumo.SALIDA);
        movimiento.setCantidad(detalle.getCantidadMerma());
        movimiento.setPlanProduccionId(detalle.getPlanId());
        movimiento.setMotivo(MotivoMovimientoProducto.MERMA);
        Optional inventarioOpt = this.inventarioProductoRepository.findBySedeIdAndProductoId(sedeId, detalle.getProductoId());
        if (inventarioOpt.isPresent()) {
            InventarioProducto inventario = (InventarioProducto)inventarioOpt.get();
            movimiento.setCantidadAnterior(inventario.getCantidadActual());
            movimiento.setCantidadPosterior(inventario.getCantidadActual());
        } else {
            movimiento.setCantidadAnterior(Integer.valueOf(0));
            movimiento.setCantidadPosterior(Integer.valueOf(0));
        }
        this.movimientoProductoRepository.save((Object)movimiento);
        log.info("\u2705 Movimiento de merma registrado");
    }

    private void descontarInsumosProduccion(Long tiendaId, Long sedeId, DetallePlanProduccion detalle) {
        log.info("\ud83d\udd25 Producto {} pasa a EN_HORNO. Descontando insumos...", (Object)detalle.getProductoId());
        List recetas = this.recetaRepository.findByTiendaIdAndProductoId(tiendaId, detalle.getProductoId());
        if (recetas.isEmpty()) {
            log.warn("\u26a0\ufe0f No hay receta configurada para producto {}", (Object)detalle.getProductoId());
            return;
        }
        Integer cantidadAPlanificar = detalle.getCantidadPlanificada();
        for (Receta receta : recetas) {
            BigDecimal cantidadPorUnidad = receta.getCantidadRequerida();
            BigDecimal cantidadTotal = cantidadPorUnidad.multiply(BigDecimal.valueOf(cantidadAPlanificar.intValue()));
            Optional inventarioOpt = this.inventarioInsumoRepository.findBySedeIdAndInsumoId(sedeId, receta.getInsumoId());
            if (inventarioOpt.isEmpty()) {
                log.error("\u274c No se encontr\u00f3 inventario del insumo {} en sede {}", (Object)receta.getInsumoId(), (Object)sedeId);
                continue;
            }
            InventarioInsumoSede inventario = (InventarioInsumoSede)inventarioOpt.get();
            BigDecimal cantidadActual = inventario.getCantidadActual();
            if (cantidadActual.compareTo(cantidadTotal) < 0) {
                log.warn("\u26a0\ufe0f Inventario insuficiente del insumo {}. Disponible: {}, Requerido: {}", new Object[]{receta.getInsumoId(), cantidadActual, cantidadTotal});
            }
            BigDecimal cantidadNueva = cantidadActual.subtract(cantidadTotal);
            inventario.setCantidadActual(cantidadNueva);
            this.inventarioInsumoRepository.save((Object)inventario);
            MovimientoInventarioInsumo movimiento = new MovimientoInventarioInsumo();
            movimiento.setTiendaId(tiendaId);
            movimiento.setSedeId(sedeId);
            movimiento.setInsumoId(receta.getInsumoId());
            movimiento.setTipoMovimiento(TipoMovimientoInsumo.SALIDA);
            movimiento.setCantidad(cantidadTotal);
            movimiento.setCantidadAnterior(cantidadActual);
            movimiento.setCantidadPosterior(cantidadNueva);
            movimiento.setPlanProduccionId(detalle.getPlanId());
            movimiento.setMotivo("Consumo para producci\u00f3n de " + cantidadAPlanificar + " unidades del producto #" + detalle.getProductoId());
            this.movimientoInsumoRepository.save((Object)movimiento);
            log.info("\u2705 Descontado {} {} del insumo {}. Stock anterior: {}, Stock actual: {}", new Object[]{cantidadTotal, receta.getUnidadMedida(), receta.getInsumoId(), cantidadActual, cantidadNueva});
        }
    }

    private void sumarProductosInventarioPorPlanificado(Long tiendaId, Long sedeId, DetallePlanProduccion detalle) {
        InventarioProducto inventario;
        log.info("\u2705 Plan finalizado. Sumando cantidad planificada al inventario para producto {}...", (Object)detalle.getProductoId());
        Integer cantidadPlanificada = detalle.getCantidadPlanificada();
        if (cantidadPlanificada == null || cantidadPlanificada <= 0) {
            log.warn("\u26a0\ufe0f Cantidad planificada no v\u00e1lida: {}", (Object)cantidadPlanificada);
            return;
        }
        Optional inventarioOpt = this.inventarioProductoRepository.findBySedeIdAndProductoId(sedeId, detalle.getProductoId());
        if (inventarioOpt.isPresent()) {
            inventario = (InventarioProducto)inventarioOpt.get();
        } else {
            log.info("\ud83d\udce6 Creando nuevo registro de inventario para producto {} en sede {}", (Object)detalle.getProductoId(), (Object)sedeId);
            inventario = new InventarioProducto();
            inventario.setTiendaId(tiendaId);
            inventario.setSedeId(sedeId);
            inventario.setProductoId(detalle.getProductoId());
            inventario.setCantidadActual(Integer.valueOf(0));
        }
        Integer cantidadAnterior = inventario.getCantidadActual();
        Integer cantidadNueva = cantidadAnterior + cantidadPlanificada;
        inventario.setCantidadActual(cantidadNueva);
        this.inventarioProductoRepository.save((Object)inventario);
        MovimientoInventarioProducto movimiento = new MovimientoInventarioProducto();
        movimiento.setTiendaId(tiendaId);
        movimiento.setSedeId(sedeId);
        movimiento.setProductoId(detalle.getProductoId());
        movimiento.setTipoMovimiento(TipoMovimientoInsumo.ENTRADA);
        movimiento.setCantidad(cantidadPlanificada);
        movimiento.setCantidadAnterior(cantidadAnterior);
        movimiento.setCantidadPosterior(cantidadNueva);
        movimiento.setPlanProduccionId(detalle.getPlanId());
        movimiento.setMotivo(MotivoMovimientoProducto.PRODUCCION);
        this.movimientoProductoRepository.save((Object)movimiento);
        log.info("\u2705 Sumado {} unidades (planificadas) al inventario del producto {}. Stock anterior: {}, Stock actual: {}", new Object[]{cantidadPlanificada, detalle.getProductoId(), cantidadAnterior, cantidadNueva});
    }

    private void actualizarEstadoPedidosAsociados(PlanProduccion plan) {
        log.info("\ud83d\udccb Verificando pedidos asociados al plan {} para cambiar estado a LISTO_ENTREGA", (Object)plan.getId());
        List detalles = this.detalleRepository.findByPlanIdOrderByIdAsc(plan.getId());
        List<Long> pedidoIds = detalles.stream().filter(d -> d.getOrigen() == OrigenItemProduccion.PEDIDO_CLIENTE).filter(d -> d.getPedidoClienteId() != null).map(DetallePlanProduccion::getPedidoClienteId).distinct().toList();
        if (pedidoIds.isEmpty()) {
            log.info("\u2139\ufe0f No hay pedidos asociados a este plan");
            return;
        }
        for (Long pedidoId : pedidoIds) {
            Optional pedidoOpt = this.pedidoRepository.findById((Object)pedidoId);
            if (!pedidoOpt.isPresent()) continue;
            Pedido pedido = (Pedido)pedidoOpt.get();
            if (pedido.getEstadoPedido() == EstadoPedido.EN_PREPARACION) {
                pedido.setEstadoPedido(EstadoPedido.LISTO_ENTREGA);
                this.pedidoRepository.save((Object)pedido);
                log.info("\u2705 Pedido {} cambiado a LISTO_ENTREGA", (Object)pedido.getCodigoPedido());
                continue;
            }
            log.info("\u2139\ufe0f Pedido {} no est\u00e1 en EN_PREPARACION (estado actual: {}), no se cambia", (Object)pedido.getCodigoPedido(), (Object)pedido.getEstadoPedido());
        }
        log.info("\u2705 Procesados {} pedidos asociados al plan", (Object)pedidoIds.size());
    }

    @Generated
    public PlanProduccionAdminService(PlanProduccionRepository planRepository, DetallePlanProduccionRepository detalleRepository, ProductoRepository productoRepository, RecetaRepository recetaRepository, InventarioInsumoSedeRepository inventarioInsumoRepository, InventarioProductoRepository inventarioProductoRepository, MovimientoInventarioInsumoRepository movimientoInsumoRepository, MovimientoInventarioProductoRepository movimientoProductoRepository, PedidoRepository pedidoRepository, DetallePedidoRepository detallePedidoRepository) {
        this.planRepository = planRepository;
        this.detalleRepository = detalleRepository;
        this.productoRepository = productoRepository;
        this.recetaRepository = recetaRepository;
        this.inventarioInsumoRepository = inventarioInsumoRepository;
        this.inventarioProductoRepository = inventarioProductoRepository;
        this.movimientoInsumoRepository = movimientoInsumoRepository;
        this.movimientoProductoRepository = movimientoProductoRepository;
        this.pedidoRepository = pedidoRepository;
        this.detallePedidoRepository = detallePedidoRepository;
    }
}

