/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.produccion.entity;

import com.dulcecontrol.bakery.features.admin.produccion.entity.converter.EstadoPlanProduccionConverter;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.EstadoPlanProduccion;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="planes_produccion", uniqueConstraints={@UniqueConstraint(name="uk_planes_sede_fecha", columnNames={"sede_id", "fecha_produccion"})})
public class PlanProduccion {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="sede_id", nullable=false)
    private Long sedeId;
    @Column(name="fecha_produccion", nullable=false)
    private LocalDate fechaProduccion;
    @Convert(converter=EstadoPlanProduccionConverter.class)
    @Column(name="estado", nullable=false, length=20)
    private EstadoPlanProduccion estado;
    @Column(name="generado_por")
    private Long generadoPor;
    @Column(name="confirmado_por")
    private Long confirmadoPor;
    @Column(name="hora_inicio_real")
    private LocalDateTime horaInicioReal;
    @Column(name="hora_fin_real")
    private LocalDateTime horaFinReal;
    @Column(name="notas_maestro")
    private String notasMaestro;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        LocalDateTime now;
        this.creadoEn = now = LocalDateTime.now();
        this.actualizadoEn = now;
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getSedeId() {
        return this.sedeId;
    }

    @Generated
    public LocalDate getFechaProduccion() {
        return this.fechaProduccion;
    }

    @Generated
    public EstadoPlanProduccion getEstado() {
        return this.estado;
    }

    @Generated
    public Long getGeneradoPor() {
        return this.generadoPor;
    }

    @Generated
    public Long getConfirmadoPor() {
        return this.confirmadoPor;
    }

    @Generated
    public LocalDateTime getHoraInicioReal() {
        return this.horaInicioReal;
    }

    @Generated
    public LocalDateTime getHoraFinReal() {
        return this.horaFinReal;
    }

    @Generated
    public String getNotasMaestro() {
        return this.notasMaestro;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setSedeId(Long sedeId) {
        this.sedeId = sedeId;
    }

    @Generated
    public void setFechaProduccion(LocalDate fechaProduccion) {
        this.fechaProduccion = fechaProduccion;
    }

    @Generated
    public void setEstado(EstadoPlanProduccion estado) {
        this.estado = estado;
    }

    @Generated
    public void setGeneradoPor(Long generadoPor) {
        this.generadoPor = generadoPor;
    }

    @Generated
    public void setConfirmadoPor(Long confirmadoPor) {
        this.confirmadoPor = confirmadoPor;
    }

    @Generated
    public void setHoraInicioReal(LocalDateTime horaInicioReal) {
        this.horaInicioReal = horaInicioReal;
    }

    @Generated
    public void setHoraFinReal(LocalDateTime horaFinReal) {
        this.horaFinReal = horaFinReal;
    }

    @Generated
    public void setNotasMaestro(String notasMaestro) {
        this.notasMaestro = notasMaestro;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }
}

