/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.produccion.controller;

import com.dulcecontrol.bakery.features.admin.produccion.dto.DetallePlanProduccionResponse;
import com.dulcecontrol.bakery.features.admin.produccion.dto.DetallePlanProduccionUpdateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.dto.PlanProduccionCreateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.dto.PlanProduccionResponse;
import com.dulcecontrol.bakery.features.admin.produccion.dto.PlanProduccionUpdateRequest;
import com.dulcecontrol.bakery.features.admin.produccion.service.PlanProduccionAdminService;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/produccion/planes-produccion"})
@Validated
public class PlanProduccionAdminController {
    private final PlanProduccionAdminService planService;

    @PostMapping
    public ResponseEntity<PlanProduccionResponse> crearPlan(@PathVariable Long tiendaId, @Valid @RequestBody PlanProduccionCreateRequest request) {
        PlanProduccionResponse response = this.planService.createPlan(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @GetMapping
    public ResponseEntity<List<PlanProduccionResponse>> listarPlanes(@PathVariable Long tiendaId, @RequestParam(required=false) Long sedeId) {
        List planes = this.planService.listPlanesByTienda(tiendaId, sedeId);
        return ResponseEntity.ok((Object)planes);
    }

    @GetMapping(value={"/{fecha}/detalles"})
    public ResponseEntity<PlanProduccionResponse> obtenerPlanChecklist(@PathVariable Long tiendaId, @PathVariable @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fecha, @RequestParam Long sedeId) {
        PlanProduccionResponse response = this.planService.getPlanBySedeAndFecha(tiendaId, sedeId, fecha);
        return ResponseEntity.ok((Object)response);
    }

    @PatchMapping(value={"/{planId}"})
    public ResponseEntity<PlanProduccionResponse> actualizarPlan(@PathVariable Long tiendaId, @PathVariable Long planId, @Valid @RequestBody PlanProduccionUpdateRequest request) {
        PlanProduccionResponse response = this.planService.updatePlan(tiendaId, planId, request);
        return ResponseEntity.ok((Object)response);
    }

    @PatchMapping(value={"/detalles/{detalleId}"})
    public ResponseEntity<DetallePlanProduccionResponse> actualizarDetalle(@PathVariable Long tiendaId, @PathVariable Long detalleId, @Valid @RequestBody DetallePlanProduccionUpdateRequest request) {
        DetallePlanProduccionResponse response = this.planService.updateDetalle(tiendaId, detalleId, request);
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public PlanProduccionAdminController(PlanProduccionAdminService planService) {
        this.planService = planService;
    }
}

