/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.inventario.service.impl;

import com.dulcecontrol.bakery.features.admin.catalogo.entity.Producto;
import com.dulcecontrol.bakery.features.admin.inventario.dto.MovimientoInventarioProductoCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.MovimientoInventarioProductoResponse;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.MovimientoInventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.entity.enums.TipoMovimientoInsumo;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioProductoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.repository.MovimientoInventarioProductoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.service.IMovimientoInventarioProductoService;
import com.dulcecontrol.bakery.features.admin.inventario.service.impl.MovimientoInventarioProductoService;
import com.dulcecontrol.bakery.features.admin.produccion.entity.DetallePlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.PlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.StockIdeal;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.EstadoItemProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.EstadoPlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.OrigenItemProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.repository.DetallePlanProduccionRepository;
import com.dulcecontrol.bakery.features.admin.produccion.repository.PlanProduccionRepository;
import com.dulcecontrol.bakery.features.admin.produccion.repository.StockIdealRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.entity.UsuarioTienda;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MovimientoInventarioProductoService
implements IMovimientoInventarioProductoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MovimientoInventarioProductoService.class);
    private final MovimientoInventarioProductoRepository repository;
    private final InventarioProductoRepository inventarioRepository;
    private final ProductoRepository productoRepository;
    private final UsuarioTiendaRepository usuarioRepository;
    private final StockIdealRepository stockIdealRepository;
    private final PlanProduccionRepository planProduccionRepository;
    private final DetallePlanProduccionRepository detallePlanProduccionRepository;
    private ThreadLocal<Long> planGeneradoIdThreadLocal = new ThreadLocal();

    @Transactional(readOnly=true)
    public List<MovimientoInventarioProductoResponse> listarPorTienda(Long tiendaId) {
        return this.repository.findByTiendaId(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<MovimientoInventarioProductoResponse> listarPorTiendaYSede(Long tiendaId, Long sedeId) {
        return this.repository.findByTiendaIdAndSedeId(tiendaId, sedeId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public Page<MovimientoInventarioProductoResponse> listarPorTiendaYSedePaginado(Long tiendaId, Long sedeId, Pageable pageable) {
        return this.repository.findByTiendaIdAndSedeIdOrderByCreadoEnDesc(tiendaId, sedeId, pageable).map(arg_0 -> this.toResponse(arg_0));
    }

    @Transactional(readOnly=true)
    public MovimientoInventarioProductoResponse obtenerPorId(Long tiendaId, Long id) {
        MovimientoInventarioProducto movimiento = (MovimientoInventarioProducto)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Movimiento de inventario no encontrado"));
        return this.toResponse(movimiento);
    }

    @Transactional
    public MovimientoInventarioProductoResponse crear(Long tiendaId, MovimientoInventarioProductoCreateRequest request) {
        Integer nuevaCantidad;
        this.planGeneradoIdThreadLocal.remove();
        InventarioProducto inventario = this.inventarioRepository.findBySedeIdAndProductoId(request.getSedeId(), request.getProductoId()).orElseGet(() -> {
            InventarioProducto nuevo = new InventarioProducto();
            nuevo.setTiendaId(tiendaId);
            nuevo.setSedeId(request.getSedeId());
            nuevo.setProductoId(request.getProductoId());
            nuevo.setCantidadActual(Integer.valueOf(0));
            return (InventarioProducto)this.inventarioRepository.save((Object)nuevo);
        });
        Integer cantidadAnterior = inventario.getCantidadActual();
        switch (1.$SwitchMap$com$dulcecontrol$bakery$features$admin$inventario$entity$enums$TipoMovimientoInsumo[request.getTipoMovimiento().ordinal()]) {
            case 1: {
                nuevaCantidad = cantidadAnterior + request.getCantidad();
                break;
            }
            case 2: {
                nuevaCantidad = cantidadAnterior - request.getCantidad();
                if (nuevaCantidad >= 0) break;
                throw new BadRequestException("No hay suficiente stock. Stock actual: " + cantidadAnterior);
            }
            case 3: {
                nuevaCantidad = request.getCantidad();
                break;
            }
            case 4: {
                if (request.getCantidad() > 0) {
                    nuevaCantidad = cantidadAnterior + request.getCantidad();
                    break;
                }
                nuevaCantidad = cantidadAnterior + request.getCantidad();
                if (nuevaCantidad >= 0) break;
                throw new BadRequestException("No hay suficiente stock para la transferencia. Stock actual: " + cantidadAnterior);
            }
            default: {
                throw new BadRequestException("Tipo de movimiento no v\u00e1lido");
            }
        }
        inventario.setCantidadActual(nuevaCantidad);
        this.inventarioRepository.save((Object)inventario);
        if (request.getTipoMovimiento() == TipoMovimientoInsumo.SALIDA) {
            this.verificarYGenerarPlanificacionAutomatica(tiendaId, inventario, cantidadAnterior, nuevaCantidad);
        }
        MovimientoInventarioProducto movimiento = new MovimientoInventarioProducto();
        movimiento.setTiendaId(tiendaId);
        movimiento.setSedeId(request.getSedeId());
        movimiento.setProductoId(request.getProductoId());
        movimiento.setTipoMovimiento(request.getTipoMovimiento());
        movimiento.setCantidad(request.getCantidad());
        movimiento.setCantidadAnterior(cantidadAnterior);
        movimiento.setCantidadPosterior(nuevaCantidad);
        movimiento.setPedidoId(request.getPedidoId());
        movimiento.setPlanProduccionId(request.getPlanProduccionId());
        movimiento.setMotivo(request.getMotivo());
        movimiento.setResponsableId(request.getResponsableId());
        MovimientoInventarioProducto guardado = (MovimientoInventarioProducto)this.repository.save((Object)movimiento);
        MovimientoInventarioProductoResponse response = this.toResponse(guardado);
        Long planGeneradoId = (Long)this.planGeneradoIdThreadLocal.get();
        response.setPlanificacionAutomaticaGenerada(Boolean.valueOf(planGeneradoId != null));
        response.setPlanGeneradoId(planGeneradoId);
        this.planGeneradoIdThreadLocal.remove();
        return response;
    }

    @Transactional(readOnly=true)
    public List<MovimientoInventarioProductoResponse> listarPorProducto(Long tiendaId, Long sedeId, Long productoId) {
        return this.repository.findByTiendaIdAndSedeIdAndProductoId(tiendaId, sedeId, productoId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<MovimientoInventarioProductoResponse> listarPorRangoFechas(Long tiendaId, LocalDateTime inicio, LocalDateTime fin) {
        if (inicio == null || fin == null) {
            return this.listarPorTienda(tiendaId);
        }
        return this.repository.findByTiendaIdAndCreadoEnBetween(tiendaId, inicio, fin).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    private MovimientoInventarioProductoResponse toResponse(MovimientoInventarioProducto entity) {
        Producto producto = this.productoRepository.findById((Object)entity.getProductoId()).orElse(null);
        String usuarioResponsable = null;
        if (entity.getResponsableId() != null) {
            usuarioResponsable = this.usuarioRepository.findById((Object)entity.getResponsableId()).map(UsuarioTienda::getNombres).orElse(null);
        }
        return MovimientoInventarioProductoResponse.builder().id(entity.getId()).sedeId(entity.getSedeId()).productoId(entity.getProductoId()).nombreProducto(producto != null ? producto.getNombre() : null).sku(producto != null ? producto.getSku() : null).tipoMovimiento(entity.getTipoMovimiento()).cantidad(entity.getCantidad()).cantidadAnterior(entity.getCantidadAnterior()).cantidadPosterior(entity.getCantidadPosterior()).pedidoId(entity.getPedidoId()).planProduccionId(entity.getPlanProduccionId()).motivo(entity.getMotivo()).responsableId(entity.getResponsableId()).usuarioResponsable(usuarioResponsable).creadoEn(entity.getCreadoEn()).build();
    }

    private void verificarYGenerarPlanificacionAutomatica(Long tiendaId, InventarioProducto inventario, Integer cantidadAnterior, Integer cantidadNueva) {
        DetallePlanProduccion detalle;
        PlanProduccion plan;
        log.info("\ud83d\udd0e [PLANIFICACION AUTO] Iniciando verificaci\u00f3n - Producto: {}, Sede: {}, TiendaId: {}", new Object[]{inventario.getProductoId(), inventario.getSedeId(), tiendaId});
        Optional stockIdealOpt = this.stockIdealRepository.findByTiendaIdAndSedeIdAndProductoId(tiendaId, inventario.getSedeId(), inventario.getProductoId());
        if (stockIdealOpt.isEmpty()) {
            log.warn("\u274c [PLANIFICACION AUTO] No hay stock ideal configurado para producto {} en sede {}", (Object)inventario.getProductoId(), (Object)inventario.getSedeId());
            return;
        }
        StockIdeal stockIdeal = (StockIdeal)stockIdealOpt.get();
        log.info("\ud83d\udccb [PLANIFICACION AUTO] Stock Ideal encontrado - Cantidad ideal: {}, Punto reposici\u00f3n: {}", (Object)stockIdeal.getCantidadIdeal(), (Object)stockIdeal.getPuntoReposicion());
        if (stockIdeal.getPuntoReposicion() == null) {
            log.warn("\u274c [PLANIFICACION AUTO] No hay punto de reposici\u00f3n configurado para producto {} en sede {}", (Object)inventario.getProductoId(), (Object)inventario.getSedeId());
            return;
        }
        log.info("\u2696\ufe0f [PLANIFICACION AUTO] Comparando: Stock nuevo ({}) vs Punto reposici\u00f3n ({})", (Object)cantidadNueva, (Object)stockIdeal.getPuntoReposicion());
        if (cantidadNueva > stockIdeal.getPuntoReposicion()) {
            log.info("\u270b [PLANIFICACION AUTO] Stock ({}) a\u00fan est\u00e1 por encima del punto de reposici\u00f3n ({}). No se genera plan.", (Object)cantidadNueva, (Object)stockIdeal.getPuntoReposicion());
            return;
        }
        log.info("\u26a0\ufe0f Stock de producto {} en sede {} alcanz\u00f3 punto de reposici\u00f3n. Stock actual: {}, Punto reposici\u00f3n: {}", new Object[]{inventario.getProductoId(), inventario.getSedeId(), cantidadNueva, stockIdeal.getPuntoReposicion()});
        Integer cantidadAPlanificar = stockIdeal.getCantidadIdeal() - cantidadNueva;
        if (cantidadAPlanificar <= 0) {
            log.warn("La cantidad a planificar es 0 o negativa. Stock ideal: {}, Stock actual: {}", (Object)stockIdeal.getCantidadIdeal(), (Object)cantidadNueva);
            return;
        }
        LocalDate fechaProduccion = LocalDate.now().plusDays(1L);
        Optional planOpt = this.planProduccionRepository.findBySedeIdAndFechaProduccion(inventario.getSedeId(), fechaProduccion);
        if (planOpt.isPresent()) {
            plan = (PlanProduccion)planOpt.get();
            if (plan.getEstado() == EstadoPlanProduccion.FINALIZADO) {
                log.info("\ud83d\udd04 Plan para {} est\u00e1 FINALIZADO. Reabriendo a CONFIRMADO para agregar nuevos productos...", (Object)fechaProduccion);
                plan.setEstado(EstadoPlanProduccion.CONFIRMADO);
                plan.setNotasMaestro((String)(plan.getNotasMaestro() != null ? plan.getNotasMaestro() + " | " : "") + "Reabierto autom\u00e1ticamente por reposici\u00f3n de stock");
                plan = (PlanProduccion)this.planProduccionRepository.save((Object)plan);
            } else {
                log.info("\ud83d\udccb Plan existente encontrado para fecha {} (estado: {})", (Object)fechaProduccion, (Object)plan.getEstado());
            }
        } else {
            log.info("\ud83c\udf86 Creando nuevo plan de producci\u00f3n autom\u00e1tico para sede {} fecha {}", (Object)inventario.getSedeId(), (Object)fechaProduccion);
            plan = new PlanProduccion();
            plan.setTiendaId(tiendaId);
            plan.setSedeId(inventario.getSedeId());
            plan.setFechaProduccion(fechaProduccion);
            plan.setEstado(EstadoPlanProduccion.CONFIRMADO);
            plan.setNotasMaestro("Plan generado autom\u00e1ticamente por reposici\u00f3n de stock");
            plan = (PlanProduccion)this.planProduccionRepository.save((Object)plan);
        }
        List detallesExistentes = this.detallePlanProduccionRepository.findByPlanIdOrderByIdAsc(plan.getId());
        Optional<DetallePlanProduccion> detalleExistenteOpt = detallesExistentes.stream().filter(d -> d.getProductoId().equals(inventario.getProductoId()) && d.getOrigen() == OrigenItemProduccion.STOCK_DIARIO).findFirst();
        if (detalleExistenteOpt.isPresent()) {
            detalle = detalleExistenteOpt.get();
            Integer cantidadPlanificadaAnterior = detalle.getCantidadPlanificada();
            Integer cantidadProducidaAnterior = detalle.getCantidadProducida();
            log.info("\ud83d\udd04 Detalle existente encontrado para producto {}. Actualizando cantidades...", (Object)inventario.getProductoId());
            log.info("   Planificado anterior: {}, Producido anterior: {}", (Object)cantidadPlanificadaAnterior, (Object)cantidadProducidaAnterior);
            if (cantidadProducidaAnterior != null && cantidadProducidaAnterior > 0) {
                Integer stockActual = inventario.getCantidadActual();
                inventario.setCantidadActual(Integer.valueOf(stockActual - cantidadProducidaAnterior));
                this.inventarioRepository.save((Object)inventario);
                log.info("\u2b05\ufe0f Ajustando inventario: restando {} unidades producidas anteriormente. Stock: {} -> {}", new Object[]{cantidadProducidaAnterior, stockActual, inventario.getCantidadActual()});
            }
            detalle.setCantidadSugerida(cantidadAPlanificar);
            detalle.setCantidadPlanificada(cantidadAPlanificar);
            detalle.setCantidadProducida(Integer.valueOf(0));
            detalle.setCantidadMerma(Integer.valueOf(0));
            detalle.setEstado(EstadoItemProduccion.PENDIENTE);
            detalle.setObservaciones(String.format("Reposici\u00f3n autom\u00e1tica (actualizado). Stock actual: %d, Stock ideal: %d, Punto reposici\u00f3n: %d", cantidadNueva, stockIdeal.getCantidadIdeal(), stockIdeal.getPuntoReposicion()));
            log.info("\u270f\ufe0f Planificado actualizado: {} -> {} (debe llegar a ideal {})", new Object[]{cantidadPlanificadaAnterior, detalle.getCantidadPlanificada(), stockIdeal.getCantidadIdeal()});
        } else {
            log.info("\u2795 Creando nuevo detalle de planificaci\u00f3n para producto {}", (Object)inventario.getProductoId());
            detalle = new DetallePlanProduccion();
            detalle.setPlanId(plan.getId());
            detalle.setProductoId(inventario.getProductoId());
            detalle.setOrigen(OrigenItemProduccion.STOCK_DIARIO);
            detalle.setEsPersonalizado(Boolean.valueOf(false));
            detalle.setCantidadSugerida(cantidadAPlanificar);
            detalle.setCantidadPlanificada(cantidadAPlanificar);
            detalle.setCantidadProducida(Integer.valueOf(0));
            detalle.setCantidadMerma(Integer.valueOf(0));
            detalle.setEstado(EstadoItemProduccion.PENDIENTE);
            detalle.setObservaciones(String.format("Reposici\u00f3n autom\u00e1tica. Stock actual: %d, Stock ideal: %d, Punto reposici\u00f3n: %d", cantidadNueva, stockIdeal.getCantidadIdeal(), stockIdeal.getPuntoReposicion()));
        }
        this.detallePlanProduccionRepository.save((Object)detalle);
        this.planGeneradoIdThreadLocal.set(plan.getId());
        log.info("\u2705 \ud83c\udf89 Planificaci\u00f3n autom\u00e1tica creada: {} unidades de producto {} para fecha {}", new Object[]{cantidadAPlanificar, inventario.getProductoId(), fechaProduccion});
    }

    @Generated
    public MovimientoInventarioProductoService(MovimientoInventarioProductoRepository repository, InventarioProductoRepository inventarioRepository, ProductoRepository productoRepository, UsuarioTiendaRepository usuarioRepository, StockIdealRepository stockIdealRepository, PlanProduccionRepository planProduccionRepository, DetallePlanProduccionRepository detallePlanProduccionRepository) {
        this.repository = repository;
        this.inventarioRepository = inventarioRepository;
        this.productoRepository = productoRepository;
        this.usuarioRepository = usuarioRepository;
        this.stockIdealRepository = stockIdealRepository;
        this.planProduccionRepository = planProduccionRepository;
        this.detallePlanProduccionRepository = detallePlanProduccionRepository;
    }
}

