/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.inventario.service.impl;

import com.dulcecontrol.bakery.features.admin.catalogo.entity.Categoria;
import com.dulcecontrol.bakery.features.admin.catalogo.entity.Producto;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioProductoCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioProductoResponse;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioProductoUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.UbicacionFisicaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.entity.InventarioProducto;
import com.dulcecontrol.bakery.features.admin.inventario.repository.InventarioProductoRepository;
import com.dulcecontrol.bakery.features.admin.inventario.service.IInventarioProductoService;
import com.dulcecontrol.bakery.features.admin.produccion.entity.DetallePlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.PlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.StockIdeal;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.EstadoItemProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.EstadoPlanProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.entity.enums.OrigenItemProduccion;
import com.dulcecontrol.bakery.features.admin.produccion.repository.DetallePlanProduccionRepository;
import com.dulcecontrol.bakery.features.admin.produccion.repository.PlanProduccionRepository;
import com.dulcecontrol.bakery.features.admin.produccion.repository.StockIdealRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.CategoriaRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InventarioProductoService
implements IInventarioProductoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InventarioProductoService.class);
    private final InventarioProductoRepository repository;
    private final ProductoRepository productoRepository;
    private final CategoriaRepository categoriaRepository;
    private final StockIdealRepository stockIdealRepository;
    private final PlanProduccionRepository planProduccionRepository;
    private final DetallePlanProduccionRepository detallePlanProduccionRepository;

    @Transactional(readOnly=true)
    public List<InventarioProductoResponse> listarPorTienda(Long tiendaId) {
        return this.repository.findByTiendaId(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public List<InventarioProductoResponse> listarPorTiendaYSede(Long tiendaId, Long sedeId) {
        return this.repository.findByTiendaIdAndSedeId(tiendaId, sedeId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public InventarioProductoResponse obtenerPorId(Long tiendaId, Long id) {
        InventarioProducto inventario = (InventarioProducto)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Inventario de producto no encontrado"));
        return this.toResponse(inventario);
    }

    @Transactional
    public InventarioProductoResponse crear(Long tiendaId, InventarioProductoCreateRequest request) {
        if (this.repository.existsBySedeIdAndProductoId(request.getSedeId(), request.getProductoId())) {
            throw new BadRequestException("Ya existe un inventario para este producto en la sede");
        }
        InventarioProducto inventario = new InventarioProducto();
        inventario.setTiendaId(tiendaId);
        inventario.setSedeId(request.getSedeId());
        inventario.setProductoId(request.getProductoId());
        inventario.setCantidadActual(Integer.valueOf(request.getCantidadActual() != null ? request.getCantidadActual() : 0));
        inventario.setUbicacionFisica(request.getUbicacionFisica());
        InventarioProducto guardado = (InventarioProducto)this.repository.save((Object)inventario);
        return this.toResponse(guardado);
    }

    @Transactional
    public InventarioProductoResponse actualizar(Long tiendaId, Long id, InventarioProductoUpdateRequest request) {
        InventarioProducto inventario = (InventarioProducto)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Inventario de producto no encontrado"));
        Integer cantidadAnterior = inventario.getCantidadActual();
        Integer cantidadNueva = request.getCantidadActual();
        log.info("\ud83d\udcca Actualizando inventario - Producto: {}, Sede: {}, Stock anterior: {}, Stock nuevo: {}", new Object[]{inventario.getProductoId(), inventario.getSedeId(), cantidadAnterior, cantidadNueva});
        inventario.setCantidadActual(cantidadNueva);
        inventario.setUbicacionFisica(request.getUbicacionFisica());
        InventarioProducto actualizado = (InventarioProducto)this.repository.save((Object)inventario);
        log.info("\ud83d\udd0d Verificando punto de reposici\u00f3n para producto {}...", (Object)actualizado.getProductoId());
        this.verificarYGenerarPlanificacionAutomatica(tiendaId, actualizado, cantidadAnterior, cantidadNueva);
        return this.toResponse(actualizado);
    }

    @Transactional
    public InventarioProductoResponse actualizarUbicacion(Long tiendaId, Long id, UbicacionFisicaUpdateRequest request) {
        String ubicacion;
        InventarioProducto inventario = (InventarioProducto)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Inventario de producto no encontrado"));
        String string = ubicacion = request != null ? request.getUbicacionFisica() : null;
        if (ubicacion != null && (ubicacion = ubicacion.trim()).isBlank()) {
            ubicacion = null;
        }
        inventario.setUbicacionFisica(ubicacion);
        InventarioProducto actualizado = (InventarioProducto)this.repository.save((Object)inventario);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long id) {
        InventarioProducto inventario = (InventarioProducto)this.repository.findByIdAndTiendaId(id, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Inventario de producto no encontrado"));
        this.repository.delete((Object)inventario);
    }

    @Transactional(readOnly=true)
    public List<InventarioProductoResponse> listarBajoStock(Long tiendaId, Long sedeId, Integer cantidadMinima) {
        return this.repository.findBajoStock(tiendaId, sedeId, cantidadMinima).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    private InventarioProductoResponse toResponse(InventarioProducto entity) {
        Producto producto = this.productoRepository.findById((Object)entity.getProductoId()).orElse(null);
        String nombreProducto = producto != null ? producto.getNombre() : "Producto no encontrado";
        String sku = producto != null ? producto.getSku() : null;
        String categoriaNombre = null;
        if (producto != null && producto.getCategoriaId() != null) {
            categoriaNombre = this.categoriaRepository.findById((Object)producto.getCategoriaId()).map(Categoria::getNombre).orElse(null);
        }
        Optional stockIdealOpt = this.stockIdealRepository.findByTiendaIdAndSedeIdAndProductoId(entity.getTiendaId(), entity.getSedeId(), entity.getProductoId());
        Integer stockIdeal = stockIdealOpt.map(StockIdeal::getCantidadIdeal).orElse(null);
        String estadoStock = this.calcularEstadoStock(entity.getCantidadActual(), stockIdeal);
        return InventarioProductoResponse.builder().id(entity.getId()).sedeId(entity.getSedeId()).productoId(entity.getProductoId()).cantidadActual(entity.getCantidadActual()).ubicacionFisica(entity.getUbicacionFisica()).actualizadoEn(entity.getActualizadoEn()).nombreProducto(nombreProducto).sku(sku).stockIdeal(stockIdeal).estadoStock(estadoStock).categoriaNombre(categoriaNombre).build();
    }

    private String calcularEstadoStock(Integer cantidadActual, Integer stockIdeal) {
        if (stockIdeal == null) {
            return "SIN_CONFIGURAR";
        }
        double porcentaje = (double)cantidadActual.intValue() / (double)stockIdeal.intValue();
        if (porcentaje >= 0.8) {
            return "OK";
        }
        if (porcentaje >= 0.2) {
            return "BAJO_STOCK";
        }
        return "CRITICO";
    }

    private void verificarYGenerarPlanificacionAutomatica(Long tiendaId, InventarioProducto inventario, Integer cantidadAnterior, Integer cantidadNueva) {
        log.info("\ud83d\udd0e [PLANIFICACION AUTO] Iniciando verificaci\u00f3n - Producto: {}, Sede: {}, TiendaId: {}", new Object[]{inventario.getProductoId(), inventario.getSedeId(), tiendaId});
        Optional stockIdealOpt = this.stockIdealRepository.findByTiendaIdAndSedeIdAndProductoId(tiendaId, inventario.getSedeId(), inventario.getProductoId());
        if (stockIdealOpt.isEmpty()) {
            log.warn("\u274c [PLANIFICACION AUTO] No hay stock ideal configurado para producto {} en sede {}", (Object)inventario.getProductoId(), (Object)inventario.getSedeId());
            return;
        }
        StockIdeal stockIdeal = (StockIdeal)stockIdealOpt.get();
        log.info("\ud83d\udccb [PLANIFICACION AUTO] Stock Ideal encontrado - Cantidad ideal: {}, Punto reposici\u00f3n: {}", (Object)stockIdeal.getCantidadIdeal(), (Object)stockIdeal.getPuntoReposicion());
        if (stockIdeal.getPuntoReposicion() == null) {
            log.warn("\u274c [PLANIFICACION AUTO] No hay punto de reposici\u00f3n configurado para producto {} en sede {}", (Object)inventario.getProductoId(), (Object)inventario.getSedeId());
            return;
        }
        log.info("\u2696\ufe0f [PLANIFICACION AUTO] Comparando: Stock nuevo ({}) vs Punto reposici\u00f3n ({})", (Object)cantidadNueva, (Object)stockIdeal.getPuntoReposicion());
        if (cantidadNueva > stockIdeal.getPuntoReposicion()) {
            log.info("\u270b [PLANIFICACION AUTO] Stock ({}) a\u00fan est\u00e1 por encima del punto de reposici\u00f3n ({}). No se genera plan.", (Object)cantidadNueva, (Object)stockIdeal.getPuntoReposicion());
            return;
        }
        log.info("Stock de producto {} en sede {} alcanz\u00f3 punto de reposici\u00f3n. Stock actual: {}, Punto reposici\u00f3n: {}", new Object[]{inventario.getProductoId(), inventario.getSedeId(), cantidadNueva, stockIdeal.getPuntoReposicion()});
        Integer cantidadAPlanificar = stockIdeal.getCantidadIdeal() - cantidadNueva;
        if (cantidadAPlanificar <= 0) {
            log.warn("La cantidad a planificar es 0 o negativa. Stock ideal: {}, Stock actual: {}", (Object)stockIdeal.getCantidadIdeal(), (Object)cantidadNueva);
            return;
        }
        LocalDate fechaProduccion = LocalDate.now().plusDays(1L);
        PlanProduccion plan = this.planProduccionRepository.findBySedeIdAndFechaProduccion(inventario.getSedeId(), fechaProduccion).orElseGet(() -> {
            log.info("Creando nuevo plan de producci\u00f3n autom\u00e1tico para sede {} fecha {}", (Object)inventario.getSedeId(), (Object)fechaProduccion);
            PlanProduccion nuevoPlan = new PlanProduccion();
            nuevoPlan.setTiendaId(tiendaId);
            nuevoPlan.setSedeId(inventario.getSedeId());
            nuevoPlan.setFechaProduccion(fechaProduccion);
            nuevoPlan.setEstado(EstadoPlanProduccion.CONFIRMADO);
            nuevoPlan.setNotasMaestro("Plan generado autom\u00e1ticamente por reposici\u00f3n de stock");
            return (PlanProduccion)this.planProduccionRepository.save((Object)nuevoPlan);
        });
        List detallesExistentes = this.detallePlanProduccionRepository.findByPlanIdOrderByIdAsc(plan.getId());
        boolean yaExisteDetalle = detallesExistentes.stream().anyMatch(d -> d.getProductoId().equals(inventario.getProductoId()) && d.getOrigen() == OrigenItemProduccion.STOCK_DIARIO);
        if (yaExisteDetalle) {
            log.info("Ya existe un detalle de planificaci\u00f3n para producto {} en el plan {}", (Object)inventario.getProductoId(), (Object)plan.getId());
            return;
        }
        DetallePlanProduccion detalle = new DetallePlanProduccion();
        detalle.setPlanId(plan.getId());
        detalle.setProductoId(inventario.getProductoId());
        detalle.setOrigen(OrigenItemProduccion.STOCK_DIARIO);
        detalle.setEsPersonalizado(Boolean.valueOf(false));
        detalle.setCantidadSugerida(cantidadAPlanificar);
        detalle.setCantidadPlanificada(cantidadAPlanificar);
        detalle.setCantidadProducida(Integer.valueOf(0));
        detalle.setCantidadMerma(Integer.valueOf(0));
        detalle.setEstado(EstadoItemProduccion.PENDIENTE);
        detalle.setObservaciones(String.format("Reposici\u00f3n autom\u00e1tica. Stock actual: %d, Stock ideal: %d, Punto reposici\u00f3n: %d", cantidadNueva, stockIdeal.getCantidadIdeal(), stockIdeal.getPuntoReposicion()));
        this.detallePlanProduccionRepository.save((Object)detalle);
        log.info("\u2705 Planificaci\u00f3n autom\u00e1tica creada: {} unidades de producto {} para fecha {}", new Object[]{cantidadAPlanificar, inventario.getProductoId(), fechaProduccion});
    }

    @Generated
    public InventarioProductoService(InventarioProductoRepository repository, ProductoRepository productoRepository, CategoriaRepository categoriaRepository, StockIdealRepository stockIdealRepository, PlanProduccionRepository planProduccionRepository, DetallePlanProduccionRepository detallePlanProduccionRepository) {
        this.repository = repository;
        this.productoRepository = productoRepository;
        this.categoriaRepository = categoriaRepository;
        this.stockIdealRepository = stockIdealRepository;
        this.planProduccionRepository = planProduccionRepository;
        this.detallePlanProduccionRepository = detallePlanProduccionRepository;
    }
}

