/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.inventario.controller;

import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioInsumoSedeCreateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioInsumoSedeResponse;
import com.dulcecontrol.bakery.features.admin.inventario.dto.InventarioInsumoSedeUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.dto.UbicacionFisicaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.inventario.service.IInventarioInsumoSedeService;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/inventario/insumos"})
@Validated
public class InventarioInsumoSedeController {
    private final IInventarioInsumoSedeService service;

    @GetMapping
    public ResponseEntity<List<InventarioInsumoSedeResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.service.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/sede/{sedeId}"})
    public ResponseEntity<List<InventarioInsumoSedeResponse>> listarPorSede(@PathVariable Long tiendaId, @PathVariable Long sedeId) {
        return ResponseEntity.ok((Object)this.service.listarPorTiendaYSede(tiendaId, sedeId));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<InventarioInsumoSedeResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long id) {
        return ResponseEntity.ok((Object)this.service.obtenerPorId(tiendaId, id));
    }

    @GetMapping(value={"/sede/{sedeId}/bajo-stock"})
    public ResponseEntity<List<InventarioInsumoSedeResponse>> listarBajoStock(@PathVariable Long tiendaId, @PathVariable Long sedeId, @RequestParam(defaultValue="10") BigDecimal cantidadMinima) {
        return ResponseEntity.ok((Object)this.service.listarBajoStock(tiendaId, sedeId, cantidadMinima));
    }

    @PostMapping
    public ResponseEntity<InventarioInsumoSedeResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody InventarioInsumoSedeCreateRequest request) {
        InventarioInsumoSedeResponse creado = this.service.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)creado);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<InventarioInsumoSedeResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long id, @Valid @RequestBody InventarioInsumoSedeUpdateRequest request) {
        InventarioInsumoSedeResponse actualizado = this.service.actualizar(tiendaId, id, request);
        return ResponseEntity.ok((Object)actualizado);
    }

    @PatchMapping(value={"/{id}/ubicacion"})
    public ResponseEntity<InventarioInsumoSedeResponse> actualizarUbicacion(@PathVariable Long tiendaId, @PathVariable Long id, @Valid @RequestBody UbicacionFisicaUpdateRequest request) {
        InventarioInsumoSedeResponse actualizado = this.service.actualizarUbicacion(tiendaId, id, request);
        return ResponseEntity.ok((Object)actualizado);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long id) {
        this.service.eliminar(tiendaId, id);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public InventarioInsumoSedeController(IInventarioInsumoSedeService service) {
        this.service = service;
    }
}

