/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.facturacion.dto;

import com.dulcecontrol.bakery.features.admin.facturacion.entity.enums.TipoComprobante;
import com.dulcecontrol.bakery.features.admin.facturacion.entity.enums.TipoDocumentoCliente;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import lombok.Generated;

public class TiendaComprobanteRequest {
    @NotNull(message="El tiendaId es obligatorio")
    private @NotNull(message="El tiendaId es obligatorio") Long tiendaId;
    @NotNull(message="El pedidoId es obligatorio")
    private @NotNull(message="El pedidoId es obligatorio") Long pedidoId;
    @NotNull(message="El serieId es obligatorio")
    private @NotNull(message="El serieId es obligatorio") Long serieId;
    @NotBlank(message="La raz\u00f3n social del emisor es obligatoria")
    private @NotBlank(message="La raz\u00f3n social del emisor es obligatoria") String emisorRazonSocial;
    @NotBlank(message="El RUC del emisor es obligatorio")
    @Pattern(regexp="^\\d{11}$", message="El RUC debe tener 11 d\u00edgitos")
    private @NotBlank(message="El RUC del emisor es obligatorio") @Pattern(regexp="^\\d{11}$", message="El RUC debe tener 11 d\u00edgitos") String emisorRuc;
    @NotBlank(message="La direcci\u00f3n del emisor es obligatoria")
    private @NotBlank(message="La direcci\u00f3n del emisor es obligatoria") String emisorDireccion;
    @NotNull(message="El tipo de documento del cliente es obligatorio")
    private @NotNull(message="El tipo de documento del cliente es obligatorio") TipoDocumentoCliente clienteTipoDoc;
    @NotBlank(message="El n\u00famero de documento del cliente es obligatorio")
    @Size(max=20, message="El n\u00famero de documento no puede exceder 20 caracteres")
    private @NotBlank(message="El n\u00famero de documento del cliente es obligatorio") @Size(max=20, message="El n\u00famero de documento no puede exceder 20 caracteres") String clienteNumeroDoc;
    @NotBlank(message="El nombre del cliente es obligatorio")
    private @NotBlank(message="El nombre del cliente es obligatorio") String clienteNombre;
    private String clienteDireccion;
    @NotNull(message="El tipo de comprobante es obligatorio")
    private @NotNull(message="El tipo de comprobante es obligatorio") TipoComprobante tipoComprobante;
    @NotNull(message="El correlativo es obligatorio")
    @Min(value=1L, message="El correlativo debe ser mayor a 0")
    private @NotNull(message="El correlativo es obligatorio") @Min(value=1L, message="El correlativo debe ser mayor a 0") Integer correlativo;
    private LocalDateTime fechaEmision;
    @Size(min=3, max=3, message="La moneda debe tener 3 caracteres")
    private @Size(min=3, max=3, message="La moneda debe tener 3 caracteres") String moneda = "PEN";
    @Min(value=0L, message="El total gravado no puede ser negativo")
    private @Min(value=0L, message="El total gravado no puede ser negativo") Long totalGravadoCentimos = 0L;
    @Min(value=0L, message="El total inafecto no puede ser negativo")
    private @Min(value=0L, message="El total inafecto no puede ser negativo") Long totalInafectoCentimos = 0L;
    @Min(value=0L, message="El total exonerado no puede ser negativo")
    private @Min(value=0L, message="El total exonerado no puede ser negativo") Long totalExoneradoCentimos = 0L;
    @Min(value=0L, message="El IGV no puede ser negativo")
    private @Min(value=0L, message="El IGV no puede ser negativo") Long totalIgvCentimos = 0L;
    @Min(value=0L, message="Los impuestos a la bolsa no pueden ser negativos")
    private @Min(value=0L, message="Los impuestos a la bolsa no pueden ser negativos") Long totalImpuestosBolsaCentimos = 0L;
    @NotNull(message="El total del importe es obligatorio")
    @Min(value=0L, message="El total no puede ser negativo")
    private @NotNull(message="El total del importe es obligatorio") @Min(value=0L, message="El total no puede ser negativo") Long totalImporteCentimos;

    @Generated
    public TiendaComprobanteRequest() {
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getPedidoId() {
        return this.pedidoId;
    }

    @Generated
    public Long getSerieId() {
        return this.serieId;
    }

    @Generated
    public String getEmisorRazonSocial() {
        return this.emisorRazonSocial;
    }

    @Generated
    public String getEmisorRuc() {
        return this.emisorRuc;
    }

    @Generated
    public String getEmisorDireccion() {
        return this.emisorDireccion;
    }

    @Generated
    public TipoDocumentoCliente getClienteTipoDoc() {
        return this.clienteTipoDoc;
    }

    @Generated
    public String getClienteNumeroDoc() {
        return this.clienteNumeroDoc;
    }

    @Generated
    public String getClienteNombre() {
        return this.clienteNombre;
    }

    @Generated
    public String getClienteDireccion() {
        return this.clienteDireccion;
    }

    @Generated
    public TipoComprobante getTipoComprobante() {
        return this.tipoComprobante;
    }

    @Generated
    public Integer getCorrelativo() {
        return this.correlativo;
    }

    @Generated
    public LocalDateTime getFechaEmision() {
        return this.fechaEmision;
    }

    @Generated
    public String getMoneda() {
        return this.moneda;
    }

    @Generated
    public Long getTotalGravadoCentimos() {
        return this.totalGravadoCentimos;
    }

    @Generated
    public Long getTotalInafectoCentimos() {
        return this.totalInafectoCentimos;
    }

    @Generated
    public Long getTotalExoneradoCentimos() {
        return this.totalExoneradoCentimos;
    }

    @Generated
    public Long getTotalIgvCentimos() {
        return this.totalIgvCentimos;
    }

    @Generated
    public Long getTotalImpuestosBolsaCentimos() {
        return this.totalImpuestosBolsaCentimos;
    }

    @Generated
    public Long getTotalImporteCentimos() {
        return this.totalImporteCentimos;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setPedidoId(Long pedidoId) {
        this.pedidoId = pedidoId;
    }

    @Generated
    public void setSerieId(Long serieId) {
        this.serieId = serieId;
    }

    @Generated
    public void setEmisorRazonSocial(String emisorRazonSocial) {
        this.emisorRazonSocial = emisorRazonSocial;
    }

    @Generated
    public void setEmisorRuc(String emisorRuc) {
        this.emisorRuc = emisorRuc;
    }

    @Generated
    public void setEmisorDireccion(String emisorDireccion) {
        this.emisorDireccion = emisorDireccion;
    }

    @Generated
    public void setClienteTipoDoc(TipoDocumentoCliente clienteTipoDoc) {
        this.clienteTipoDoc = clienteTipoDoc;
    }

    @Generated
    public void setClienteNumeroDoc(String clienteNumeroDoc) {
        this.clienteNumeroDoc = clienteNumeroDoc;
    }

    @Generated
    public void setClienteNombre(String clienteNombre) {
        this.clienteNombre = clienteNombre;
    }

    @Generated
    public void setClienteDireccion(String clienteDireccion) {
        this.clienteDireccion = clienteDireccion;
    }

    @Generated
    public void setTipoComprobante(TipoComprobante tipoComprobante) {
        this.tipoComprobante = tipoComprobante;
    }

    @Generated
    public void setCorrelativo(Integer correlativo) {
        this.correlativo = correlativo;
    }

    @Generated
    public void setFechaEmision(LocalDateTime fechaEmision) {
        this.fechaEmision = fechaEmision;
    }

    @Generated
    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    @Generated
    public void setTotalGravadoCentimos(Long totalGravadoCentimos) {
        this.totalGravadoCentimos = totalGravadoCentimos;
    }

    @Generated
    public void setTotalInafectoCentimos(Long totalInafectoCentimos) {
        this.totalInafectoCentimos = totalInafectoCentimos;
    }

    @Generated
    public void setTotalExoneradoCentimos(Long totalExoneradoCentimos) {
        this.totalExoneradoCentimos = totalExoneradoCentimos;
    }

    @Generated
    public void setTotalIgvCentimos(Long totalIgvCentimos) {
        this.totalIgvCentimos = totalIgvCentimos;
    }

    @Generated
    public void setTotalImpuestosBolsaCentimos(Long totalImpuestosBolsaCentimos) {
        this.totalImpuestosBolsaCentimos = totalImpuestosBolsaCentimos;
    }

    @Generated
    public void setTotalImporteCentimos(Long totalImporteCentimos) {
        this.totalImporteCentimos = totalImporteCentimos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TiendaComprobanteRequest)) {
            return false;
        }
        TiendaComprobanteRequest other = (TiendaComprobanteRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Long this$pedidoId = this.getPedidoId();
        Long other$pedidoId = other.getPedidoId();
        if (this$pedidoId == null ? other$pedidoId != null : !((Object)this$pedidoId).equals(other$pedidoId)) {
            return false;
        }
        Long this$serieId = this.getSerieId();
        Long other$serieId = other.getSerieId();
        if (this$serieId == null ? other$serieId != null : !((Object)this$serieId).equals(other$serieId)) {
            return false;
        }
        Integer this$correlativo = this.getCorrelativo();
        Integer other$correlativo = other.getCorrelativo();
        if (this$correlativo == null ? other$correlativo != null : !((Object)this$correlativo).equals(other$correlativo)) {
            return false;
        }
        Long this$totalGravadoCentimos = this.getTotalGravadoCentimos();
        Long other$totalGravadoCentimos = other.getTotalGravadoCentimos();
        if (this$totalGravadoCentimos == null ? other$totalGravadoCentimos != null : !((Object)this$totalGravadoCentimos).equals(other$totalGravadoCentimos)) {
            return false;
        }
        Long this$totalInafectoCentimos = this.getTotalInafectoCentimos();
        Long other$totalInafectoCentimos = other.getTotalInafectoCentimos();
        if (this$totalInafectoCentimos == null ? other$totalInafectoCentimos != null : !((Object)this$totalInafectoCentimos).equals(other$totalInafectoCentimos)) {
            return false;
        }
        Long this$totalExoneradoCentimos = this.getTotalExoneradoCentimos();
        Long other$totalExoneradoCentimos = other.getTotalExoneradoCentimos();
        if (this$totalExoneradoCentimos == null ? other$totalExoneradoCentimos != null : !((Object)this$totalExoneradoCentimos).equals(other$totalExoneradoCentimos)) {
            return false;
        }
        Long this$totalIgvCentimos = this.getTotalIgvCentimos();
        Long other$totalIgvCentimos = other.getTotalIgvCentimos();
        if (this$totalIgvCentimos == null ? other$totalIgvCentimos != null : !((Object)this$totalIgvCentimos).equals(other$totalIgvCentimos)) {
            return false;
        }
        Long this$totalImpuestosBolsaCentimos = this.getTotalImpuestosBolsaCentimos();
        Long other$totalImpuestosBolsaCentimos = other.getTotalImpuestosBolsaCentimos();
        if (this$totalImpuestosBolsaCentimos == null ? other$totalImpuestosBolsaCentimos != null : !((Object)this$totalImpuestosBolsaCentimos).equals(other$totalImpuestosBolsaCentimos)) {
            return false;
        }
        Long this$totalImporteCentimos = this.getTotalImporteCentimos();
        Long other$totalImporteCentimos = other.getTotalImporteCentimos();
        if (this$totalImporteCentimos == null ? other$totalImporteCentimos != null : !((Object)this$totalImporteCentimos).equals(other$totalImporteCentimos)) {
            return false;
        }
        String this$emisorRazonSocial = this.getEmisorRazonSocial();
        String other$emisorRazonSocial = other.getEmisorRazonSocial();
        if (this$emisorRazonSocial == null ? other$emisorRazonSocial != null : !this$emisorRazonSocial.equals(other$emisorRazonSocial)) {
            return false;
        }
        String this$emisorRuc = this.getEmisorRuc();
        String other$emisorRuc = other.getEmisorRuc();
        if (this$emisorRuc == null ? other$emisorRuc != null : !this$emisorRuc.equals(other$emisorRuc)) {
            return false;
        }
        String this$emisorDireccion = this.getEmisorDireccion();
        String other$emisorDireccion = other.getEmisorDireccion();
        if (this$emisorDireccion == null ? other$emisorDireccion != null : !this$emisorDireccion.equals(other$emisorDireccion)) {
            return false;
        }
        TipoDocumentoCliente this$clienteTipoDoc = this.getClienteTipoDoc();
        TipoDocumentoCliente other$clienteTipoDoc = other.getClienteTipoDoc();
        if (this$clienteTipoDoc == null ? other$clienteTipoDoc != null : !this$clienteTipoDoc.equals(other$clienteTipoDoc)) {
            return false;
        }
        String this$clienteNumeroDoc = this.getClienteNumeroDoc();
        String other$clienteNumeroDoc = other.getClienteNumeroDoc();
        if (this$clienteNumeroDoc == null ? other$clienteNumeroDoc != null : !this$clienteNumeroDoc.equals(other$clienteNumeroDoc)) {
            return false;
        }
        String this$clienteNombre = this.getClienteNombre();
        String other$clienteNombre = other.getClienteNombre();
        if (this$clienteNombre == null ? other$clienteNombre != null : !this$clienteNombre.equals(other$clienteNombre)) {
            return false;
        }
        String this$clienteDireccion = this.getClienteDireccion();
        String other$clienteDireccion = other.getClienteDireccion();
        if (this$clienteDireccion == null ? other$clienteDireccion != null : !this$clienteDireccion.equals(other$clienteDireccion)) {
            return false;
        }
        TipoComprobante this$tipoComprobante = this.getTipoComprobante();
        TipoComprobante other$tipoComprobante = other.getTipoComprobante();
        if (this$tipoComprobante == null ? other$tipoComprobante != null : !this$tipoComprobante.equals(other$tipoComprobante)) {
            return false;
        }
        LocalDateTime this$fechaEmision = this.getFechaEmision();
        LocalDateTime other$fechaEmision = other.getFechaEmision();
        if (this$fechaEmision == null ? other$fechaEmision != null : !((Object)this$fechaEmision).equals(other$fechaEmision)) {
            return false;
        }
        String this$moneda = this.getMoneda();
        String other$moneda = other.getMoneda();
        return !(this$moneda == null ? other$moneda != null : !this$moneda.equals(other$moneda));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TiendaComprobanteRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Long $pedidoId = this.getPedidoId();
        result = result * 59 + ($pedidoId == null ? 43 : ((Object)$pedidoId).hashCode());
        Long $serieId = this.getSerieId();
        result = result * 59 + ($serieId == null ? 43 : ((Object)$serieId).hashCode());
        Integer $correlativo = this.getCorrelativo();
        result = result * 59 + ($correlativo == null ? 43 : ((Object)$correlativo).hashCode());
        Long $totalGravadoCentimos = this.getTotalGravadoCentimos();
        result = result * 59 + ($totalGravadoCentimos == null ? 43 : ((Object)$totalGravadoCentimos).hashCode());
        Long $totalInafectoCentimos = this.getTotalInafectoCentimos();
        result = result * 59 + ($totalInafectoCentimos == null ? 43 : ((Object)$totalInafectoCentimos).hashCode());
        Long $totalExoneradoCentimos = this.getTotalExoneradoCentimos();
        result = result * 59 + ($totalExoneradoCentimos == null ? 43 : ((Object)$totalExoneradoCentimos).hashCode());
        Long $totalIgvCentimos = this.getTotalIgvCentimos();
        result = result * 59 + ($totalIgvCentimos == null ? 43 : ((Object)$totalIgvCentimos).hashCode());
        Long $totalImpuestosBolsaCentimos = this.getTotalImpuestosBolsaCentimos();
        result = result * 59 + ($totalImpuestosBolsaCentimos == null ? 43 : ((Object)$totalImpuestosBolsaCentimos).hashCode());
        Long $totalImporteCentimos = this.getTotalImporteCentimos();
        result = result * 59 + ($totalImporteCentimos == null ? 43 : ((Object)$totalImporteCentimos).hashCode());
        String $emisorRazonSocial = this.getEmisorRazonSocial();
        result = result * 59 + ($emisorRazonSocial == null ? 43 : $emisorRazonSocial.hashCode());
        String $emisorRuc = this.getEmisorRuc();
        result = result * 59 + ($emisorRuc == null ? 43 : $emisorRuc.hashCode());
        String $emisorDireccion = this.getEmisorDireccion();
        result = result * 59 + ($emisorDireccion == null ? 43 : $emisorDireccion.hashCode());
        TipoDocumentoCliente $clienteTipoDoc = this.getClienteTipoDoc();
        result = result * 59 + ($clienteTipoDoc == null ? 43 : $clienteTipoDoc.hashCode());
        String $clienteNumeroDoc = this.getClienteNumeroDoc();
        result = result * 59 + ($clienteNumeroDoc == null ? 43 : $clienteNumeroDoc.hashCode());
        String $clienteNombre = this.getClienteNombre();
        result = result * 59 + ($clienteNombre == null ? 43 : $clienteNombre.hashCode());
        String $clienteDireccion = this.getClienteDireccion();
        result = result * 59 + ($clienteDireccion == null ? 43 : $clienteDireccion.hashCode());
        TipoComprobante $tipoComprobante = this.getTipoComprobante();
        result = result * 59 + ($tipoComprobante == null ? 43 : $tipoComprobante.hashCode());
        LocalDateTime $fechaEmision = this.getFechaEmision();
        result = result * 59 + ($fechaEmision == null ? 43 : ((Object)$fechaEmision).hashCode());
        String $moneda = this.getMoneda();
        result = result * 59 + ($moneda == null ? 43 : $moneda.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TiendaComprobanteRequest(tiendaId=" + this.getTiendaId() + ", pedidoId=" + this.getPedidoId() + ", serieId=" + this.getSerieId() + ", emisorRazonSocial=" + this.getEmisorRazonSocial() + ", emisorRuc=" + this.getEmisorRuc() + ", emisorDireccion=" + this.getEmisorDireccion() + ", clienteTipoDoc=" + String.valueOf(this.getClienteTipoDoc()) + ", clienteNumeroDoc=" + this.getClienteNumeroDoc() + ", clienteNombre=" + this.getClienteNombre() + ", clienteDireccion=" + this.getClienteDireccion() + ", tipoComprobante=" + String.valueOf(this.getTipoComprobante()) + ", correlativo=" + this.getCorrelativo() + ", fechaEmision=" + String.valueOf(this.getFechaEmision()) + ", moneda=" + this.getMoneda() + ", totalGravadoCentimos=" + this.getTotalGravadoCentimos() + ", totalInafectoCentimos=" + this.getTotalInafectoCentimos() + ", totalExoneradoCentimos=" + this.getTotalExoneradoCentimos() + ", totalIgvCentimos=" + this.getTotalIgvCentimos() + ", totalImpuestosBolsaCentimos=" + this.getTotalImpuestosBolsaCentimos() + ", totalImporteCentimos=" + this.getTotalImporteCentimos() + ")";
    }
}

