/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.facturacion.controller;

import com.dulcecontrol.bakery.features.admin.facturacion.dto.TiendaComprobanteRequest;
import com.dulcecontrol.bakery.features.admin.facturacion.dto.TiendaComprobanteResponse;
import com.dulcecontrol.bakery.features.admin.facturacion.entity.enums.EstadoSunat;
import com.dulcecontrol.bakery.features.admin.facturacion.entity.enums.TipoComprobante;
import com.dulcecontrol.bakery.features.admin.facturacion.service.TiendaComprobanteService;
import jakarta.validation.Valid;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/facturacion/comprobantes"})
public class TiendaComprobanteController {
    private final TiendaComprobanteService tiendaComprobanteService;

    @GetMapping
    public ResponseEntity<List<TiendaComprobanteResponse>> listar(@PathVariable Long tiendaId, @RequestParam(required=false) EstadoSunat estado, @RequestParam(required=false) TipoComprobante tipo, @RequestParam(required=false) Long serieId, @RequestParam(required=false) String clienteNumeroDoc, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fechaInicio, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime fechaFin) {
        if (serieId != null) {
            return ResponseEntity.ok((Object)this.tiendaComprobanteService.listarPorSerie(serieId));
        }
        if (clienteNumeroDoc != null) {
            return ResponseEntity.ok(this.tiendaComprobanteService.listarPorCliente(clienteNumeroDoc).stream().filter(comp -> comp.getTiendaId().equals(tiendaId)).toList());
        }
        if (estado != null && tipo != null) {
            return ResponseEntity.ok(this.tiendaComprobanteService.listarPorTiendaYEstado(tiendaId, estado).stream().filter(comp -> comp.getTipoComprobante() == tipo).toList());
        }
        if (estado != null) {
            return ResponseEntity.ok((Object)this.tiendaComprobanteService.listarPorTiendaYEstado(tiendaId, estado));
        }
        if (tipo != null) {
            return ResponseEntity.ok((Object)this.tiendaComprobanteService.listarPorTiendaYTipo(tiendaId, tipo));
        }
        if (fechaInicio != null && fechaFin != null) {
            return ResponseEntity.ok((Object)this.tiendaComprobanteService.listarPorTiendaYRangoFechas(tiendaId, fechaInicio, fechaFin));
        }
        return ResponseEntity.ok((Object)this.tiendaComprobanteService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/{comprobanteId}"})
    public ResponseEntity<TiendaComprobanteResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long comprobanteId) {
        TiendaComprobanteResponse response = this.tiendaComprobanteService.obtenerPorIdYTienda(comprobanteId, tiendaId);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/pedido/{pedidoId}"})
    public ResponseEntity<TiendaComprobanteResponse> obtenerPorPedido(@PathVariable Long tiendaId, @PathVariable Long pedidoId) {
        TiendaComprobanteResponse response = this.tiendaComprobanteService.obtenerPorPedidoIdYTienda(pedidoId, tiendaId);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping
    public ResponseEntity<TiendaComprobanteResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody TiendaComprobanteRequest request) {
        TiendaComprobanteResponse response = this.tiendaComprobanteService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{comprobanteId}"})
    public ResponseEntity<TiendaComprobanteResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long comprobanteId, @Valid @RequestBody TiendaComprobanteRequest request) {
        TiendaComprobanteResponse response = this.tiendaComprobanteService.actualizar(tiendaId, comprobanteId, request);
        return ResponseEntity.ok((Object)response);
    }

    @PatchMapping(value={"/{comprobanteId}/estado-sunat"})
    public ResponseEntity<TiendaComprobanteResponse> actualizarEstadoSunat(@PathVariable Long tiendaId, @PathVariable Long comprobanteId, @RequestBody Map<String, String> payload) {
        EstadoSunat nuevoEstado = EstadoSunat.fromValor((String)payload.get("estadoSunat"));
        String codigoRespuesta = payload.get("codigoRespuesta");
        String descripcionRespuesta = payload.get("descripcionRespuesta");
        TiendaComprobanteResponse response = this.tiendaComprobanteService.actualizarEstadoSunat(tiendaId, comprobanteId, nuevoEstado, codigoRespuesta, descripcionRespuesta);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/{comprobanteId}/enviar-sunat"})
    public ResponseEntity<TiendaComprobanteResponse> registrarEnvioSunat(@PathVariable Long tiendaId, @PathVariable Long comprobanteId, @RequestBody Map<String, String> payload) {
        String codigoHash = payload.get("codigoHash");
        String xmlUrl = payload.get("xmlUrl");
        String cdrUrl = payload.get("cdrUrl");
        String pdfUrl = payload.get("pdfUrl");
        TiendaComprobanteResponse response = this.tiendaComprobanteService.registrarEnvioSunat(tiendaId, comprobanteId, codigoHash, xmlUrl, cdrUrl, pdfUrl);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{comprobanteId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long comprobanteId) {
        this.tiendaComprobanteService.eliminar(tiendaId, comprobanteId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public TiendaComprobanteController(TiendaComprobanteService tiendaComprobanteService) {
        this.tiendaComprobanteService = tiendaComprobanteService;
    }
}

