/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.service;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.SedeCreateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.SedeResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.SedeUpdateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.repository.SedeAdminRepository;
import com.dulcecontrol.bakery.features.admin.configuracion.service.ISedeAdminService;
import com.dulcecontrol.bakery.features.shared.suscripciones.model.PlanLimites;
import com.dulcecontrol.bakery.features.shared.suscripciones.service.PlanLimitesService;
import com.dulcecontrol.bakery.features.shared.ubigeo.entity.UbigeoDistrito;
import com.dulcecontrol.bakery.features.shared.ubigeo.repository.UbigeoDistritoRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Sede;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Tienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.TiendaRepository;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SedeAdminService
implements ISedeAdminService {
    private final SedeAdminRepository sedeRepository;
    private final TiendaRepository tiendaRepository;
    private final UbigeoDistritoRepository distritoRepository;
    private final PlanLimitesService planLimitesService;

    @Transactional(readOnly=true)
    public List<SedeResponse> obtenerSedesPorTienda(Long tiendaId) {
        this.validarTiendaExiste(tiendaId);
        return this.sedeRepository.findByTiendaIdOrderByEsPrincipalDescNombreAsc(tiendaId).stream().map(arg_0 -> this.mapToResponse(arg_0)).collect(Collectors.toList());
    }

    @Transactional(readOnly=true)
    public SedeResponse obtenerSedePorId(Long tiendaId, Long sedeId) {
        Sede sede = (Sede)this.sedeRepository.findByIdAndTiendaId(sedeId, tiendaId).orElseThrow(() -> new IllegalArgumentException("Sede no encontrada"));
        return this.mapToResponse(sede);
    }

    @Transactional
    public SedeResponse crearSede(Long tiendaId, SedeCreateRequest request) {
        Boolean esPrincipal;
        Tienda tienda = this.validarTiendaExiste(tiendaId);
        if (this.sedeRepository.existsByTiendaIdAndNombre(tiendaId, request.getNombre())) {
            throw new IllegalArgumentException("Ya existe una sede con ese nombre");
        }
        if (this.sedeRepository.existsByTiendaIdAndCodigoInterno(tiendaId, request.getCodigoInterno())) {
            throw new IllegalArgumentException("Ya existe una sede con ese c\u00f3digo interno");
        }
        UbigeoDistrito distrito = (UbigeoDistrito)this.distritoRepository.findById((Object)request.getDistritoId()).orElseThrow(() -> new IllegalArgumentException("Distrito no encontrado"));
        this.validarLimiteSedesActivas(tiendaId);
        Boolean bl = esPrincipal = request.getEsPrincipal() != null ? request.getEsPrincipal() : Boolean.FALSE;
        if (esPrincipal.booleanValue() && this.sedeRepository.existsOtraSedePrincipal(tiendaId, Long.valueOf(0L))) {
            throw new IllegalArgumentException("Ya existe una sede principal. Desactiva la actual antes de crear una nueva");
        }
        Sede sede = Sede.builder().tienda(tienda).codigoInterno(request.getCodigoInterno()).nombre(request.getNombre()).direccion(request.getDireccion()).telefono(request.getTelefono()).distritoId(request.getDistritoId()).esPrincipal(esPrincipal).activo(Boolean.TRUE).build();
        sede = (Sede)this.sedeRepository.save((Object)sede);
        return this.mapToResponse(sede);
    }

    @Transactional
    public SedeResponse actualizarSede(Long tiendaId, Long sedeId, SedeUpdateRequest request) {
        Boolean esPrincipal;
        Sede sede = (Sede)this.sedeRepository.findByIdAndTiendaId(sedeId, tiendaId).orElseThrow(() -> new IllegalArgumentException("Sede no encontrada"));
        if (this.sedeRepository.existsByTiendaIdAndNombreAndIdNot(tiendaId, request.getNombre(), sedeId)) {
            throw new IllegalArgumentException("Ya existe otra sede con ese nombre");
        }
        if (this.sedeRepository.existsByTiendaIdAndCodigoInternoAndIdNot(tiendaId, request.getCodigoInterno(), sedeId)) {
            throw new IllegalArgumentException("Ya existe otra sede con ese c\u00f3digo interno");
        }
        UbigeoDistrito distrito = (UbigeoDistrito)this.distritoRepository.findById((Object)request.getDistritoId()).orElseThrow(() -> new IllegalArgumentException("Distrito no encontrado"));
        Boolean bl = esPrincipal = request.getEsPrincipal() != null ? request.getEsPrincipal() : Boolean.FALSE;
        if (esPrincipal.booleanValue() && !sede.getEsPrincipal().booleanValue() && this.sedeRepository.existsOtraSedePrincipal(tiendaId, sedeId)) {
            throw new IllegalArgumentException("Ya existe una sede principal. Desactiva la actual antes de marcar esta como principal");
        }
        if (Boolean.TRUE.equals(request.getActivo()) && Boolean.FALSE.equals(sede.getActivo())) {
            this.validarLimiteSedesActivas(tiendaId);
        }
        sede.setCodigoInterno(request.getCodigoInterno());
        sede.setNombre(request.getNombre());
        sede.setDireccion(request.getDireccion());
        sede.setTelefono(request.getTelefono());
        sede.setDistritoId(request.getDistritoId());
        sede.setActivo(request.getActivo());
        sede.setEsPrincipal(esPrincipal);
        sede = (Sede)this.sedeRepository.save((Object)sede);
        return this.mapToResponse(sede);
    }

    @Transactional
    public void desactivarSede(Long tiendaId, Long sedeId) {
        long otrasSedesActivas;
        Sede sede = (Sede)this.sedeRepository.findByIdAndTiendaId(sedeId, tiendaId).orElseThrow(() -> new IllegalArgumentException("Sede no encontrada"));
        if (sede.getEsPrincipal().booleanValue() && (otrasSedesActivas = this.sedeRepository.findByTiendaIdOrderByEsPrincipalDescNombreAsc(tiendaId).stream().filter(s -> !s.getId().equals(sedeId) && s.getActivo() != false).count()) > 0L) {
            throw new IllegalArgumentException("No se puede desactivar la sede principal mientras haya otras sedes activas");
        }
        sede.setActivo(Boolean.FALSE);
        this.sedeRepository.save((Object)sede);
    }

    @Transactional
    public void eliminarSede(Long tiendaId, Long sedeId) {
        Sede sede = (Sede)this.sedeRepository.findByIdAndTiendaId(sedeId, tiendaId).orElseThrow(() -> new IllegalArgumentException("Sede no encontrada"));
        if (sede.getEsPrincipal().booleanValue()) {
            throw new IllegalArgumentException("No se puede eliminar la sede principal");
        }
        this.sedeRepository.delete((Object)sede);
    }

    private Tienda validarTiendaExiste(Long tiendaId) {
        return (Tienda)this.tiendaRepository.findById((Object)tiendaId).orElseThrow(() -> new IllegalArgumentException("Tienda no encontrada"));
    }

    private SedeResponse mapToResponse(Sede sede) {
        UbigeoDistrito distrito;
        String distritoNombre = null;
        String provinciaNombre = null;
        String departamentoNombre = null;
        if (sede.getDistritoId() != null && (distrito = (UbigeoDistrito)this.distritoRepository.findById((Object)sede.getDistritoId()).orElse(null)) != null) {
            distritoNombre = distrito.getNombre();
            provinciaNombre = distrito.getProvincia().getNombre();
            departamentoNombre = distrito.getProvincia().getDepartamento().getNombre();
        }
        return SedeResponse.builder().id(sede.getId()).tiendaId(sede.getTienda().getId()).codigoInterno(sede.getCodigoInterno()).nombre(sede.getNombre()).direccion(sede.getDireccion()).telefono(sede.getTelefono()).distritoId(sede.getDistritoId()).distritoNombre(distritoNombre).provinciaNombre(provinciaNombre).departamentoNombre(departamentoNombre).esPrincipal(sede.getEsPrincipal()).activo(sede.getActivo()).creadoEn(sede.getCreadoEn()).actualizadoEn(sede.getActualizadoEn()).build();
    }

    private void validarLimiteSedesActivas(Long tiendaId) {
        PlanLimites limites = this.planLimitesService.obtenerLimitesVigentes(tiendaId);
        if (!limites.tieneLimiteSedes()) {
            return;
        }
        long sedesActivas = this.sedeRepository.countByTiendaIdAndActivoTrue(tiendaId);
        if (sedesActivas >= (long)limites.getMaxSedes().intValue()) {
            throw new IllegalArgumentException(String.format("Tu plan permite hasta %d sedes activas. Actualiza tu suscripci\u00f3n para habilitar m\u00e1s ubicaciones.", limites.getMaxSedes()));
        }
    }

    @Generated
    public SedeAdminService(SedeAdminRepository sedeRepository, TiendaRepository tiendaRepository, UbigeoDistritoRepository distritoRepository, PlanLimitesService planLimitesService) {
        this.sedeRepository = sedeRepository;
        this.tiendaRepository = tiendaRepository;
        this.distritoRepository = distritoRepository;
        this.planLimitesService = planLimitesService;
    }
}

