/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.entity;

import com.dulcecontrol.bakery.features.admin.configuracion.entity.enums.TipoContenido;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="paginas_storefront", uniqueConstraints={@UniqueConstraint(columnNames={"tienda_id", "slug"})})
@SQLDelete(sql="UPDATE paginas_storefront SET activa = false WHERE id = ?")
@SQLRestriction(value="activa = true")
public class PaginaStorefront {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(length=100, nullable=false)
    private String slug;
    @Column(length=255, nullable=false)
    private String titulo;
    @Column(columnDefinition="LONGTEXT", nullable=false)
    private String contenido;
    @Column(name="meta_descripcion", columnDefinition="TEXT")
    private String metaDescripcion;
    @Enumerated(value=EnumType.STRING)
    @Column(name="tipo_contenido", length=10)
    private TipoContenido tipoContenido = TipoContenido.HTML;
    @Column(name="orden_menu")
    private Integer ordenMenu = 0;
    @Column(name="visible_en_menu", nullable=false)
    private Boolean visibleEnMenu = true;
    @Column(nullable=false)
    private Boolean activa = true;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    protected void onCreate() {
        this.creadoEn = LocalDateTime.now();
        this.actualizadoEn = LocalDateTime.now();
        if (this.ordenMenu == null) {
            this.ordenMenu = 0;
        }
        if (this.visibleEnMenu == null) {
            this.visibleEnMenu = true;
        }
        if (this.activa == null) {
            this.activa = true;
        }
        if (this.tipoContenido == null) {
            this.tipoContenido = TipoContenido.HTML;
        }
    }

    @PreUpdate
    protected void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public PaginaStorefront() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public String getSlug() {
        return this.slug;
    }

    @Generated
    public String getTitulo() {
        return this.titulo;
    }

    @Generated
    public String getContenido() {
        return this.contenido;
    }

    @Generated
    public String getMetaDescripcion() {
        return this.metaDescripcion;
    }

    @Generated
    public TipoContenido getTipoContenido() {
        return this.tipoContenido;
    }

    @Generated
    public Integer getOrdenMenu() {
        return this.ordenMenu;
    }

    @Generated
    public Boolean getVisibleEnMenu() {
        return this.visibleEnMenu;
    }

    @Generated
    public Boolean getActiva() {
        return this.activa;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setSlug(String slug) {
        this.slug = slug;
    }

    @Generated
    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    @Generated
    public void setContenido(String contenido) {
        this.contenido = contenido;
    }

    @Generated
    public void setMetaDescripcion(String metaDescripcion) {
        this.metaDescripcion = metaDescripcion;
    }

    @Generated
    public void setTipoContenido(TipoContenido tipoContenido) {
        this.tipoContenido = tipoContenido;
    }

    @Generated
    public void setOrdenMenu(Integer ordenMenu) {
        this.ordenMenu = ordenMenu;
    }

    @Generated
    public void setVisibleEnMenu(Boolean visibleEnMenu) {
        this.visibleEnMenu = visibleEnMenu;
    }

    @Generated
    public void setActiva(Boolean activa) {
        this.activa = activa;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaginaStorefront)) {
            return false;
        }
        PaginaStorefront other = (PaginaStorefront)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Integer this$ordenMenu = this.getOrdenMenu();
        Integer other$ordenMenu = other.getOrdenMenu();
        if (this$ordenMenu == null ? other$ordenMenu != null : !((Object)this$ordenMenu).equals(other$ordenMenu)) {
            return false;
        }
        Boolean this$visibleEnMenu = this.getVisibleEnMenu();
        Boolean other$visibleEnMenu = other.getVisibleEnMenu();
        if (this$visibleEnMenu == null ? other$visibleEnMenu != null : !((Object)this$visibleEnMenu).equals(other$visibleEnMenu)) {
            return false;
        }
        Boolean this$activa = this.getActiva();
        Boolean other$activa = other.getActiva();
        if (this$activa == null ? other$activa != null : !((Object)this$activa).equals(other$activa)) {
            return false;
        }
        String this$slug = this.getSlug();
        String other$slug = other.getSlug();
        if (this$slug == null ? other$slug != null : !this$slug.equals(other$slug)) {
            return false;
        }
        String this$titulo = this.getTitulo();
        String other$titulo = other.getTitulo();
        if (this$titulo == null ? other$titulo != null : !this$titulo.equals(other$titulo)) {
            return false;
        }
        String this$contenido = this.getContenido();
        String other$contenido = other.getContenido();
        if (this$contenido == null ? other$contenido != null : !this$contenido.equals(other$contenido)) {
            return false;
        }
        String this$metaDescripcion = this.getMetaDescripcion();
        String other$metaDescripcion = other.getMetaDescripcion();
        if (this$metaDescripcion == null ? other$metaDescripcion != null : !this$metaDescripcion.equals(other$metaDescripcion)) {
            return false;
        }
        TipoContenido this$tipoContenido = this.getTipoContenido();
        TipoContenido other$tipoContenido = other.getTipoContenido();
        if (this$tipoContenido == null ? other$tipoContenido != null : !this$tipoContenido.equals(other$tipoContenido)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        if (this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn)) {
            return false;
        }
        LocalDateTime this$actualizadoEn = this.getActualizadoEn();
        LocalDateTime other$actualizadoEn = other.getActualizadoEn();
        return !(this$actualizadoEn == null ? other$actualizadoEn != null : !((Object)this$actualizadoEn).equals(other$actualizadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaginaStorefront;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Integer $ordenMenu = this.getOrdenMenu();
        result = result * 59 + ($ordenMenu == null ? 43 : ((Object)$ordenMenu).hashCode());
        Boolean $visibleEnMenu = this.getVisibleEnMenu();
        result = result * 59 + ($visibleEnMenu == null ? 43 : ((Object)$visibleEnMenu).hashCode());
        Boolean $activa = this.getActiva();
        result = result * 59 + ($activa == null ? 43 : ((Object)$activa).hashCode());
        String $slug = this.getSlug();
        result = result * 59 + ($slug == null ? 43 : $slug.hashCode());
        String $titulo = this.getTitulo();
        result = result * 59 + ($titulo == null ? 43 : $titulo.hashCode());
        String $contenido = this.getContenido();
        result = result * 59 + ($contenido == null ? 43 : $contenido.hashCode());
        String $metaDescripcion = this.getMetaDescripcion();
        result = result * 59 + ($metaDescripcion == null ? 43 : $metaDescripcion.hashCode());
        TipoContenido $tipoContenido = this.getTipoContenido();
        result = result * 59 + ($tipoContenido == null ? 43 : $tipoContenido.hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        LocalDateTime $actualizadoEn = this.getActualizadoEn();
        result = result * 59 + ($actualizadoEn == null ? 43 : ((Object)$actualizadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PaginaStorefront(id=" + this.getId() + ", tiendaId=" + this.getTiendaId() + ", slug=" + this.getSlug() + ", titulo=" + this.getTitulo() + ", contenido=" + this.getContenido() + ", metaDescripcion=" + this.getMetaDescripcion() + ", tipoContenido=" + String.valueOf(this.getTipoContenido()) + ", ordenMenu=" + this.getOrdenMenu() + ", visibleEnMenu=" + this.getVisibleEnMenu() + ", activa=" + this.getActiva() + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ", actualizadoEn=" + String.valueOf(this.getActualizadoEn()) + ")";
    }
}

