/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.controller;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.ConfiguracionTiendaResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.ConfiguracionTiendaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.service.IConfiguracionTiendaService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/configuracion"})
@Validated
public class ConfiguracionTiendaController {
    private final IConfiguracionTiendaService configuracionTiendaService;

    @GetMapping
    public ResponseEntity<ConfiguracionTiendaResponse> obtener(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.configuracionTiendaService.obtenerPorTiendaId(tiendaId));
    }

    @PutMapping
    public ResponseEntity<ConfiguracionTiendaResponse> actualizar(@PathVariable Long tiendaId, @Valid @RequestBody ConfiguracionTiendaUpdateRequest request) {
        ConfiguracionTiendaResponse response = this.configuracionTiendaService.actualizar(tiendaId, request);
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public ConfiguracionTiendaController(IConfiguracionTiendaService configuracionTiendaService) {
        this.configuracionTiendaService = configuracionTiendaService;
    }
}

