/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.controller;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.ConfiguracionPublicaResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.ConfiguracionPublicaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.service.IConfiguracionPublicaService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/configuracion/publica"})
@Validated
public class ConfiguracionPublicaController {
    private final IConfiguracionPublicaService configuracionPublicaService;

    @GetMapping
    public ResponseEntity<ConfiguracionPublicaResponse> obtener(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.configuracionPublicaService.obtenerConfiguracionPublica(tiendaId));
    }

    @PutMapping
    public ResponseEntity<ConfiguracionPublicaResponse> actualizar(@PathVariable Long tiendaId, @Valid @RequestBody ConfiguracionPublicaUpdateRequest request) {
        return ResponseEntity.ok((Object)this.configuracionPublicaService.actualizarConfiguracionPublica(tiendaId, request));
    }

    @Generated
    public ConfiguracionPublicaController(IConfiguracionPublicaService configuracionPublicaService) {
        this.configuracionPublicaService = configuracionPublicaService;
    }
}

