/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.configuracion.controller;

import com.dulcecontrol.bakery.features.admin.configuracion.dto.BrandingResponse;
import com.dulcecontrol.bakery.features.admin.configuracion.dto.BrandingUpdateRequest;
import com.dulcecontrol.bakery.features.admin.configuracion.service.IBrandingService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/configuracion/branding"})
@Validated
public class BrandingController {
    private final IBrandingService brandingService;

    @GetMapping
    public ResponseEntity<BrandingResponse> obtener(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.brandingService.obtenerBrandingPorTienda(tiendaId));
    }

    @PutMapping
    public ResponseEntity<BrandingResponse> actualizar(@PathVariable Long tiendaId, @Valid @RequestBody BrandingUpdateRequest request) {
        return ResponseEntity.ok((Object)this.brandingService.actualizarBranding(tiendaId, request));
    }

    @Generated
    public BrandingController(IBrandingService brandingService) {
        this.brandingService = brandingService;
    }
}

