/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.repository;

import com.dulcecontrol.bakery.features.admin.compras.entity.OrdenCompra;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.EstadoOrdenCompra;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface OrdenCompraRepository
extends JpaRepository<OrdenCompra, Long> {
    public List<OrdenCompra> findByTiendaId(Long var1);

    public Optional<OrdenCompra> findByIdAndTiendaId(Long var1, Long var2);

    @Query(value="SELECT oc FROM OrdenCompra oc WHERE oc.tiendaId = :tiendaId AND oc.estado = :estado ORDER BY oc.fechaEmision DESC")
    public List<OrdenCompra> findByTiendaIdAndEstado(@Param(value="tiendaId") Long var1, @Param(value="estado") EstadoOrdenCompra var2);

    @Query(value="SELECT oc FROM OrdenCompra oc WHERE oc.sedeDestinoId = :sedeId ORDER BY oc.fechaEmision DESC")
    public List<OrdenCompra> findBySedeDestino(@Param(value="sedeId") Long var1);

    @Query(value="SELECT oc FROM OrdenCompra oc WHERE oc.sedeDestinoId = :sedeId AND oc.estado = :estado ORDER BY oc.fechaEmision DESC")
    public List<OrdenCompra> findBySedeDestinoAndEstado(@Param(value="sedeId") Long var1, @Param(value="estado") EstadoOrdenCompra var2);

    @Query(value="SELECT oc FROM OrdenCompra oc WHERE oc.proveedorId = :proveedorId ORDER BY oc.fechaEmision DESC")
    public List<OrdenCompra> findByProveedor(@Param(value="proveedorId") Long var1);

    @Query(value="SELECT oc FROM OrdenCompra oc WHERE oc.sedeDestinoId = :sedeId AND oc.estado IN :estados AND oc.fechaRecepcionEsperada <= :fecha")
    public List<OrdenCompra> findOrdenesPendientesPorSede(@Param(value="sedeId") Long var1, @Param(value="estados") List<EstadoOrdenCompra> var2, @Param(value="fecha") LocalDate var3);

    @Query(value="SELECT oc FROM OrdenCompra oc WHERE oc.tiendaId = :tiendaId AND oc.fechaEmision BETWEEN :fechaInicio AND :fechaFin ORDER BY oc.fechaEmision DESC")
    public List<OrdenCompra> findByTiendaIdAndFechaEmisionBetween(@Param(value="tiendaId") Long var1, @Param(value="fechaInicio") LocalDate var2, @Param(value="fechaFin") LocalDate var3);
}

