/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.entity;

import com.dulcecontrol.bakery.features.admin.compras.entity.converter.TipoDocumentoProveedorConverter;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.TipoDocumentoProveedor;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="proveedores")
public class Proveedor {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="nombre_comercial", nullable=false)
    private String nombreComercial;
    @Convert(converter=TipoDocumentoProveedorConverter.class)
    @Column(name="tipo_doc", nullable=false, columnDefinition="ENUM('DNI', 'RUC')")
    private TipoDocumentoProveedor tipoDoc;
    @Column(name="numero_doc", length=20)
    private String numeroDoc;
    @Column(name="razon_social")
    private String razonSocial;
    @Column(name="nombre_contacto")
    private String nombreContacto;
    @Column(name="telefono_contacto", length=50)
    private String telefonoContacto;
    @Column(name="email_contacto")
    private String emailContacto;
    @Column(name="es_generico")
    private Boolean esGenerico = Boolean.FALSE;
    @Column(nullable=false)
    private Boolean activo = Boolean.TRUE;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
        if (this.activo == null) {
            this.activo = Boolean.TRUE;
        }
        if (this.esGenerico == null) {
            this.esGenerico = Boolean.FALSE;
        }
    }

    @Generated
    public Proveedor() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public String getNombreComercial() {
        return this.nombreComercial;
    }

    @Generated
    public TipoDocumentoProveedor getTipoDoc() {
        return this.tipoDoc;
    }

    @Generated
    public String getNumeroDoc() {
        return this.numeroDoc;
    }

    @Generated
    public String getRazonSocial() {
        return this.razonSocial;
    }

    @Generated
    public String getNombreContacto() {
        return this.nombreContacto;
    }

    @Generated
    public String getTelefonoContacto() {
        return this.telefonoContacto;
    }

    @Generated
    public String getEmailContacto() {
        return this.emailContacto;
    }

    @Generated
    public Boolean getEsGenerico() {
        return this.esGenerico;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setNombreComercial(String nombreComercial) {
        this.nombreComercial = nombreComercial;
    }

    @Generated
    public void setTipoDoc(TipoDocumentoProveedor tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @Generated
    public void setNumeroDoc(String numeroDoc) {
        this.numeroDoc = numeroDoc;
    }

    @Generated
    public void setRazonSocial(String razonSocial) {
        this.razonSocial = razonSocial;
    }

    @Generated
    public void setNombreContacto(String nombreContacto) {
        this.nombreContacto = nombreContacto;
    }

    @Generated
    public void setTelefonoContacto(String telefonoContacto) {
        this.telefonoContacto = telefonoContacto;
    }

    @Generated
    public void setEmailContacto(String emailContacto) {
        this.emailContacto = emailContacto;
    }

    @Generated
    public void setEsGenerico(Boolean esGenerico) {
        this.esGenerico = esGenerico;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Proveedor)) {
            return false;
        }
        Proveedor other = (Proveedor)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Boolean this$esGenerico = this.getEsGenerico();
        Boolean other$esGenerico = other.getEsGenerico();
        if (this$esGenerico == null ? other$esGenerico != null : !((Object)this$esGenerico).equals(other$esGenerico)) {
            return false;
        }
        Boolean this$activo = this.getActivo();
        Boolean other$activo = other.getActivo();
        if (this$activo == null ? other$activo != null : !((Object)this$activo).equals(other$activo)) {
            return false;
        }
        String this$nombreComercial = this.getNombreComercial();
        String other$nombreComercial = other.getNombreComercial();
        if (this$nombreComercial == null ? other$nombreComercial != null : !this$nombreComercial.equals(other$nombreComercial)) {
            return false;
        }
        TipoDocumentoProveedor this$tipoDoc = this.getTipoDoc();
        TipoDocumentoProveedor other$tipoDoc = other.getTipoDoc();
        if (this$tipoDoc == null ? other$tipoDoc != null : !this$tipoDoc.equals(other$tipoDoc)) {
            return false;
        }
        String this$numeroDoc = this.getNumeroDoc();
        String other$numeroDoc = other.getNumeroDoc();
        if (this$numeroDoc == null ? other$numeroDoc != null : !this$numeroDoc.equals(other$numeroDoc)) {
            return false;
        }
        String this$razonSocial = this.getRazonSocial();
        String other$razonSocial = other.getRazonSocial();
        if (this$razonSocial == null ? other$razonSocial != null : !this$razonSocial.equals(other$razonSocial)) {
            return false;
        }
        String this$nombreContacto = this.getNombreContacto();
        String other$nombreContacto = other.getNombreContacto();
        if (this$nombreContacto == null ? other$nombreContacto != null : !this$nombreContacto.equals(other$nombreContacto)) {
            return false;
        }
        String this$telefonoContacto = this.getTelefonoContacto();
        String other$telefonoContacto = other.getTelefonoContacto();
        if (this$telefonoContacto == null ? other$telefonoContacto != null : !this$telefonoContacto.equals(other$telefonoContacto)) {
            return false;
        }
        String this$emailContacto = this.getEmailContacto();
        String other$emailContacto = other.getEmailContacto();
        if (this$emailContacto == null ? other$emailContacto != null : !this$emailContacto.equals(other$emailContacto)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        return !(this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Proveedor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Boolean $esGenerico = this.getEsGenerico();
        result = result * 59 + ($esGenerico == null ? 43 : ((Object)$esGenerico).hashCode());
        Boolean $activo = this.getActivo();
        result = result * 59 + ($activo == null ? 43 : ((Object)$activo).hashCode());
        String $nombreComercial = this.getNombreComercial();
        result = result * 59 + ($nombreComercial == null ? 43 : $nombreComercial.hashCode());
        TipoDocumentoProveedor $tipoDoc = this.getTipoDoc();
        result = result * 59 + ($tipoDoc == null ? 43 : $tipoDoc.hashCode());
        String $numeroDoc = this.getNumeroDoc();
        result = result * 59 + ($numeroDoc == null ? 43 : $numeroDoc.hashCode());
        String $razonSocial = this.getRazonSocial();
        result = result * 59 + ($razonSocial == null ? 43 : $razonSocial.hashCode());
        String $nombreContacto = this.getNombreContacto();
        result = result * 59 + ($nombreContacto == null ? 43 : $nombreContacto.hashCode());
        String $telefonoContacto = this.getTelefonoContacto();
        result = result * 59 + ($telefonoContacto == null ? 43 : $telefonoContacto.hashCode());
        String $emailContacto = this.getEmailContacto();
        result = result * 59 + ($emailContacto == null ? 43 : $emailContacto.hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Proveedor(id=" + this.getId() + ", tiendaId=" + this.getTiendaId() + ", nombreComercial=" + this.getNombreComercial() + ", tipoDoc=" + String.valueOf(this.getTipoDoc()) + ", numeroDoc=" + this.getNumeroDoc() + ", razonSocial=" + this.getRazonSocial() + ", nombreContacto=" + this.getNombreContacto() + ", telefonoContacto=" + this.getTelefonoContacto() + ", emailContacto=" + this.getEmailContacto() + ", esGenerico=" + this.getEsGenerico() + ", activo=" + this.getActivo() + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ")";
    }
}

