/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="pagos_orden_compra")
public class PagoOrdenCompra {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="orden_compra_id", nullable=false)
    private Long ordenCompraId;
    @Column(name="fecha_pago", nullable=false)
    private LocalDate fechaPago;
    @Column(name="monto_pagado_centimos", nullable=false)
    private Long montoPagadoCentimos;
    @Column(name="metodo_pago", length=50)
    private String metodoPago;
    @Column(name="referencia_pago", length=100)
    private String referenciaPago;
    @Column(name="url_foto_comprobante", columnDefinition="LONGTEXT")
    private String urlFotoComprobante;
    @Column(columnDefinition="TEXT")
    private String observaciones;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
        this.actualizadoEn = LocalDateTime.now();
        if (this.fechaPago == null) {
            this.fechaPago = LocalDate.now();
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public PagoOrdenCompra() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getOrdenCompraId() {
        return this.ordenCompraId;
    }

    @Generated
    public LocalDate getFechaPago() {
        return this.fechaPago;
    }

    @Generated
    public Long getMontoPagadoCentimos() {
        return this.montoPagadoCentimos;
    }

    @Generated
    public String getMetodoPago() {
        return this.metodoPago;
    }

    @Generated
    public String getReferenciaPago() {
        return this.referenciaPago;
    }

    @Generated
    public String getUrlFotoComprobante() {
        return this.urlFotoComprobante;
    }

    @Generated
    public String getObservaciones() {
        return this.observaciones;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setOrdenCompraId(Long ordenCompraId) {
        this.ordenCompraId = ordenCompraId;
    }

    @Generated
    public void setFechaPago(LocalDate fechaPago) {
        this.fechaPago = fechaPago;
    }

    @Generated
    public void setMontoPagadoCentimos(Long montoPagadoCentimos) {
        this.montoPagadoCentimos = montoPagadoCentimos;
    }

    @Generated
    public void setMetodoPago(String metodoPago) {
        this.metodoPago = metodoPago;
    }

    @Generated
    public void setReferenciaPago(String referenciaPago) {
        this.referenciaPago = referenciaPago;
    }

    @Generated
    public void setUrlFotoComprobante(String urlFotoComprobante) {
        this.urlFotoComprobante = urlFotoComprobante;
    }

    @Generated
    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PagoOrdenCompra)) {
            return false;
        }
        PagoOrdenCompra other = (PagoOrdenCompra)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$ordenCompraId = this.getOrdenCompraId();
        Long other$ordenCompraId = other.getOrdenCompraId();
        if (this$ordenCompraId == null ? other$ordenCompraId != null : !((Object)this$ordenCompraId).equals(other$ordenCompraId)) {
            return false;
        }
        Long this$montoPagadoCentimos = this.getMontoPagadoCentimos();
        Long other$montoPagadoCentimos = other.getMontoPagadoCentimos();
        if (this$montoPagadoCentimos == null ? other$montoPagadoCentimos != null : !((Object)this$montoPagadoCentimos).equals(other$montoPagadoCentimos)) {
            return false;
        }
        LocalDate this$fechaPago = this.getFechaPago();
        LocalDate other$fechaPago = other.getFechaPago();
        if (this$fechaPago == null ? other$fechaPago != null : !((Object)this$fechaPago).equals(other$fechaPago)) {
            return false;
        }
        String this$metodoPago = this.getMetodoPago();
        String other$metodoPago = other.getMetodoPago();
        if (this$metodoPago == null ? other$metodoPago != null : !this$metodoPago.equals(other$metodoPago)) {
            return false;
        }
        String this$referenciaPago = this.getReferenciaPago();
        String other$referenciaPago = other.getReferenciaPago();
        if (this$referenciaPago == null ? other$referenciaPago != null : !this$referenciaPago.equals(other$referenciaPago)) {
            return false;
        }
        String this$urlFotoComprobante = this.getUrlFotoComprobante();
        String other$urlFotoComprobante = other.getUrlFotoComprobante();
        if (this$urlFotoComprobante == null ? other$urlFotoComprobante != null : !this$urlFotoComprobante.equals(other$urlFotoComprobante)) {
            return false;
        }
        String this$observaciones = this.getObservaciones();
        String other$observaciones = other.getObservaciones();
        if (this$observaciones == null ? other$observaciones != null : !this$observaciones.equals(other$observaciones)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        if (this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn)) {
            return false;
        }
        LocalDateTime this$actualizadoEn = this.getActualizadoEn();
        LocalDateTime other$actualizadoEn = other.getActualizadoEn();
        return !(this$actualizadoEn == null ? other$actualizadoEn != null : !((Object)this$actualizadoEn).equals(other$actualizadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PagoOrdenCompra;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $ordenCompraId = this.getOrdenCompraId();
        result = result * 59 + ($ordenCompraId == null ? 43 : ((Object)$ordenCompraId).hashCode());
        Long $montoPagadoCentimos = this.getMontoPagadoCentimos();
        result = result * 59 + ($montoPagadoCentimos == null ? 43 : ((Object)$montoPagadoCentimos).hashCode());
        LocalDate $fechaPago = this.getFechaPago();
        result = result * 59 + ($fechaPago == null ? 43 : ((Object)$fechaPago).hashCode());
        String $metodoPago = this.getMetodoPago();
        result = result * 59 + ($metodoPago == null ? 43 : $metodoPago.hashCode());
        String $referenciaPago = this.getReferenciaPago();
        result = result * 59 + ($referenciaPago == null ? 43 : $referenciaPago.hashCode());
        String $urlFotoComprobante = this.getUrlFotoComprobante();
        result = result * 59 + ($urlFotoComprobante == null ? 43 : $urlFotoComprobante.hashCode());
        String $observaciones = this.getObservaciones();
        result = result * 59 + ($observaciones == null ? 43 : $observaciones.hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        LocalDateTime $actualizadoEn = this.getActualizadoEn();
        result = result * 59 + ($actualizadoEn == null ? 43 : ((Object)$actualizadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PagoOrdenCompra(id=" + this.getId() + ", ordenCompraId=" + this.getOrdenCompraId() + ", fechaPago=" + String.valueOf(this.getFechaPago()) + ", montoPagadoCentimos=" + this.getMontoPagadoCentimos() + ", metodoPago=" + this.getMetodoPago() + ", referenciaPago=" + this.getReferenciaPago() + ", urlFotoComprobante=" + this.getUrlFotoComprobante() + ", observaciones=" + this.getObservaciones() + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ", actualizadoEn=" + String.valueOf(this.getActualizadoEn()) + ")";
    }
}

