/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.entity;

import com.dulcecontrol.bakery.features.admin.compras.entity.converter.EstadoOrdenCompraConverter;
import com.dulcecontrol.bakery.features.admin.compras.entity.converter.MetodoPagoConverter;
import com.dulcecontrol.bakery.features.admin.compras.entity.converter.TipoComprobanteProveedorConverter;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.EstadoOrdenCompra;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.MetodoPago;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.TipoComprobanteProveedor;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="ordenes_compra")
public class OrdenCompra {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="sede_destino_id", nullable=false)
    private Long sedeDestinoId;
    @Column(name="proveedor_id", nullable=false)
    private Long proveedorId;
    @Column(name="fecha_emision", nullable=false)
    private LocalDate fechaEmision;
    @Column(name="fecha_recepcion_esperada")
    private LocalDate fechaRecepcionEsperada;
    @Column(name="fecha_recepcion_real")
    private LocalDate fechaRecepcionReal;
    @Convert(converter=EstadoOrdenCompraConverter.class)
    @Column(nullable=false, columnDefinition="ENUM('borrador', 'enviada', 'recibida_parcial', 'recibida_total', 'cancelada')")
    private EstadoOrdenCompra estado = EstadoOrdenCompra.BORRADOR;
    @Column(length=3)
    private String moneda = "PEN";
    @Column(name="total_compra_centimos", nullable=false)
    private Long totalCompraCentimos = 0L;
    @Convert(converter=MetodoPagoConverter.class)
    @Column(name="metodo_pago", columnDefinition="ENUM('efectivo', 'credito')")
    private MetodoPago metodoPago;
    @Column(name="monto_inicial_centimos")
    private Long montoInicialCentimos = 0L;
    @Column(name="monto_pagado_centimos")
    private Long montoPagadoCentimos = 0L;
    @Column(name="saldo_pendiente_centimos")
    private Long saldoPendienteCentimos = 0L;
    @Column(name="referencia_pago", length=100)
    private String referenciaPago;
    @Convert(converter=TipoComprobanteProveedorConverter.class)
    @Column(name="tipo_comprobante_proveedor", columnDefinition="ENUM('factura', 'boleta', 'nota_credito', 'nota_debito')")
    private TipoComprobanteProveedor tipoComprobanteProveedor;
    @Column(name="serie_comprobante_proveedor", length=50)
    private String serieComprobanteProveedor;
    @Column(name="numero_comprobante_proveedor", length=50)
    private String numeroComprobanteProveedor;
    @Column(name="url_foto_comprobante", columnDefinition="TEXT")
    private String urlFotoComprobante;
    @Column(columnDefinition="TEXT")
    private String observaciones;
    @Column(name="registrado_por")
    private Long registradoPor;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
        this.actualizadoEn = LocalDateTime.now();
        if (this.fechaEmision == null) {
            this.fechaEmision = LocalDate.now();
        }
        if (this.estado == null) {
            this.estado = EstadoOrdenCompra.BORRADOR;
        }
        if (this.moneda == null) {
            this.moneda = "PEN";
        }
        if (this.totalCompraCentimos == null) {
            this.totalCompraCentimos = 0L;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public OrdenCompra() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getSedeDestinoId() {
        return this.sedeDestinoId;
    }

    @Generated
    public Long getProveedorId() {
        return this.proveedorId;
    }

    @Generated
    public LocalDate getFechaEmision() {
        return this.fechaEmision;
    }

    @Generated
    public LocalDate getFechaRecepcionEsperada() {
        return this.fechaRecepcionEsperada;
    }

    @Generated
    public LocalDate getFechaRecepcionReal() {
        return this.fechaRecepcionReal;
    }

    @Generated
    public EstadoOrdenCompra getEstado() {
        return this.estado;
    }

    @Generated
    public String getMoneda() {
        return this.moneda;
    }

    @Generated
    public Long getTotalCompraCentimos() {
        return this.totalCompraCentimos;
    }

    @Generated
    public MetodoPago getMetodoPago() {
        return this.metodoPago;
    }

    @Generated
    public Long getMontoInicialCentimos() {
        return this.montoInicialCentimos;
    }

    @Generated
    public Long getMontoPagadoCentimos() {
        return this.montoPagadoCentimos;
    }

    @Generated
    public Long getSaldoPendienteCentimos() {
        return this.saldoPendienteCentimos;
    }

    @Generated
    public String getReferenciaPago() {
        return this.referenciaPago;
    }

    @Generated
    public TipoComprobanteProveedor getTipoComprobanteProveedor() {
        return this.tipoComprobanteProveedor;
    }

    @Generated
    public String getSerieComprobanteProveedor() {
        return this.serieComprobanteProveedor;
    }

    @Generated
    public String getNumeroComprobanteProveedor() {
        return this.numeroComprobanteProveedor;
    }

    @Generated
    public String getUrlFotoComprobante() {
        return this.urlFotoComprobante;
    }

    @Generated
    public String getObservaciones() {
        return this.observaciones;
    }

    @Generated
    public Long getRegistradoPor() {
        return this.registradoPor;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setSedeDestinoId(Long sedeDestinoId) {
        this.sedeDestinoId = sedeDestinoId;
    }

    @Generated
    public void setProveedorId(Long proveedorId) {
        this.proveedorId = proveedorId;
    }

    @Generated
    public void setFechaEmision(LocalDate fechaEmision) {
        this.fechaEmision = fechaEmision;
    }

    @Generated
    public void setFechaRecepcionEsperada(LocalDate fechaRecepcionEsperada) {
        this.fechaRecepcionEsperada = fechaRecepcionEsperada;
    }

    @Generated
    public void setFechaRecepcionReal(LocalDate fechaRecepcionReal) {
        this.fechaRecepcionReal = fechaRecepcionReal;
    }

    @Generated
    public void setEstado(EstadoOrdenCompra estado) {
        this.estado = estado;
    }

    @Generated
    public void setMoneda(String moneda) {
        this.moneda = moneda;
    }

    @Generated
    public void setTotalCompraCentimos(Long totalCompraCentimos) {
        this.totalCompraCentimos = totalCompraCentimos;
    }

    @Generated
    public void setMetodoPago(MetodoPago metodoPago) {
        this.metodoPago = metodoPago;
    }

    @Generated
    public void setMontoInicialCentimos(Long montoInicialCentimos) {
        this.montoInicialCentimos = montoInicialCentimos;
    }

    @Generated
    public void setMontoPagadoCentimos(Long montoPagadoCentimos) {
        this.montoPagadoCentimos = montoPagadoCentimos;
    }

    @Generated
    public void setSaldoPendienteCentimos(Long saldoPendienteCentimos) {
        this.saldoPendienteCentimos = saldoPendienteCentimos;
    }

    @Generated
    public void setReferenciaPago(String referenciaPago) {
        this.referenciaPago = referenciaPago;
    }

    @Generated
    public void setTipoComprobanteProveedor(TipoComprobanteProveedor tipoComprobanteProveedor) {
        this.tipoComprobanteProveedor = tipoComprobanteProveedor;
    }

    @Generated
    public void setSerieComprobanteProveedor(String serieComprobanteProveedor) {
        this.serieComprobanteProveedor = serieComprobanteProveedor;
    }

    @Generated
    public void setNumeroComprobanteProveedor(String numeroComprobanteProveedor) {
        this.numeroComprobanteProveedor = numeroComprobanteProveedor;
    }

    @Generated
    public void setUrlFotoComprobante(String urlFotoComprobante) {
        this.urlFotoComprobante = urlFotoComprobante;
    }

    @Generated
    public void setObservaciones(String observaciones) {
        this.observaciones = observaciones;
    }

    @Generated
    public void setRegistradoPor(Long registradoPor) {
        this.registradoPor = registradoPor;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrdenCompra)) {
            return false;
        }
        OrdenCompra other = (OrdenCompra)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$tiendaId = this.getTiendaId();
        Long other$tiendaId = other.getTiendaId();
        if (this$tiendaId == null ? other$tiendaId != null : !((Object)this$tiendaId).equals(other$tiendaId)) {
            return false;
        }
        Long this$sedeDestinoId = this.getSedeDestinoId();
        Long other$sedeDestinoId = other.getSedeDestinoId();
        if (this$sedeDestinoId == null ? other$sedeDestinoId != null : !((Object)this$sedeDestinoId).equals(other$sedeDestinoId)) {
            return false;
        }
        Long this$proveedorId = this.getProveedorId();
        Long other$proveedorId = other.getProveedorId();
        if (this$proveedorId == null ? other$proveedorId != null : !((Object)this$proveedorId).equals(other$proveedorId)) {
            return false;
        }
        Long this$totalCompraCentimos = this.getTotalCompraCentimos();
        Long other$totalCompraCentimos = other.getTotalCompraCentimos();
        if (this$totalCompraCentimos == null ? other$totalCompraCentimos != null : !((Object)this$totalCompraCentimos).equals(other$totalCompraCentimos)) {
            return false;
        }
        Long this$montoInicialCentimos = this.getMontoInicialCentimos();
        Long other$montoInicialCentimos = other.getMontoInicialCentimos();
        if (this$montoInicialCentimos == null ? other$montoInicialCentimos != null : !((Object)this$montoInicialCentimos).equals(other$montoInicialCentimos)) {
            return false;
        }
        Long this$montoPagadoCentimos = this.getMontoPagadoCentimos();
        Long other$montoPagadoCentimos = other.getMontoPagadoCentimos();
        if (this$montoPagadoCentimos == null ? other$montoPagadoCentimos != null : !((Object)this$montoPagadoCentimos).equals(other$montoPagadoCentimos)) {
            return false;
        }
        Long this$saldoPendienteCentimos = this.getSaldoPendienteCentimos();
        Long other$saldoPendienteCentimos = other.getSaldoPendienteCentimos();
        if (this$saldoPendienteCentimos == null ? other$saldoPendienteCentimos != null : !((Object)this$saldoPendienteCentimos).equals(other$saldoPendienteCentimos)) {
            return false;
        }
        Long this$registradoPor = this.getRegistradoPor();
        Long other$registradoPor = other.getRegistradoPor();
        if (this$registradoPor == null ? other$registradoPor != null : !((Object)this$registradoPor).equals(other$registradoPor)) {
            return false;
        }
        LocalDate this$fechaEmision = this.getFechaEmision();
        LocalDate other$fechaEmision = other.getFechaEmision();
        if (this$fechaEmision == null ? other$fechaEmision != null : !((Object)this$fechaEmision).equals(other$fechaEmision)) {
            return false;
        }
        LocalDate this$fechaRecepcionEsperada = this.getFechaRecepcionEsperada();
        LocalDate other$fechaRecepcionEsperada = other.getFechaRecepcionEsperada();
        if (this$fechaRecepcionEsperada == null ? other$fechaRecepcionEsperada != null : !((Object)this$fechaRecepcionEsperada).equals(other$fechaRecepcionEsperada)) {
            return false;
        }
        LocalDate this$fechaRecepcionReal = this.getFechaRecepcionReal();
        LocalDate other$fechaRecepcionReal = other.getFechaRecepcionReal();
        if (this$fechaRecepcionReal == null ? other$fechaRecepcionReal != null : !((Object)this$fechaRecepcionReal).equals(other$fechaRecepcionReal)) {
            return false;
        }
        EstadoOrdenCompra this$estado = this.getEstado();
        EstadoOrdenCompra other$estado = other.getEstado();
        if (this$estado == null ? other$estado != null : !this$estado.equals(other$estado)) {
            return false;
        }
        String this$moneda = this.getMoneda();
        String other$moneda = other.getMoneda();
        if (this$moneda == null ? other$moneda != null : !this$moneda.equals(other$moneda)) {
            return false;
        }
        MetodoPago this$metodoPago = this.getMetodoPago();
        MetodoPago other$metodoPago = other.getMetodoPago();
        if (this$metodoPago == null ? other$metodoPago != null : !this$metodoPago.equals(other$metodoPago)) {
            return false;
        }
        String this$referenciaPago = this.getReferenciaPago();
        String other$referenciaPago = other.getReferenciaPago();
        if (this$referenciaPago == null ? other$referenciaPago != null : !this$referenciaPago.equals(other$referenciaPago)) {
            return false;
        }
        TipoComprobanteProveedor this$tipoComprobanteProveedor = this.getTipoComprobanteProveedor();
        TipoComprobanteProveedor other$tipoComprobanteProveedor = other.getTipoComprobanteProveedor();
        if (this$tipoComprobanteProveedor == null ? other$tipoComprobanteProveedor != null : !this$tipoComprobanteProveedor.equals(other$tipoComprobanteProveedor)) {
            return false;
        }
        String this$serieComprobanteProveedor = this.getSerieComprobanteProveedor();
        String other$serieComprobanteProveedor = other.getSerieComprobanteProveedor();
        if (this$serieComprobanteProveedor == null ? other$serieComprobanteProveedor != null : !this$serieComprobanteProveedor.equals(other$serieComprobanteProveedor)) {
            return false;
        }
        String this$numeroComprobanteProveedor = this.getNumeroComprobanteProveedor();
        String other$numeroComprobanteProveedor = other.getNumeroComprobanteProveedor();
        if (this$numeroComprobanteProveedor == null ? other$numeroComprobanteProveedor != null : !this$numeroComprobanteProveedor.equals(other$numeroComprobanteProveedor)) {
            return false;
        }
        String this$urlFotoComprobante = this.getUrlFotoComprobante();
        String other$urlFotoComprobante = other.getUrlFotoComprobante();
        if (this$urlFotoComprobante == null ? other$urlFotoComprobante != null : !this$urlFotoComprobante.equals(other$urlFotoComprobante)) {
            return false;
        }
        String this$observaciones = this.getObservaciones();
        String other$observaciones = other.getObservaciones();
        if (this$observaciones == null ? other$observaciones != null : !this$observaciones.equals(other$observaciones)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        if (this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn)) {
            return false;
        }
        LocalDateTime this$actualizadoEn = this.getActualizadoEn();
        LocalDateTime other$actualizadoEn = other.getActualizadoEn();
        return !(this$actualizadoEn == null ? other$actualizadoEn != null : !((Object)this$actualizadoEn).equals(other$actualizadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OrdenCompra;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $tiendaId = this.getTiendaId();
        result = result * 59 + ($tiendaId == null ? 43 : ((Object)$tiendaId).hashCode());
        Long $sedeDestinoId = this.getSedeDestinoId();
        result = result * 59 + ($sedeDestinoId == null ? 43 : ((Object)$sedeDestinoId).hashCode());
        Long $proveedorId = this.getProveedorId();
        result = result * 59 + ($proveedorId == null ? 43 : ((Object)$proveedorId).hashCode());
        Long $totalCompraCentimos = this.getTotalCompraCentimos();
        result = result * 59 + ($totalCompraCentimos == null ? 43 : ((Object)$totalCompraCentimos).hashCode());
        Long $montoInicialCentimos = this.getMontoInicialCentimos();
        result = result * 59 + ($montoInicialCentimos == null ? 43 : ((Object)$montoInicialCentimos).hashCode());
        Long $montoPagadoCentimos = this.getMontoPagadoCentimos();
        result = result * 59 + ($montoPagadoCentimos == null ? 43 : ((Object)$montoPagadoCentimos).hashCode());
        Long $saldoPendienteCentimos = this.getSaldoPendienteCentimos();
        result = result * 59 + ($saldoPendienteCentimos == null ? 43 : ((Object)$saldoPendienteCentimos).hashCode());
        Long $registradoPor = this.getRegistradoPor();
        result = result * 59 + ($registradoPor == null ? 43 : ((Object)$registradoPor).hashCode());
        LocalDate $fechaEmision = this.getFechaEmision();
        result = result * 59 + ($fechaEmision == null ? 43 : ((Object)$fechaEmision).hashCode());
        LocalDate $fechaRecepcionEsperada = this.getFechaRecepcionEsperada();
        result = result * 59 + ($fechaRecepcionEsperada == null ? 43 : ((Object)$fechaRecepcionEsperada).hashCode());
        LocalDate $fechaRecepcionReal = this.getFechaRecepcionReal();
        result = result * 59 + ($fechaRecepcionReal == null ? 43 : ((Object)$fechaRecepcionReal).hashCode());
        EstadoOrdenCompra $estado = this.getEstado();
        result = result * 59 + ($estado == null ? 43 : $estado.hashCode());
        String $moneda = this.getMoneda();
        result = result * 59 + ($moneda == null ? 43 : $moneda.hashCode());
        MetodoPago $metodoPago = this.getMetodoPago();
        result = result * 59 + ($metodoPago == null ? 43 : $metodoPago.hashCode());
        String $referenciaPago = this.getReferenciaPago();
        result = result * 59 + ($referenciaPago == null ? 43 : $referenciaPago.hashCode());
        TipoComprobanteProveedor $tipoComprobanteProveedor = this.getTipoComprobanteProveedor();
        result = result * 59 + ($tipoComprobanteProveedor == null ? 43 : $tipoComprobanteProveedor.hashCode());
        String $serieComprobanteProveedor = this.getSerieComprobanteProveedor();
        result = result * 59 + ($serieComprobanteProveedor == null ? 43 : $serieComprobanteProveedor.hashCode());
        String $numeroComprobanteProveedor = this.getNumeroComprobanteProveedor();
        result = result * 59 + ($numeroComprobanteProveedor == null ? 43 : $numeroComprobanteProveedor.hashCode());
        String $urlFotoComprobante = this.getUrlFotoComprobante();
        result = result * 59 + ($urlFotoComprobante == null ? 43 : $urlFotoComprobante.hashCode());
        String $observaciones = this.getObservaciones();
        result = result * 59 + ($observaciones == null ? 43 : $observaciones.hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        LocalDateTime $actualizadoEn = this.getActualizadoEn();
        result = result * 59 + ($actualizadoEn == null ? 43 : ((Object)$actualizadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OrdenCompra(id=" + this.getId() + ", tiendaId=" + this.getTiendaId() + ", sedeDestinoId=" + this.getSedeDestinoId() + ", proveedorId=" + this.getProveedorId() + ", fechaEmision=" + String.valueOf(this.getFechaEmision()) + ", fechaRecepcionEsperada=" + String.valueOf(this.getFechaRecepcionEsperada()) + ", fechaRecepcionReal=" + String.valueOf(this.getFechaRecepcionReal()) + ", estado=" + String.valueOf(this.getEstado()) + ", moneda=" + this.getMoneda() + ", totalCompraCentimos=" + this.getTotalCompraCentimos() + ", metodoPago=" + String.valueOf(this.getMetodoPago()) + ", montoInicialCentimos=" + this.getMontoInicialCentimos() + ", montoPagadoCentimos=" + this.getMontoPagadoCentimos() + ", saldoPendienteCentimos=" + this.getSaldoPendienteCentimos() + ", referenciaPago=" + this.getReferenciaPago() + ", tipoComprobanteProveedor=" + String.valueOf(this.getTipoComprobanteProveedor()) + ", serieComprobanteProveedor=" + this.getSerieComprobanteProveedor() + ", numeroComprobanteProveedor=" + this.getNumeroComprobanteProveedor() + ", urlFotoComprobante=" + this.getUrlFotoComprobante() + ", observaciones=" + this.getObservaciones() + ", registradoPor=" + this.getRegistradoPor() + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ", actualizadoEn=" + String.valueOf(this.getActualizadoEn()) + ")";
    }
}

