/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.entity;

import com.dulcecontrol.bakery.features.admin.compras.entity.converter.UnidadMedidaConverter;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.UnidadMedida;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import lombok.Generated;

@Entity
@Table(name="detalles_orden_compra")
public class DetalleOrdenCompra {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="orden_compra_id", nullable=false)
    private Long ordenCompraId;
    @Column(name="insumo_id", nullable=false)
    private Long insumoId;
    @Column(name="cantidad_solicitada", nullable=false, precision=12, scale=4)
    private BigDecimal cantidadSolicitada;
    @Convert(converter=UnidadMedidaConverter.class)
    @Column(name="unidad_compra", nullable=false, columnDefinition="ENUM('unidad', 'kg', 'g', 'l', 'ml', 'paquete', 'saco', 'lata')")
    private UnidadMedida unidadCompra;
    @Column(name="costo_unitario_pactado_centimos", nullable=false)
    private Long costoUnitarioPactadoCentimos;
    @Column(name="total_linea_centimos", nullable=false)
    private Long totalLineaCentimos;
    @Column(name="cantidad_recibida", precision=12, scale=4)
    private BigDecimal cantidadRecibida = BigDecimal.ZERO;
    @Column(name="recibido_completo")
    private Boolean recibidoCompleto = Boolean.FALSE;

    @PrePersist
    void onCreate() {
        if (this.cantidadRecibida == null) {
            this.cantidadRecibida = BigDecimal.ZERO;
        }
        if (this.recibidoCompleto == null) {
            this.recibidoCompleto = Boolean.FALSE;
        }
    }

    @Generated
    public DetalleOrdenCompra() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getOrdenCompraId() {
        return this.ordenCompraId;
    }

    @Generated
    public Long getInsumoId() {
        return this.insumoId;
    }

    @Generated
    public BigDecimal getCantidadSolicitada() {
        return this.cantidadSolicitada;
    }

    @Generated
    public UnidadMedida getUnidadCompra() {
        return this.unidadCompra;
    }

    @Generated
    public Long getCostoUnitarioPactadoCentimos() {
        return this.costoUnitarioPactadoCentimos;
    }

    @Generated
    public Long getTotalLineaCentimos() {
        return this.totalLineaCentimos;
    }

    @Generated
    public BigDecimal getCantidadRecibida() {
        return this.cantidadRecibida;
    }

    @Generated
    public Boolean getRecibidoCompleto() {
        return this.recibidoCompleto;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setOrdenCompraId(Long ordenCompraId) {
        this.ordenCompraId = ordenCompraId;
    }

    @Generated
    public void setInsumoId(Long insumoId) {
        this.insumoId = insumoId;
    }

    @Generated
    public void setCantidadSolicitada(BigDecimal cantidadSolicitada) {
        this.cantidadSolicitada = cantidadSolicitada;
    }

    @Generated
    public void setUnidadCompra(UnidadMedida unidadCompra) {
        this.unidadCompra = unidadCompra;
    }

    @Generated
    public void setCostoUnitarioPactadoCentimos(Long costoUnitarioPactadoCentimos) {
        this.costoUnitarioPactadoCentimos = costoUnitarioPactadoCentimos;
    }

    @Generated
    public void setTotalLineaCentimos(Long totalLineaCentimos) {
        this.totalLineaCentimos = totalLineaCentimos;
    }

    @Generated
    public void setCantidadRecibida(BigDecimal cantidadRecibida) {
        this.cantidadRecibida = cantidadRecibida;
    }

    @Generated
    public void setRecibidoCompleto(Boolean recibidoCompleto) {
        this.recibidoCompleto = recibidoCompleto;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetalleOrdenCompra)) {
            return false;
        }
        DetalleOrdenCompra other = (DetalleOrdenCompra)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$ordenCompraId = this.getOrdenCompraId();
        Long other$ordenCompraId = other.getOrdenCompraId();
        if (this$ordenCompraId == null ? other$ordenCompraId != null : !((Object)this$ordenCompraId).equals(other$ordenCompraId)) {
            return false;
        }
        Long this$insumoId = this.getInsumoId();
        Long other$insumoId = other.getInsumoId();
        if (this$insumoId == null ? other$insumoId != null : !((Object)this$insumoId).equals(other$insumoId)) {
            return false;
        }
        Long this$costoUnitarioPactadoCentimos = this.getCostoUnitarioPactadoCentimos();
        Long other$costoUnitarioPactadoCentimos = other.getCostoUnitarioPactadoCentimos();
        if (this$costoUnitarioPactadoCentimos == null ? other$costoUnitarioPactadoCentimos != null : !((Object)this$costoUnitarioPactadoCentimos).equals(other$costoUnitarioPactadoCentimos)) {
            return false;
        }
        Long this$totalLineaCentimos = this.getTotalLineaCentimos();
        Long other$totalLineaCentimos = other.getTotalLineaCentimos();
        if (this$totalLineaCentimos == null ? other$totalLineaCentimos != null : !((Object)this$totalLineaCentimos).equals(other$totalLineaCentimos)) {
            return false;
        }
        Boolean this$recibidoCompleto = this.getRecibidoCompleto();
        Boolean other$recibidoCompleto = other.getRecibidoCompleto();
        if (this$recibidoCompleto == null ? other$recibidoCompleto != null : !((Object)this$recibidoCompleto).equals(other$recibidoCompleto)) {
            return false;
        }
        BigDecimal this$cantidadSolicitada = this.getCantidadSolicitada();
        BigDecimal other$cantidadSolicitada = other.getCantidadSolicitada();
        if (this$cantidadSolicitada == null ? other$cantidadSolicitada != null : !((Object)this$cantidadSolicitada).equals(other$cantidadSolicitada)) {
            return false;
        }
        UnidadMedida this$unidadCompra = this.getUnidadCompra();
        UnidadMedida other$unidadCompra = other.getUnidadCompra();
        if (this$unidadCompra == null ? other$unidadCompra != null : !this$unidadCompra.equals(other$unidadCompra)) {
            return false;
        }
        BigDecimal this$cantidadRecibida = this.getCantidadRecibida();
        BigDecimal other$cantidadRecibida = other.getCantidadRecibida();
        return !(this$cantidadRecibida == null ? other$cantidadRecibida != null : !((Object)this$cantidadRecibida).equals(other$cantidadRecibida));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DetalleOrdenCompra;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $ordenCompraId = this.getOrdenCompraId();
        result = result * 59 + ($ordenCompraId == null ? 43 : ((Object)$ordenCompraId).hashCode());
        Long $insumoId = this.getInsumoId();
        result = result * 59 + ($insumoId == null ? 43 : ((Object)$insumoId).hashCode());
        Long $costoUnitarioPactadoCentimos = this.getCostoUnitarioPactadoCentimos();
        result = result * 59 + ($costoUnitarioPactadoCentimos == null ? 43 : ((Object)$costoUnitarioPactadoCentimos).hashCode());
        Long $totalLineaCentimos = this.getTotalLineaCentimos();
        result = result * 59 + ($totalLineaCentimos == null ? 43 : ((Object)$totalLineaCentimos).hashCode());
        Boolean $recibidoCompleto = this.getRecibidoCompleto();
        result = result * 59 + ($recibidoCompleto == null ? 43 : ((Object)$recibidoCompleto).hashCode());
        BigDecimal $cantidadSolicitada = this.getCantidadSolicitada();
        result = result * 59 + ($cantidadSolicitada == null ? 43 : ((Object)$cantidadSolicitada).hashCode());
        UnidadMedida $unidadCompra = this.getUnidadCompra();
        result = result * 59 + ($unidadCompra == null ? 43 : $unidadCompra.hashCode());
        BigDecimal $cantidadRecibida = this.getCantidadRecibida();
        result = result * 59 + ($cantidadRecibida == null ? 43 : ((Object)$cantidadRecibida).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DetalleOrdenCompra(id=" + this.getId() + ", ordenCompraId=" + this.getOrdenCompraId() + ", insumoId=" + this.getInsumoId() + ", cantidadSolicitada=" + String.valueOf(this.getCantidadSolicitada()) + ", unidadCompra=" + String.valueOf(this.getUnidadCompra()) + ", costoUnitarioPactadoCentimos=" + this.getCostoUnitarioPactadoCentimos() + ", totalLineaCentimos=" + this.getTotalLineaCentimos() + ", cantidadRecibida=" + String.valueOf(this.getCantidadRecibida()) + ", recibidoCompleto=" + this.getRecibidoCompleto() + ")";
    }
}

