/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.controller;

import com.dulcecontrol.bakery.features.admin.compras.dto.ProveedorCreateRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.ProveedorResponse;
import com.dulcecontrol.bakery.features.admin.compras.dto.ProveedorUpdateRequest;
import com.dulcecontrol.bakery.features.admin.compras.service.IProveedorService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/compras/proveedores"})
@Validated
public class ProveedorController {
    private final IProveedorService proveedorService;

    @GetMapping
    public ResponseEntity<List<ProveedorResponse>> listar(@PathVariable Long tiendaId, @RequestParam(required=false) Boolean soloActivos) {
        if (Boolean.TRUE.equals(soloActivos)) {
            return ResponseEntity.ok((Object)this.proveedorService.listarActivos(tiendaId));
        }
        return ResponseEntity.ok((Object)this.proveedorService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/{proveedorId}"})
    public ResponseEntity<ProveedorResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long proveedorId) {
        return ResponseEntity.ok((Object)this.proveedorService.obtenerPorId(tiendaId, proveedorId));
    }

    @PostMapping
    public ResponseEntity<ProveedorResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody ProveedorCreateRequest request) {
        request.setTiendaId(tiendaId);
        ProveedorResponse response = this.proveedorService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{proveedorId}"})
    public ResponseEntity<ProveedorResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long proveedorId, @Valid @RequestBody ProveedorUpdateRequest request) {
        ProveedorResponse response = this.proveedorService.actualizar(tiendaId, proveedorId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{proveedorId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long proveedorId) {
        this.proveedorService.eliminar(tiendaId, proveedorId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public ProveedorController(IProveedorService proveedorService) {
        this.proveedorService = proveedorService;
    }
}

