/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.compras.controller;

import com.dulcecontrol.bakery.features.admin.compras.dto.OrdenCompraCreateRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.OrdenCompraResponse;
import com.dulcecontrol.bakery.features.admin.compras.dto.OrdenCompraUpdateRequest;
import com.dulcecontrol.bakery.features.admin.compras.dto.RecepcionParcialRequest;
import com.dulcecontrol.bakery.features.admin.compras.entity.enums.EstadoOrdenCompra;
import com.dulcecontrol.bakery.features.admin.compras.service.IOrdenCompraService;
import jakarta.validation.Valid;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/compras/ordenes"})
@Validated
public class OrdenCompraController {
    private final IOrdenCompraService ordenCompraService;

    @GetMapping
    public ResponseEntity<List<OrdenCompraResponse>> listar(@PathVariable Long tiendaId, @RequestParam(required=false) EstadoOrdenCompra estado, @RequestParam(required=false) Long sedeId, @RequestParam(required=false) Long proveedorId, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaInicio, @RequestParam(required=false) @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate fechaFin) {
        if (sedeId != null && estado != null) {
            return ResponseEntity.ok(this.ordenCompraService.listarPorSede(sedeId).stream().filter(orden -> orden.getEstado() == estado).toList());
        }
        if (sedeId != null) {
            return ResponseEntity.ok((Object)this.ordenCompraService.listarPorSede(sedeId));
        }
        if (proveedorId != null) {
            return ResponseEntity.ok((Object)this.ordenCompraService.listarPorProveedor(proveedorId));
        }
        if (estado != null) {
            return ResponseEntity.ok((Object)this.ordenCompraService.listarPorTiendaYEstado(tiendaId, estado));
        }
        if (fechaInicio != null && fechaFin != null) {
            return ResponseEntity.ok((Object)this.ordenCompraService.listarPorFechas(tiendaId, fechaInicio, fechaFin));
        }
        return ResponseEntity.ok((Object)this.ordenCompraService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/pendientes"})
    public ResponseEntity<List<OrdenCompraResponse>> listarPendientes(@PathVariable Long tiendaId, @RequestParam(required=false) Long sedeId) {
        if (sedeId != null) {
            return ResponseEntity.ok((Object)this.ordenCompraService.listarOrdenesPendientes(sedeId));
        }
        return ResponseEntity.ok(this.ordenCompraService.listarPorTiendaYEstado(tiendaId, EstadoOrdenCompra.ENVIADA).stream().filter(orden -> orden.getEstado() == EstadoOrdenCompra.ENVIADA || orden.getEstado() == EstadoOrdenCompra.RECIBIDA_PARCIAL).toList());
    }

    @GetMapping(value={"/{ordenId}"})
    public ResponseEntity<OrdenCompraResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long ordenId) {
        return ResponseEntity.ok((Object)this.ordenCompraService.obtenerPorId(tiendaId, ordenId));
    }

    @PostMapping
    public ResponseEntity<OrdenCompraResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody OrdenCompraCreateRequest request) {
        request.setTiendaId(tiendaId);
        OrdenCompraResponse response = this.ordenCompraService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{ordenId}"})
    public ResponseEntity<OrdenCompraResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long ordenId, @Valid @RequestBody OrdenCompraUpdateRequest request) {
        OrdenCompraResponse response = this.ordenCompraService.actualizar(tiendaId, ordenId, request);
        return ResponseEntity.ok((Object)response);
    }

    @PatchMapping(value={"/{ordenId}/estado"})
    public ResponseEntity<OrdenCompraResponse> cambiarEstado(@PathVariable Long tiendaId, @PathVariable Long ordenId, @RequestParam EstadoOrdenCompra estado) {
        OrdenCompraResponse response = this.ordenCompraService.cambiarEstado(tiendaId, ordenId, estado);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{ordenId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long ordenId) {
        this.ordenCompraService.eliminar(tiendaId, ordenId);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/recepcion-parcial"})
    public ResponseEntity<OrdenCompraResponse> recibirParcial(@PathVariable Long tiendaId, @Valid @RequestBody RecepcionParcialRequest request) {
        OrdenCompraResponse response = this.ordenCompraService.recibirParcial(tiendaId, request);
        return ResponseEntity.ok((Object)response);
    }

    @PostMapping(value={"/{ordenId}/recepcion-total"})
    public ResponseEntity<OrdenCompraResponse> recibirTotal(@PathVariable Long tiendaId, @PathVariable Long ordenId) {
        OrdenCompraResponse response = this.ordenCompraService.recibirTotal(tiendaId, ordenId);
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public OrdenCompraController(IOrdenCompraService ordenCompraService) {
        this.ordenCompraService = ordenCompraService;
    }
}

