/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.clientes.repository;

import com.dulcecontrol.bakery.features.admin.clientes.entity.Cliente;
import com.dulcecontrol.bakery.features.admin.clientes.entity.enums.TipoDocumento;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ClienteRepository
extends JpaRepository<Cliente, Long> {
    public List<Cliente> findByTiendaId(Long var1);

    @Query(value="SELECT c FROM Cliente c WHERE c.tiendaId = :tiendaId")
    public List<Cliente> findAllByTiendaIdIncludingInactive(@Param(value="tiendaId") Long var1);

    public Optional<Cliente> findByIdAndTiendaId(Long var1, Long var2);

    @Query(value="SELECT c FROM Cliente c WHERE c.tiendaId = :tiendaId AND LOWER(c.email) = LOWER(:email)")
    public Optional<Cliente> findByTiendaIdAndEmail(@Param(value="tiendaId") Long var1, @Param(value="email") String var2);

    @Query(value="SELECT COUNT(c) > 0 FROM Cliente c WHERE c.tiendaId = :tiendaId AND c.tipoDoc = :tipoDoc AND c.numeroDoc = :numeroDoc AND c.activo = true")
    public boolean existsByTiendaIdAndTipoDocAndNumeroDoc(@Param(value="tiendaId") Long var1, @Param(value="tipoDoc") TipoDocumento var2, @Param(value="numeroDoc") String var3);

    public boolean existsByTiendaIdAndEmail(Long var1, String var2);

    @Query(value="SELECT COUNT(c) > 0 FROM Cliente c WHERE c.tiendaId = :tiendaId AND c.tipoDoc = :tipoDoc AND c.numeroDoc = :numeroDoc AND c.id != :id AND c.activo = true")
    public boolean existsByTiendaIdAndTipoDocAndNumeroDocAndIdNot(@Param(value="tiendaId") Long var1, @Param(value="tipoDoc") TipoDocumento var2, @Param(value="numeroDoc") String var3, @Param(value="id") Long var4);

    public boolean existsByTiendaIdAndEmailAndIdNot(Long var1, String var2, Long var3);

    @Query(value="SELECT c FROM Cliente c WHERE c.tiendaId = :tiendaId AND c.activo = true AND (c.nombreDoc LIKE %:busqueda% OR c.email LIKE %:busqueda% OR c.numeroDoc LIKE %:busqueda%)")
    public List<Cliente> buscarPorTiendaYTexto(@Param(value="tiendaId") Long var1, @Param(value="busqueda") String var2);

    public List<Cliente> findByTiendaIdAndEsUsuarioVirtual(Long var1, Boolean var2);

    public boolean existsByTiendaIdAndNumeroDoc(Long var1, String var2);
}

