/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.clientes.controller;

import com.dulcecontrol.bakery.features.admin.clientes.dto.ClienteCreateRequest;
import com.dulcecontrol.bakery.features.admin.clientes.dto.ClienteResponse;
import com.dulcecontrol.bakery.features.admin.clientes.dto.ClienteUpdateRequest;
import com.dulcecontrol.bakery.features.admin.clientes.service.IClienteAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/admin/tiendas/{tiendaId}/clientes"})
@Validated
public class ClienteAdminController {
    private final IClienteAdminService clienteAdminService;

    @GetMapping
    public ResponseEntity<List<ClienteResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.clienteAdminService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/buscar"})
    public ResponseEntity<List<ClienteResponse>> buscar(@PathVariable Long tiendaId, @RequestParam(required=false) String q) {
        return ResponseEntity.ok((Object)this.clienteAdminService.buscarPorTiendaYTexto(tiendaId, q));
    }

    @GetMapping(value={"/{clienteId}"})
    public ResponseEntity<ClienteResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long clienteId) {
        return ResponseEntity.ok((Object)this.clienteAdminService.obtenerPorId(tiendaId, clienteId));
    }

    @PostMapping
    public ResponseEntity<ClienteResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody ClienteCreateRequest request) {
        ClienteResponse response = this.clienteAdminService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{clienteId}"})
    public ResponseEntity<ClienteResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long clienteId, @Valid @RequestBody ClienteUpdateRequest request) {
        ClienteResponse response = this.clienteAdminService.actualizar(tiendaId, clienteId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{clienteId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long clienteId) {
        this.clienteAdminService.eliminar(tiendaId, clienteId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public ClienteAdminController(IClienteAdminService clienteAdminService) {
        this.clienteAdminService = clienteAdminService;
    }
}

