/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.catalogo.service.impl;

import com.dulcecontrol.bakery.features.admin.catalogo.dto.CategoriaCreateRequest;
import com.dulcecontrol.bakery.features.admin.catalogo.dto.CategoriaResponse;
import com.dulcecontrol.bakery.features.admin.catalogo.dto.CategoriaUpdateRequest;
import com.dulcecontrol.bakery.features.admin.catalogo.entity.Categoria;
import com.dulcecontrol.bakery.features.admin.catalogo.service.ICategoriaAdminService;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.CategoriaRepository;
import com.dulcecontrol.bakery.features.shared.catalogo.repository.ProductoRepository;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CategoriaAdminService
implements ICategoriaAdminService {
    private final CategoriaRepository categoriaRepository;
    private final ProductoRepository productoRepository;

    @Transactional(readOnly=true)
    public List<CategoriaResponse> listar(Long tiendaId) {
        return this.categoriaRepository.findByTiendaIdOrderByOrdenVisualAscNombreAsc(tiendaId).stream().map(categoria -> this.toResponseWithCount(categoria)).toList();
    }

    @Transactional(readOnly=true)
    public CategoriaResponse obtener(Long tiendaId, Long categoriaId) {
        Categoria categoria = (Categoria)this.categoriaRepository.findByIdAndTiendaId(categoriaId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Categor\u00eda no encontrada"));
        return this.toResponse(categoria);
    }

    @Transactional
    public CategoriaResponse crear(Long tiendaId, CategoriaCreateRequest request) {
        this.validarDuplicadosAlCrear(tiendaId, request.getNombre(), request.getSlug());
        Categoria categoria = new Categoria();
        categoria.setTiendaId(tiendaId);
        categoria.setNombre(request.getNombre());
        categoria.setSlug(request.getSlug());
        categoria.setDescripcion(request.getDescripcion());
        categoria.setUrlImagen(request.getUrlImagen());
        categoria.setIcono(request.getIcono());
        categoria.setActiva(request.getActiva() == null ? Boolean.TRUE : request.getActiva());
        categoria.setOrdenVisual(Integer.valueOf(request.getOrdenVisual() == null ? 0 : request.getOrdenVisual()));
        Categoria guardada = (Categoria)this.categoriaRepository.save((Object)categoria);
        return this.toResponse(guardada);
    }

    @Transactional
    public CategoriaResponse actualizar(Long tiendaId, Long categoriaId, CategoriaUpdateRequest request) {
        Categoria categoria = (Categoria)this.categoriaRepository.findByIdAndTiendaId(categoriaId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Categor\u00eda no encontrada"));
        if (this.categoriaRepository.existsByTiendaIdAndNombreIgnoreCaseAndIdNot(tiendaId, request.getNombre(), categoriaId)) {
            throw new BadRequestException("El nombre de la categor\u00eda ya est\u00e1 registrado para esta tienda");
        }
        if (this.categoriaRepository.existsByTiendaIdAndSlugIgnoreCaseAndIdNot(tiendaId, request.getSlug(), categoriaId)) {
            throw new BadRequestException("El slug de la categor\u00eda ya est\u00e1 registrado para esta tienda");
        }
        categoria.setNombre(request.getNombre());
        categoria.setSlug(request.getSlug());
        categoria.setDescripcion(request.getDescripcion());
        categoria.setUrlImagen(request.getUrlImagen());
        categoria.setIcono(request.getIcono());
        if (request.getActiva() != null) {
            categoria.setActiva(request.getActiva());
        }
        if (request.getOrdenVisual() != null) {
            categoria.setOrdenVisual(request.getOrdenVisual());
        }
        Categoria actualizada = (Categoria)this.categoriaRepository.save((Object)categoria);
        return this.toResponse(actualizada);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long categoriaId) {
        Categoria categoria = (Categoria)this.categoriaRepository.findByIdAndTiendaId(categoriaId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("Categor\u00eda no encontrada"));
        long productosCount = this.productoRepository.countByCategoriaId(categoriaId);
        if (productosCount > 0L) {
            throw new BadRequestException(String.format("No se puede eliminar la categor\u00eda porque tiene %d producto(s) asignado(s). Primero debes reasignar o eliminar estos productos.", productosCount));
        }
        this.categoriaRepository.delete((Object)categoria);
    }

    private void validarDuplicadosAlCrear(Long tiendaId, String nombre, String slug) {
        if (this.categoriaRepository.existsByTiendaIdAndNombreIgnoreCase(tiendaId, nombre)) {
            throw new BadRequestException("El nombre de la categor\u00eda ya est\u00e1 registrado para esta tienda");
        }
        if (this.categoriaRepository.existsByTiendaIdAndSlugIgnoreCase(tiendaId, slug)) {
            throw new BadRequestException("El slug de la categor\u00eda ya est\u00e1 registrado para esta tienda");
        }
    }

    private CategoriaResponse toResponse(Categoria categoria) {
        return CategoriaResponse.builder().id(categoria.getId()).tiendaId(categoria.getTiendaId()).nombre(categoria.getNombre()).slug(categoria.getSlug()).descripcion(categoria.getDescripcion()).urlImagen(categoria.getUrlImagen()).icono(categoria.getIcono()).activa(categoria.getActiva()).ordenVisual(categoria.getOrdenVisual()).creadoEn(categoria.getCreadoEn()).build();
    }

    private CategoriaResponse toResponseWithCount(Categoria categoria) {
        long productosCount = this.productoRepository.countByCategoriaId(categoria.getId());
        return CategoriaResponse.builder().id(categoria.getId()).tiendaId(categoria.getTiendaId()).nombre(categoria.getNombre()).slug(categoria.getSlug()).descripcion(categoria.getDescripcion()).urlImagen(categoria.getUrlImagen()).icono(categoria.getIcono()).activa(categoria.getActiva()).ordenVisual(categoria.getOrdenVisual()).productosCount(Long.valueOf(productosCount)).creadoEn(categoria.getCreadoEn()).build();
    }

    @Generated
    public CategoriaAdminService(CategoriaRepository categoriaRepository, ProductoRepository productoRepository) {
        this.categoriaRepository = categoriaRepository;
        this.productoRepository = productoRepository;
    }
}

