/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.catalogo.entity;

import com.dulcecontrol.bakery.features.admin.catalogo.entity.Categoria;
import com.dulcecontrol.bakery.features.admin.catalogo.entity.enums.TipoProducto;
import io.hypersistence.utils.hibernate.type.json.JsonType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;
import org.hibernate.annotations.Type;

@Entity
@Table(name="productos", uniqueConstraints={@UniqueConstraint(name="uk_productos_tienda_sku", columnNames={"tienda_id", "sku"}), @UniqueConstraint(name="uk_productos_tienda_slug", columnNames={"tienda_id", "slug"})})
@SQLDelete(sql="UPDATE productos SET activo = false, actualizado_en = CURRENT_TIMESTAMP WHERE id = ?")
@SQLRestriction(value="activo = true")
public class Producto {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(name="categoria_id")
    private Long categoriaId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="categoria_id", insertable=false, updatable=false)
    private Categoria categoria;
    @Column(nullable=false, length=255)
    private String nombre;
    @Column(nullable=false, length=255)
    private String slug;
    @Column(nullable=false, length=100)
    private String sku;
    @Column(columnDefinition="TEXT")
    private String descripcion;
    @Column(nullable=false, columnDefinition="ENUM('producto_terminado','insumo_venta','servicio')")
    private TipoProducto tipo = TipoProducto.PRODUCTO_TERMINADO;
    @Column(name="es_personalizable", nullable=false)
    private Boolean esPersonalizable = Boolean.FALSE;
    @Column(name="precio_base_centimos", nullable=false)
    private Long precioBaseCentimos = 0L;
    @Column(name="precio_oferta_centimos")
    private Long precioOfertaCentimos;
    @Column(name="visible_en_pos", nullable=false)
    private Boolean visibleEnPos = Boolean.TRUE;
    @Column(name="visible_en_storefront", nullable=false)
    private Boolean visibleEnStorefront = Boolean.TRUE;
    @Column(name="destacado_storefront", nullable=false)
    private Boolean destacadoStorefront = Boolean.FALSE;
    @Column(name="url_imagen_principal", columnDefinition="TEXT")
    private String urlImagenPrincipal;
    @Type(value=JsonType.class)
    @Column(name="imagenes_galeria", columnDefinition="json")
    private List<String> imagenesGaleria = new ArrayList();
    @Type(value=JsonType.class)
    @Column(name="atributos", columnDefinition="json")
    private Map<String, Object> atributos = new HashMap();
    @Column(nullable=false)
    private Boolean activo = Boolean.TRUE;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;

    @PrePersist
    void onCreate() {
        if (this.tipo == null) {
            this.tipo = TipoProducto.PRODUCTO_TERMINADO;
        }
        if (this.esPersonalizable == null) {
            this.esPersonalizable = Boolean.FALSE;
        }
        if (this.visibleEnPos == null) {
            this.visibleEnPos = Boolean.TRUE;
        }
        if (this.visibleEnStorefront == null) {
            this.visibleEnStorefront = Boolean.TRUE;
        }
        if (this.destacadoStorefront == null) {
            this.destacadoStorefront = Boolean.FALSE;
        }
        if (this.activo == null) {
            this.activo = Boolean.TRUE;
        }
        if (this.precioBaseCentimos == null) {
            this.precioBaseCentimos = 0L;
        }
        if (this.imagenesGaleria == null) {
            this.imagenesGaleria = new ArrayList();
        }
        if (this.atributos == null) {
            this.atributos = new HashMap();
        }
        this.actualizadoEn = this.creadoEn = LocalDateTime.now();
    }

    @PreUpdate
    void onUpdate() {
        if (this.imagenesGaleria == null) {
            this.imagenesGaleria = new ArrayList();
        }
        if (this.atributos == null) {
            this.atributos = new HashMap();
        }
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public Long getCategoriaId() {
        return this.categoriaId;
    }

    @Generated
    public Categoria getCategoria() {
        return this.categoria;
    }

    @Generated
    public String getNombre() {
        return this.nombre;
    }

    @Generated
    public String getSlug() {
        return this.slug;
    }

    @Generated
    public String getSku() {
        return this.sku;
    }

    @Generated
    public String getDescripcion() {
        return this.descripcion;
    }

    @Generated
    public TipoProducto getTipo() {
        return this.tipo;
    }

    @Generated
    public Boolean getEsPersonalizable() {
        return this.esPersonalizable;
    }

    @Generated
    public Long getPrecioBaseCentimos() {
        return this.precioBaseCentimos;
    }

    @Generated
    public Long getPrecioOfertaCentimos() {
        return this.precioOfertaCentimos;
    }

    @Generated
    public Boolean getVisibleEnPos() {
        return this.visibleEnPos;
    }

    @Generated
    public Boolean getVisibleEnStorefront() {
        return this.visibleEnStorefront;
    }

    @Generated
    public Boolean getDestacadoStorefront() {
        return this.destacadoStorefront;
    }

    @Generated
    public String getUrlImagenPrincipal() {
        return this.urlImagenPrincipal;
    }

    @Generated
    public List<String> getImagenesGaleria() {
        return this.imagenesGaleria;
    }

    @Generated
    public Map<String, Object> getAtributos() {
        return this.atributos;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setCategoriaId(Long categoriaId) {
        this.categoriaId = categoriaId;
    }

    @Generated
    public void setCategoria(Categoria categoria) {
        this.categoria = categoria;
    }

    @Generated
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Generated
    public void setSlug(String slug) {
        this.slug = slug;
    }

    @Generated
    public void setSku(String sku) {
        this.sku = sku;
    }

    @Generated
    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Generated
    public void setTipo(TipoProducto tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setEsPersonalizable(Boolean esPersonalizable) {
        this.esPersonalizable = esPersonalizable;
    }

    @Generated
    public void setPrecioBaseCentimos(Long precioBaseCentimos) {
        this.precioBaseCentimos = precioBaseCentimos;
    }

    @Generated
    public void setPrecioOfertaCentimos(Long precioOfertaCentimos) {
        this.precioOfertaCentimos = precioOfertaCentimos;
    }

    @Generated
    public void setVisibleEnPos(Boolean visibleEnPos) {
        this.visibleEnPos = visibleEnPos;
    }

    @Generated
    public void setVisibleEnStorefront(Boolean visibleEnStorefront) {
        this.visibleEnStorefront = visibleEnStorefront;
    }

    @Generated
    public void setDestacadoStorefront(Boolean destacadoStorefront) {
        this.destacadoStorefront = destacadoStorefront;
    }

    @Generated
    public void setUrlImagenPrincipal(String urlImagenPrincipal) {
        this.urlImagenPrincipal = urlImagenPrincipal;
    }

    @Generated
    public void setImagenesGaleria(List<String> imagenesGaleria) {
        this.imagenesGaleria = imagenesGaleria;
    }

    @Generated
    public void setAtributos(Map<String, Object> atributos) {
        this.atributos = atributos;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }
}

