/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.admin.catalogo.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="categorias", uniqueConstraints={@UniqueConstraint(name="uk_categorias_tienda_nombre", columnNames={"tienda_id", "nombre"}), @UniqueConstraint(name="uk_categorias_tienda_slug", columnNames={"tienda_id", "slug"})})
@SQLDelete(sql="UPDATE categorias SET activa = false WHERE id = ?")
@SQLRestriction(value="activa = true")
public class Categoria {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="tienda_id", nullable=false)
    private Long tiendaId;
    @Column(nullable=false, length=100)
    private String nombre;
    @Column(nullable=false, length=100)
    private String slug;
    @Column(columnDefinition="TEXT")
    private String descripcion;
    @Column(name="url_imagen", columnDefinition="TEXT")
    private String urlImagen;
    @Column(length=100)
    private String icono;
    @Column(nullable=false)
    private Boolean activa = Boolean.TRUE;
    @Column(name="orden_visual")
    private Integer ordenVisual = 0;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;

    @PrePersist
    void onCreate() {
        if (this.activa == null) {
            this.activa = Boolean.TRUE;
        }
        if (this.ordenVisual == null) {
            this.ordenVisual = 0;
        }
        this.creadoEn = LocalDateTime.now();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTiendaId() {
        return this.tiendaId;
    }

    @Generated
    public String getNombre() {
        return this.nombre;
    }

    @Generated
    public String getSlug() {
        return this.slug;
    }

    @Generated
    public String getDescripcion() {
        return this.descripcion;
    }

    @Generated
    public String getUrlImagen() {
        return this.urlImagen;
    }

    @Generated
    public String getIcono() {
        return this.icono;
    }

    @Generated
    public Boolean getActiva() {
        return this.activa;
    }

    @Generated
    public Integer getOrdenVisual() {
        return this.ordenVisual;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTiendaId(Long tiendaId) {
        this.tiendaId = tiendaId;
    }

    @Generated
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Generated
    public void setSlug(String slug) {
        this.slug = slug;
    }

    @Generated
    public void setDescripcion(String descripcion) {
        this.descripcion = descripcion;
    }

    @Generated
    public void setUrlImagen(String urlImagen) {
        this.urlImagen = urlImagen;
    }

    @Generated
    public void setIcono(String icono) {
        this.icono = icono;
    }

    @Generated
    public void setActiva(Boolean activa) {
        this.activa = activa;
    }

    @Generated
    public void setOrdenVisual(Integer ordenVisual) {
        this.ordenVisual = ordenVisual;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }
}

