/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.config;

import com.dulcecontrol.bakery.config.AppHostProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class OpenApiConfig {
    private final AppHostProperties hostProperties;
    private final int serverPort;

    public OpenApiConfig(AppHostProperties hostProperties, @Value(value="${server.port:2250}") int serverPort) {
        this.hostProperties = hostProperties;
        this.serverPort = serverPort;
    }

    @Bean
    public OpenAPI customOpenAPI() {
        String securitySchemeName = "Bearer Authentication";
        ArrayList<Server> servers = new ArrayList<Server>();
        this.hostProperties.getOpenApiServers().forEach(descriptor -> servers.add(new Server().url(descriptor.getUrl()).description(descriptor.getDescription())));
        servers.add(new Server().url("https://localhost:" + this.serverPort).description("Servidor de Desarrollo Local"));
        return new OpenAPI().info(new Info().title("Dulce Control API").version("1.0.0").description("\ud83c\udf70 **API REST para la gesti\u00f3n integral de panader\u00edas y pasteler\u00edas**\n\nSistema multi-tenant que permite al Superadmin gestionar m\u00faltiples tiendas\ncon m\u00f3dulos completos de: Seguridad, Inventario, Ventas, Producci\u00f3n,\nFacturaci\u00f3n, Reportes y m\u00e1s.\n\n---\n\n### \ud83d\udd10 Autenticaci\u00f3n JWT\n\nEsta API utiliza autenticaci\u00f3n stateless con tokens JWT (JSON Web Tokens).\n\n**Pasos para autenticarte:**\n\n1. **Obtenga sus credenciales:**\n   - Vaya a: https://sa-dulcecontrol.vercel.app/token\n   - Registre un usuario\n   - Genere su token JWT\n\n2. **Autorice en Swagger:**\n   - Haga clic en el bot\u00f3n **Authorize \ud83d\udd13** (abajo a la derecha)\n   - En el campo **Value** debe ingresar su token generado.\n   - Haga clic en **Authorize** y luego **Close**\n\n3. **Pruebe los endpoints:**\n   - \u00a1Listo! Ahora puede probar todos los endpoints \ud83c\udf89 Solo seleccione uno de la lista de abajo, desglose y de click a Try it out. Ingrese los parametros necesarios si se requieren.\n\n---\n").license(new License().name("Generador de tokens JWT").url("https://sa-dulcecontrol.vercel.app/token"))).servers(servers).addSecurityItem(new SecurityRequirement().addList("Bearer Authentication")).components(new Components().addSecuritySchemes("Bearer Authentication", new SecurityScheme().name("Bearer Authentication").type(SecurityScheme.Type.HTTP).scheme("bearer").bearerFormat("JWT").description("Ingresa tu token JWT en el formato: Bearer {token}")));
    }
}

