/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.common.exception;

import com.dulcecontrol.bakery.shared.integration.decolecta.DecolectaException;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseEntity<Map<String, Object>> handleValidationExceptions(MethodArgumentNotValidException ex) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        String errors = ex.getBindingResult().getAllErrors().stream().map(error -> {
            String fieldName = error instanceof FieldError ? ((FieldError)error).getField() : error.getObjectName();
            String errorMessage = error.getDefaultMessage();
            return fieldName + ": " + errorMessage;
        }).collect(Collectors.joining("; "));
        response.put("status", HttpStatus.BAD_REQUEST.value());
        response.put("error", "Validation Error");
        response.put("message", errors);
        response.put("timestamp", LocalDateTime.now());
        return ResponseEntity.badRequest().body(response);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public ResponseEntity<Map<String, Object>> handleIllegalArgumentException(IllegalArgumentException ex) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", HttpStatus.BAD_REQUEST.value());
        response.put("error", "Bad Request");
        response.put("message", ex.getMessage());
        response.put("timestamp", LocalDateTime.now());
        return ResponseEntity.badRequest().body(response);
    }

    @ExceptionHandler(value={IllegalStateException.class})
    public ResponseEntity<Map<String, Object>> handleIllegalStateException(IllegalStateException ex) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", HttpStatus.CONFLICT.value());
        response.put("error", "Conflict");
        response.put("message", ex.getMessage());
        response.put("timestamp", LocalDateTime.now());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body(response);
    }

    @ExceptionHandler(value={DecolectaException.class})
    public ResponseEntity<Map<String, Object>> handleDecolectaException(DecolectaException ex) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", HttpStatus.BAD_GATEWAY.value());
        response.put("error", "External Service Error");
        response.put("message", ex.getMessage());
        response.put("timestamp", LocalDateTime.now());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_GATEWAY).body(response);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Map<String, Object>> handleGenericException(Exception ex) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        response.put("status", HttpStatus.INTERNAL_SERVER_ERROR.value());
        response.put("error", "Internal Server Error");
        response.put("message", ex.getMessage() != null ? ex.getMessage() : "Ha ocurrido un error inesperado");
        response.put("timestamp", LocalDateTime.now());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body(response);
    }
}

