/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.shared.integration.decolecta;

import com.dulcecontrol.bakery.shared.integration.decolecta.DecolectaService;
import com.dulcecontrol.bakery.shared.integration.decolecta.dto.ReniecDniResponse;
import com.dulcecontrol.bakery.shared.integration.decolecta.dto.SunatRucBasicoResponse;
import com.dulcecontrol.bakery.shared.integration.decolecta.dto.SunatRucFullResponse;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/integration/decolecta"})
public class DecolectaController {
    private final DecolectaService decolectaService;

    @GetMapping(value={"/reniec/dni/{dni}"})
    public ResponseEntity<ReniecDniResponse> consultarDni(@PathVariable String dni) {
        ReniecDniResponse response = this.decolectaService.consultarPersonaPorDni(dni);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/sunat/ruc/{ruc}"})
    public ResponseEntity<SunatRucBasicoResponse> consultarRucBasico(@PathVariable String ruc) {
        SunatRucBasicoResponse response = this.decolectaService.consultarEmpresaPorRucBasico(ruc);
        return ResponseEntity.ok((Object)response);
    }

    @GetMapping(value={"/sunat/ruc/{ruc}/full"})
    public ResponseEntity<SunatRucFullResponse> consultarRucCompleto(@PathVariable String ruc) {
        SunatRucFullResponse response = this.decolectaService.consultarEmpresaPorRucCompleto(ruc);
        return ResponseEntity.ok((Object)response);
    }

    @Generated
    public DecolectaController(DecolectaService decolectaService) {
        this.decolectaService = decolectaService;
    }
}

