/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.shared.integration.decolecta;

import com.dulcecontrol.bakery.shared.integration.decolecta.DecolectaException;
import com.dulcecontrol.bakery.shared.integration.decolecta.DecolectaProperties;
import com.dulcecontrol.bakery.shared.integration.decolecta.dto.ReniecDniResponse;
import com.dulcecontrol.bakery.shared.integration.decolecta.dto.SunatRucBasicoResponse;
import com.dulcecontrol.bakery.shared.integration.decolecta.dto.SunatRucFullResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;

@Component
public class DecolectaClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecolectaClient.class);
    private final DecolectaProperties properties;
    private final RestClient.Builder restClientBuilder;

    public ReniecDniResponse consultarDni(String dni) {
        this.validateToken();
        try {
            RestClient client = this.restClientBuilder.baseUrl(this.properties.getBaseUrl()).defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("Authorization", new String[]{"Bearer " + this.properties.getApiToken()}).build();
            ReniecDniResponse response = (ReniecDniResponse)client.get().uri("/reniec/dni?numero={dni}", new Object[]{dni}).retrieve().body(ReniecDniResponse.class);
            log.info("Consulta DNI exitosa: {}", (Object)dni);
            return response;
        }
        catch (RestClientException e) {
            log.error("Error al consultar DNI {}: {}", (Object)dni, (Object)e.getMessage());
            throw new DecolectaException("Error al consultar DNI en RENIEC: " + e.getMessage(), (Throwable)e);
        }
    }

    public SunatRucBasicoResponse consultarRucBasico(String ruc) {
        this.validateToken();
        try {
            RestClient client = this.restClientBuilder.baseUrl(this.properties.getBaseUrl()).defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("Authorization", new String[]{"Bearer " + this.properties.getApiToken()}).build();
            SunatRucBasicoResponse response = (SunatRucBasicoResponse)client.get().uri("/sunat/ruc?numero={ruc}", new Object[]{ruc}).retrieve().body(SunatRucBasicoResponse.class);
            log.info("Consulta RUC b\u00e1sico exitosa: {}", (Object)ruc);
            return response;
        }
        catch (RestClientException e) {
            log.error("Error al consultar RUC b\u00e1sico {}: {}", (Object)ruc, (Object)e.getMessage());
            throw new DecolectaException("Error al consultar RUC b\u00e1sico en SUNAT: " + e.getMessage(), (Throwable)e);
        }
    }

    public SunatRucFullResponse consultarRucCompleto(String ruc) {
        this.validateToken();
        try {
            RestClient client = this.restClientBuilder.baseUrl(this.properties.getBaseUrl()).defaultHeader("Accept", new String[]{"application/json"}).defaultHeader("Authorization", new String[]{"Bearer " + this.properties.getApiToken()}).build();
            SunatRucFullResponse response = (SunatRucFullResponse)client.get().uri("/sunat/ruc/full?numero={ruc}", new Object[]{ruc}).retrieve().body(SunatRucFullResponse.class);
            log.info("Consulta RUC completo exitosa: {}", (Object)ruc);
            return response;
        }
        catch (RestClientException e) {
            log.error("Error al consultar RUC completo {}: {}", (Object)ruc, (Object)e.getMessage());
            throw new DecolectaException("Error al consultar RUC completo en SUNAT: " + e.getMessage(), (Throwable)e);
        }
    }

    private void validateToken() {
        if (this.properties.getApiToken() == null || this.properties.getApiToken().isBlank()) {
            throw new DecolectaException("API Token de DECOLECTA no configurado. Configure 'decolecta.api-token' en application.properties");
        }
    }

    @Generated
    public DecolectaClient(DecolectaProperties properties, RestClient.Builder restClientBuilder) {
        this.properties = properties;
        this.restClientBuilder = restClientBuilder;
    }
}

