/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.security.auth.controller;

import com.dulcecontrol.bakery.features.storefront.auth.dto.ActivarCuentaRequest;
import com.dulcecontrol.bakery.features.storefront.auth.dto.VerificarEmailResponse;
import com.dulcecontrol.bakery.security.auth.dto.AdminLoginRequest;
import com.dulcecontrol.bakery.security.auth.dto.AuthTokenResponse;
import com.dulcecontrol.bakery.security.auth.dto.StorefrontLoginRequest;
import com.dulcecontrol.bakery.security.auth.dto.StorefrontRegisterRequest;
import com.dulcecontrol.bakery.security.auth.dto.SuperadminLoginRequest;
import com.dulcecontrol.bakery.security.auth.service.AuthService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auth"})
public class AuthController {
    private final AuthService authService;

    @PostMapping(value={"/superadmin/login"})
    public ResponseEntity<AuthTokenResponse> loginSuperadmin(@Valid @RequestBody SuperadminLoginRequest request) {
        return ResponseEntity.ok((Object)this.authService.loginSuperadmin(request));
    }

    @PostMapping(value={"/admin/login"})
    public ResponseEntity<AuthTokenResponse> loginAdmin(@Valid @RequestBody AdminLoginRequest request) {
        return ResponseEntity.ok((Object)this.authService.loginAdmin(request));
    }

    @PostMapping(value={"/storefront/login"})
    public ResponseEntity<AuthTokenResponse> loginStorefront(@Valid @RequestBody StorefrontLoginRequest request) {
        return ResponseEntity.ok((Object)this.authService.loginStorefront(request));
    }

    @PostMapping(value={"/storefront/register"})
    public ResponseEntity<AuthTokenResponse> registerStorefront(@Valid @RequestBody StorefrontRegisterRequest request) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)this.authService.registerStorefront(request));
    }

    @GetMapping(value={"/storefront/verificar-email"})
    public ResponseEntity<VerificarEmailResponse> verificarEmail(@RequestParam Long tiendaId, @RequestParam String email) {
        return ResponseEntity.ok((Object)this.authService.verificarEmail(tiendaId, email));
    }

    @PostMapping(value={"/storefront/activar-cuenta"})
    public ResponseEntity<AuthTokenResponse> activarCuenta(@RequestParam Long tiendaId, @Valid @RequestBody ActivarCuentaRequest request) {
        return ResponseEntity.ok((Object)this.authService.activarCuenta(tiendaId, request));
    }

    @Generated
    public AuthController(AuthService authService) {
        this.authService = authService;
    }
}

