/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.security;

import com.dulcecontrol.bakery.security.TipoUsuario;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JwtProvider {
    @Value(value="${security.jwt.secret-key}")
    private String secretKey;
    @Value(value="${security.jwt.expiration-time}")
    private Long expirationTime;

    private Key getSigningKey() {
        return Keys.hmacShaKeyFor((byte[])this.secretKey.getBytes(StandardCharsets.UTF_8));
    }

    public String generarToken(String correo, String rolId) {
        return this.generarToken(correo, rolId, TipoUsuario.DEVELOPER, null, null);
    }

    public String generarToken(String correo, String rol, TipoUsuario tipoUsuario, Long tiendaId) {
        return this.generarToken(correo, rol, tipoUsuario, tiendaId, null);
    }

    public String generarToken(String correo, String rol, TipoUsuario tipoUsuario, Long tiendaId, Map<String, Object> extraClaims) {
        return this.generarToken(correo, rol, tipoUsuario, tiendaId, extraClaims, null);
    }

    public String generarToken(String correo, String rol, TipoUsuario tipoUsuario, Long tiendaId, Map<String, Object> extraClaims, Long userId) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("rol_id", rol);
        claims.put("tipo_usuario", tipoUsuario != null ? tipoUsuario.name() : null);
        if (tiendaId != null) {
            claims.put("tienda_id", tiendaId);
        }
        if (userId != null) {
            claims.put("id", userId);
        }
        if (extraClaims != null && !extraClaims.isEmpty()) {
            claims.putAll(extraClaims);
        }
        return Jwts.builder().setClaims(claims).setSubject(correo).setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + this.expirationTime)).signWith(this.getSigningKey(), SignatureAlgorithm.HS256).compact();
    }

    public String extraerCorreo(String token) {
        return this.extraerClaims(token).getSubject();
    }

    public String extraerRolId(String token) {
        return (String)this.extraerClaims(token).get("rol_id", String.class);
    }

    public TipoUsuario extraerTipoUsuario(String token) {
        String rawTipo = (String)this.extraerClaims(token).get("tipo_usuario", String.class);
        if (rawTipo == null) {
            return null;
        }
        try {
            return TipoUsuario.valueOf((String)rawTipo);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public Long extraerTiendaId(String token) {
        Claims claims = this.extraerClaims(token);
        Object tiendaId = claims.get((Object)"tienda_id");
        if (tiendaId instanceof Number) {
            Number number = (Number)tiendaId;
            return number.longValue();
        }
        return null;
    }

    public Date extraerExpiracion(String token) {
        return this.extraerClaims(token).getExpiration();
    }

    private Claims extraerClaims(String token) {
        return (Claims)Jwts.parserBuilder().setSigningKey(this.getSigningKey()).build().parseClaimsJws(token).getBody();
    }

    public boolean validarToken(String token) {
        try {
            this.extraerClaims(token);
            return !this.tokenExpirado(token);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean tokenExpirado(String token) {
        return this.extraerExpiracion(token).before(new Date());
    }

    public Long getExpirationTime() {
        return this.expirationTime / 1000L;
    }
}

