/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.security;

import com.dulcecontrol.bakery.features.admin.clientes.repository.ClienteRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.repository.UsuarioTiendaRepository;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.UsuarioSuperadminRepository;
import com.dulcecontrol.bakery.security.JwtAuthenticationFilter;
import com.dulcecontrol.bakery.security.JwtProvider;
import com.dulcecontrol.bakery.security.TipoUsuario;
import com.dulcecontrol.bakery.security.token.entity.DesarrolladorToken;
import com.dulcecontrol.bakery.security.token.repository.DesarrolladorTokenRepository;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JwtAuthenticationFilter.class);
    private final JwtProvider jwtProvider;
    private final DesarrolladorTokenRepository desarrolladorTokenRepository;
    private final UsuarioSuperadminRepository usuarioSuperadminRepository;
    private final UsuarioTiendaRepository usuarioTiendaRepository;
    private final ClienteRepository clienteRepository;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String header = request.getHeader("Authorization");
        String token = this.extraerToken(header);
        try {
            if (token != null && this.jwtProvider.validarToken(token) && SecurityContextHolder.getContext().getAuthentication() == null) {
                String correo = this.jwtProvider.extraerCorreo(token);
                TipoUsuario tipoUsuario = this.jwtProvider.extraerTipoUsuario(token);
                if (tipoUsuario == null) {
                    tipoUsuario = TipoUsuario.DEVELOPER;
                }
                Long tiendaId = this.jwtProvider.extraerTiendaId(token);
                switch (1.$SwitchMap$com$dulcecontrol$bakery$security$TipoUsuario[tipoUsuario.ordinal()]) {
                    case 1: {
                        this.autenticarSuperadmin(correo, request);
                        break;
                    }
                    case 2: {
                        this.autenticarUsuarioTienda(correo, tiendaId, request);
                        break;
                    }
                    case 3: {
                        this.autenticarCliente(correo, tiendaId, request);
                        break;
                    }
                    case 4: {
                        this.autenticarDesarrollador(correo, request);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.debug("Error validando token JWT: {}", (Object)ex.getMessage());
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String extraerToken(String header) {
        if (StringUtils.hasText((String)header) && header.startsWith("Bearer ")) {
            return header.substring(7);
        }
        return null;
    }

    private void autenticarDesarrollador(String correo, HttpServletRequest request) {
        this.desarrolladorTokenRepository.findByCorreo(correo).filter(DesarrolladorToken::getActivo).ifPresent(dev -> this.establecerAutenticacion(dev.getCorreo(), TipoUsuario.DEVELOPER, null, request));
    }

    private void autenticarSuperadmin(String correo, HttpServletRequest request) {
        this.usuarioSuperadminRepository.findByCorreo(correo).filter(usuario -> Boolean.TRUE.equals(usuario.getActivo())).ifPresent(usuario -> this.establecerAutenticacion(usuario.getCorreo(), TipoUsuario.SUPERADMIN, null, request));
    }

    private void autenticarUsuarioTienda(String correo, Long tiendaIdToken, HttpServletRequest request) {
        this.usuarioTiendaRepository.findByCorreo(correo).ifPresent(usuario -> {
            if (!Boolean.TRUE.equals(usuario.getActivo())) {
                return;
            }
            if (tiendaIdToken != null && !tiendaIdToken.equals(usuario.getTiendaId())) {
                log.debug("El token de tienda no coincide con la tienda del usuario");
                return;
            }
            this.establecerAutenticacion(usuario.getCorreo(), TipoUsuario.ADMIN, usuario.getTiendaId(), request);
        });
    }

    private void autenticarCliente(String correo, Long tiendaId, HttpServletRequest request) {
        if (tiendaId == null) {
            log.debug("Token de cliente sin tiendaId");
            return;
        }
        this.clienteRepository.findByTiendaIdAndEmail(tiendaId, correo).ifPresent(cliente -> this.establecerAutenticacion(cliente.getEmail(), TipoUsuario.CLIENTE, tiendaId, request));
    }

    private void establecerAutenticacion(String principal, TipoUsuario tipoUsuario, Long tiendaId, HttpServletRequest request) {
        List<SimpleGrantedAuthority> authorities = Collections.singletonList(new SimpleGrantedAuthority("ROLE_" + tipoUsuario.name()));
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)principal, null, authorities);
        authenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
        request.setAttribute("tiendaId", (Object)tiendaId);
        request.setAttribute("userType", (Object)tipoUsuario);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
    }

    @Generated
    public JwtAuthenticationFilter(JwtProvider jwtProvider, DesarrolladorTokenRepository desarrolladorTokenRepository, UsuarioSuperadminRepository usuarioSuperadminRepository, UsuarioTiendaRepository usuarioTiendaRepository, ClienteRepository clienteRepository) {
        this.jwtProvider = jwtProvider;
        this.desarrolladorTokenRepository = desarrolladorTokenRepository;
        this.usuarioSuperadminRepository = usuarioSuperadminRepository;
        this.usuarioTiendaRepository = usuarioTiendaRepository;
        this.clienteRepository = clienteRepository;
    }
}

