/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tiendas.service.impl;

import com.dulcecontrol.bakery.features.admin.clientes.entity.Cliente;
import com.dulcecontrol.bakery.features.admin.clientes.repository.ClienteRepository;
import com.dulcecontrol.bakery.features.admin.configuracion.entity.ConfiguracionTienda;
import com.dulcecontrol.bakery.features.admin.configuracion.repository.ConfiguracionTiendaRepository;
import com.dulcecontrol.bakery.features.admin.seguridad.service.RolSistemaBootstrapService;
import com.dulcecontrol.bakery.features.shared.ubigeo.repository.UbigeoDistritoRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.TiendaCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.TiendaResponse;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.TiendaUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Tienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.enums.EstadoTienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.TiendaRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.service.ITiendaSuperAdminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TiendaSuperAdminService
implements ITiendaSuperAdminService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TiendaSuperAdminService.class);
    private final TiendaRepository tiendaRepository;
    private final BCryptPasswordEncoder passwordEncoder;
    private final RolSistemaBootstrapService rolSistemaBootstrapService;
    private final ClienteRepository clienteRepository;
    private final ConfiguracionTiendaRepository configuracionTiendaRepository;
    private final UbigeoDistritoRepository ubigeoDistritoRepository;

    @Transactional(readOnly=true)
    public List<TiendaResponse> listar() {
        List tiendas = this.tiendaRepository.findAll();
        if (tiendas.isEmpty()) {
            return List.of();
        }
        List<Long> tiendaIds = tiendas.stream().map(Tienda::getId).toList();
        Map<Long, ConfiguracionTienda> configuraciones = this.configuracionTiendaRepository.findAllById(tiendaIds).stream().collect(Collectors.toMap(ConfiguracionTienda::getTiendaId, config -> config));
        return tiendas.stream().map(tienda -> this.toResponse(tienda, (ConfiguracionTienda)configuraciones.get(tienda.getId()))).toList();
    }

    @Transactional(readOnly=true)
    public TiendaResponse obtenerPorId(Long tiendaId) {
        Tienda tienda = this.obtenerEntidad(tiendaId);
        ConfiguracionTienda configuracion = this.configuracionTiendaRepository.findByTiendaId(tiendaId).orElse(null);
        return this.toResponse(tienda, configuracion);
    }

    @Transactional
    public TiendaResponse crear(TiendaCreateRequest request) {
        String slugNormalizado = this.normalizarSlug(request.getSlug());
        this.validarUnicidadCreacion(slugNormalizado, request);
        Tienda tienda = Tienda.builder().slug(slugNormalizado).tipoDoc(request.getTipoDoc()).numeroDoc(request.getNumeroDoc().trim()).nombreDoc(request.getNombreDoc().trim()).nombreComercial(request.getNombreComercial()).correoContacto(request.getCorreoContacto().trim().toLowerCase()).telefonoContacto(request.getTelefonoContacto()).hashContrasena(this.passwordEncoder.encode((CharSequence)request.getContrasena())).estado(request.getEstado() != null ? request.getEstado() : EstadoTienda.EN_PRUEBA).build();
        Tienda guardada = (Tienda)this.tiendaRepository.save((Object)tienda);
        ConfiguracionTienda configuracion = this.sincronizarDatosEmpresa(guardada.getId(), request.getNumeroDoc().trim(), request.getNombreDoc().trim(), request.getDireccionFiscal().trim(), request.getUbigeoFiscal().trim());
        this.rolSistemaBootstrapService.ensureDefaultRoles(guardada.getId());
        this.crearClienteGenerico(guardada.getId());
        return this.toResponse(guardada, configuracion);
    }

    private void crearClienteGenerico(Long tiendaId) {
        if (this.clienteRepository.existsByTiendaIdAndNumeroDoc(tiendaId, "00000000")) {
            log.info("Cliente gen\u00e9rico ya existe para tienda {}", (Object)tiendaId);
            return;
        }
        Cliente clienteGenerico = new Cliente();
        clienteGenerico.setTiendaId(tiendaId);
        clienteGenerico.setTipoDoc(null);
        clienteGenerico.setNumeroDoc("00000000");
        clienteGenerico.setNombreDoc("CLIENTE GEN\u00c9RICO");
        clienteGenerico.setEmail(null);
        clienteGenerico.setTelefono(null);
        clienteGenerico.setEsUsuarioVirtual(Boolean.valueOf(false));
        clienteGenerico.setHashContrasena(null);
        clienteGenerico.setNotas("Cliente gen\u00e9rico para ventas sin identificaci\u00f3n. Creado autom\u00e1ticamente por el sistema.");
        clienteGenerico.setActivo(Boolean.valueOf(true));
        this.clienteRepository.save((Object)clienteGenerico);
        log.info("Cliente gen\u00e9rico creado autom\u00e1ticamente para tienda {}", (Object)tiendaId);
    }

    @Transactional
    public TiendaResponse actualizar(Long tiendaId, TiendaUpdateRequest request) {
        Tienda tienda = this.obtenerEntidad(tiendaId);
        String slugNormalizado = this.normalizarSlug(request.getSlug());
        this.validarUnicidadActualizacion(tiendaId, slugNormalizado, request);
        tienda.setSlug(slugNormalizado);
        tienda.setTipoDoc(request.getTipoDoc());
        tienda.setNumeroDoc(request.getNumeroDoc().trim());
        tienda.setNombreDoc(request.getNombreDoc().trim());
        tienda.setNombreComercial(request.getNombreComercial());
        tienda.setCorreoContacto(request.getCorreoContacto().trim().toLowerCase());
        tienda.setTelefonoContacto(request.getTelefonoContacto());
        tienda.setEstado(request.getEstado());
        if (request.getNuevaContrasena() != null && !request.getNuevaContrasena().isBlank()) {
            tienda.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getNuevaContrasena()));
        }
        Tienda actualizada = (Tienda)this.tiendaRepository.save((Object)tienda);
        ConfiguracionTienda configuracion = this.sincronizarDatosEmpresa(actualizada.getId(), request.getNumeroDoc().trim(), request.getNombreDoc().trim(), request.getDireccionFiscal().trim(), request.getUbigeoFiscal().trim());
        return this.toResponse(actualizada, configuracion);
    }

    @Transactional
    public void eliminar(Long tiendaId) {
        Tienda tienda = this.obtenerEntidad(tiendaId);
        this.tiendaRepository.delete((Object)tienda);
    }

    private Tienda obtenerEntidad(Long tiendaId) {
        return (Tienda)this.tiendaRepository.findById((Object)tiendaId).orElseThrow(() -> new ResourceNotFoundException("La tienda solicitada no existe"));
    }

    private void validarUnicidadCreacion(String slugNormalizado, TiendaCreateRequest request) {
        if (this.tiendaRepository.existsBySlug(slugNormalizado)) {
            throw new BadRequestException("Ya existe una tienda con el mismo slug");
        }
        if (this.tiendaRepository.existsByNumeroDoc(request.getNumeroDoc())) {
            throw new BadRequestException("Ya existe una tienda con el mismo numero de documento");
        }
        if (this.tiendaRepository.existsByCorreoContacto(request.getCorreoContacto().trim().toLowerCase())) {
            throw new BadRequestException("Ya existe una tienda con el mismo correo de contacto");
        }
    }

    private void validarUnicidadActualizacion(Long tiendaId, String slugNormalizado, TiendaUpdateRequest request) {
        if (this.tiendaRepository.existsBySlugAndIdNot(slugNormalizado, tiendaId)) {
            throw new BadRequestException("El slug ya esta en uso por otra tienda");
        }
        if (this.tiendaRepository.existsByNumeroDocAndIdNot(request.getNumeroDoc(), tiendaId)) {
            throw new BadRequestException("Ya existe otra tienda con el mismo numero de documento");
        }
        if (this.tiendaRepository.existsByCorreoContactoAndIdNot(request.getCorreoContacto().trim().toLowerCase(), tiendaId)) {
            throw new BadRequestException("Ya existe otra tienda con el mismo correo de contacto");
        }
    }

    private TiendaResponse toResponse(Tienda tienda, ConfiguracionTienda configuracion) {
        return TiendaResponse.builder().id(tienda.getId()).slug(tienda.getSlug()).tipoDoc(tienda.getTipoDoc()).numeroDoc(tienda.getNumeroDoc()).nombreDoc(tienda.getNombreDoc()).nombreComercial(tienda.getNombreComercial()).correoContacto(tienda.getCorreoContacto()).telefonoContacto(tienda.getTelefonoContacto()).direccionFiscal(configuracion != null ? configuracion.getDireccionFiscal() : null).ubigeoFiscal(configuracion != null ? configuracion.getUbigeoFiscal() : null).estado(tienda.getEstado()).creadoEn(tienda.getCreadoEn()).actualizadoEn(tienda.getActualizadoEn()).build();
    }

    private ConfiguracionTienda sincronizarDatosEmpresa(Long tiendaId, String numeroDoc, String nombreDoc, String direccionFiscal, String ubigeoFiscal) {
        this.validarUbigeoFiscal(ubigeoFiscal);
        ConfiguracionTienda configuracion = this.configuracionTiendaRepository.findByTiendaId(tiendaId).orElseGet(() -> {
            ConfiguracionTienda nueva = new ConfiguracionTienda();
            nueva.setTiendaId(tiendaId);
            return nueva;
        });
        configuracion.setRuc(numeroDoc);
        configuracion.setRazonSocial(nombreDoc);
        configuracion.setDireccionFiscal(direccionFiscal);
        configuracion.setUbigeoFiscal(ubigeoFiscal);
        return (ConfiguracionTienda)this.configuracionTiendaRepository.save((Object)configuracion);
    }

    private void validarUbigeoFiscal(String ubigeoFiscal) {
        if (!this.ubigeoDistritoRepository.existsByCodigoUbigeo(ubigeoFiscal)) {
            throw new BadRequestException("El ubigeo fiscal ingresado no existe en el padr\u00f3n oficial. Verifica el c\u00f3digo (6 d\u00edgitos).");
        }
    }

    private String normalizarSlug(String slug) {
        return slug.trim().toLowerCase();
    }

    @Generated
    public TiendaSuperAdminService(TiendaRepository tiendaRepository, BCryptPasswordEncoder passwordEncoder, RolSistemaBootstrapService rolSistemaBootstrapService, ClienteRepository clienteRepository, ConfiguracionTiendaRepository configuracionTiendaRepository, UbigeoDistritoRepository ubigeoDistritoRepository) {
        this.tiendaRepository = tiendaRepository;
        this.passwordEncoder = passwordEncoder;
        this.rolSistemaBootstrapService = rolSistemaBootstrapService;
        this.clienteRepository = clienteRepository;
        this.configuracionTiendaRepository = configuracionTiendaRepository;
        this.ubigeoDistritoRepository = ubigeoDistritoRepository;
    }
}

