/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tiendas.service.impl;

import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.SedeCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.SedeResponse;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.SedeUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Sede;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Tienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.SedeRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.repository.TiendaRepository;
import com.dulcecontrol.bakery.features.superadmin.tiendas.service.ISedeSuperAdminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SedeSuperAdminService
implements ISedeSuperAdminService {
    private final SedeRepository sedeRepository;
    private final TiendaRepository tiendaRepository;

    @Transactional(readOnly=true)
    public List<SedeResponse> listarPorTienda(Long tiendaId) {
        this.validarTiendaExiste(tiendaId);
        return this.sedeRepository.findByTiendaId(tiendaId).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public SedeResponse obtenerPorId(Long tiendaId, Long sedeId) {
        Sede sede = this.obtenerSede(tiendaId, sedeId);
        return this.toResponse(sede);
    }

    @Transactional
    public SedeResponse crear(Long tiendaId, SedeCreateRequest request) {
        Tienda tienda = this.obtenerTienda(tiendaId);
        this.validarCodigoInternoDisponible(tiendaId, request.getCodigoInterno(), null);
        this.validarPrincipalUnico(tiendaId, request.getEsPrincipal());
        Sede sede = Sede.builder().tienda(tienda).codigoInterno(this.normalizar(request.getCodigoInterno())).nombre(request.getNombre().trim()).direccion(request.getDireccion().trim()).telefono(this.normalizar(request.getTelefono())).distritoId(request.getDistritoId()).esPrincipal(Boolean.valueOf(Boolean.TRUE.equals(request.getEsPrincipal()))).build();
        Sede guardada = (Sede)this.sedeRepository.save((Object)sede);
        return this.toResponse(guardada);
    }

    @Transactional
    public SedeResponse actualizar(Long tiendaId, Long sedeId, SedeUpdateRequest request) {
        Sede sede = this.obtenerSede(tiendaId, sedeId);
        this.validarCodigoInternoDisponible(tiendaId, request.getCodigoInterno(), sedeId);
        this.validarPrincipalEnActualizacion(tiendaId, sede, request.getEsPrincipal());
        sede.setCodigoInterno(this.normalizar(request.getCodigoInterno()));
        sede.setNombre(request.getNombre().trim());
        sede.setDireccion(request.getDireccion().trim());
        sede.setTelefono(this.normalizar(request.getTelefono()));
        sede.setDistritoId(request.getDistritoId());
        if (request.getEsPrincipal() != null) {
            sede.setEsPrincipal(request.getEsPrincipal());
        }
        if (request.getActivo() != null) {
            sede.setActivo(request.getActivo());
        }
        Sede actualizada = (Sede)this.sedeRepository.save((Object)sede);
        return this.toResponse(actualizada);
    }

    @Transactional
    public void eliminar(Long tiendaId, Long sedeId) {
        Sede sede = this.obtenerSede(tiendaId, sedeId);
        this.sedeRepository.delete((Object)sede);
    }

    private Sede obtenerSede(Long tiendaId, Long sedeId) {
        return (Sede)this.sedeRepository.findByIdAndTiendaId(sedeId, tiendaId).orElseThrow(() -> new ResourceNotFoundException("La sede solicitada no existe para la tienda indicada"));
    }

    private Tienda obtenerTienda(Long tiendaId) {
        return (Tienda)this.tiendaRepository.findById((Object)tiendaId).orElseThrow(() -> new ResourceNotFoundException("La tienda indicada no existe"));
    }

    private void validarTiendaExiste(Long tiendaId) {
        if (!this.tiendaRepository.existsById((Object)tiendaId)) {
            throw new ResourceNotFoundException("La tienda indicada no existe");
        }
    }

    private void validarCodigoInternoDisponible(Long tiendaId, String codigoInterno, Long sedeId) {
        boolean repetido;
        if (codigoInterno == null || codigoInterno.isBlank()) {
            return;
        }
        String normalizado = codigoInterno.trim();
        boolean bl = repetido = sedeId == null ? this.sedeRepository.existsByTiendaIdAndCodigoInterno(tiendaId, normalizado) : this.sedeRepository.existsByTiendaIdAndCodigoInternoAndIdNot(tiendaId, normalizado, sedeId);
        if (repetido) {
            throw new BadRequestException("Ya existe una sede con el mismo codigo interno en la tienda");
        }
    }

    private void validarPrincipalUnico(Long tiendaId, Boolean esPrincipalSolicitado) {
        if (!Boolean.TRUE.equals(esPrincipalSolicitado)) {
            return;
        }
        long totalPrincipales = this.sedeRepository.countByTiendaIdAndEsPrincipalTrue(tiendaId);
        if (totalPrincipales > 0L) {
            throw new BadRequestException("La tienda ya tiene una sede principal");
        }
    }

    private void validarPrincipalEnActualizacion(Long tiendaId, Sede sede, Boolean esPrincipalSolicitado) {
        long otrasPrincipales;
        if (esPrincipalSolicitado == null) {
            return;
        }
        if (Boolean.TRUE.equals(esPrincipalSolicitado)) {
            if (!Boolean.TRUE.equals(sede.getEsPrincipal())) {
                this.validarPrincipalUnico(tiendaId, Boolean.TRUE);
            }
            return;
        }
        if (Boolean.TRUE.equals(sede.getEsPrincipal()) && Boolean.FALSE.equals(esPrincipalSolicitado) && (otrasPrincipales = this.sedeRepository.countByTiendaIdAndEsPrincipalTrue(tiendaId)) <= 1L) {
            throw new BadRequestException("La tienda debe mantener al menos una sede principal");
        }
    }

    private SedeResponse toResponse(Sede sede) {
        return SedeResponse.builder().id(sede.getId()).tiendaId(sede.getTienda().getId()).codigoInterno(sede.getCodigoInterno()).nombre(sede.getNombre()).direccion(sede.getDireccion()).telefono(sede.getTelefono()).distritoId(sede.getDistritoId()).esPrincipal(sede.getEsPrincipal()).activo(sede.getActivo()).creadoEn(sede.getCreadoEn()).actualizadoEn(sede.getActualizadoEn()).build();
    }

    private String normalizar(String valor) {
        return valor == null ? null : valor.trim();
    }

    @Generated
    public SedeSuperAdminService(SedeRepository sedeRepository, TiendaRepository tiendaRepository) {
        this.sedeRepository = sedeRepository;
        this.tiendaRepository = tiendaRepository;
    }
}

