/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tiendas.entity;

import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Tienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.enums.EstadoTienda;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.enums.TipoDocumentoTienda;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="tiendas")
@SQLDelete(sql="UPDATE tiendas SET eliminado_en = NOW() WHERE id = ?")
@SQLRestriction(value="eliminado_en IS NULL")
public class Tienda {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(nullable=false, length=100)
    private String slug;
    @Enumerated(value=EnumType.STRING)
    @Column(name="tipo_doc", nullable=false, length=3)
    private TipoDocumentoTienda tipoDoc;
    @Column(name="numero_doc", nullable=false, unique=true, length=20)
    private String numeroDoc;
    @Column(name="nombre_doc", nullable=false)
    private String nombreDoc;
    @Column(name="nombre_comercial")
    private String nombreComercial;
    @Column(name="correo_contacto", nullable=false)
    private String correoContacto;
    @Column(name="telefono_contacto")
    private String telefonoContacto;
    @Column(name="hash_contrasena", nullable=false)
    private String hashContrasena;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false, length=20)
    private EstadoTienda estado;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;
    @Column(name="eliminado_en")
    private LocalDateTime eliminadoEn;

    @PrePersist
    void onCreate() {
        LocalDateTime now;
        this.creadoEn = now = LocalDateTime.now();
        this.actualizadoEn = now;
        if (this.estado == null) {
            this.estado = EstadoTienda.EN_PRUEBA;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public static TiendaBuilder builder() {
        return new TiendaBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getSlug() {
        return this.slug;
    }

    @Generated
    public TipoDocumentoTienda getTipoDoc() {
        return this.tipoDoc;
    }

    @Generated
    public String getNumeroDoc() {
        return this.numeroDoc;
    }

    @Generated
    public String getNombreDoc() {
        return this.nombreDoc;
    }

    @Generated
    public String getNombreComercial() {
        return this.nombreComercial;
    }

    @Generated
    public String getCorreoContacto() {
        return this.correoContacto;
    }

    @Generated
    public String getTelefonoContacto() {
        return this.telefonoContacto;
    }

    @Generated
    public String getHashContrasena() {
        return this.hashContrasena;
    }

    @Generated
    public EstadoTienda getEstado() {
        return this.estado;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public LocalDateTime getEliminadoEn() {
        return this.eliminadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setSlug(String slug) {
        this.slug = slug;
    }

    @Generated
    public void setTipoDoc(TipoDocumentoTienda tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @Generated
    public void setNumeroDoc(String numeroDoc) {
        this.numeroDoc = numeroDoc;
    }

    @Generated
    public void setNombreDoc(String nombreDoc) {
        this.nombreDoc = nombreDoc;
    }

    @Generated
    public void setNombreComercial(String nombreComercial) {
        this.nombreComercial = nombreComercial;
    }

    @Generated
    public void setCorreoContacto(String correoContacto) {
        this.correoContacto = correoContacto;
    }

    @Generated
    public void setTelefonoContacto(String telefonoContacto) {
        this.telefonoContacto = telefonoContacto;
    }

    @Generated
    public void setHashContrasena(String hashContrasena) {
        this.hashContrasena = hashContrasena;
    }

    @Generated
    public void setEstado(EstadoTienda estado) {
        this.estado = estado;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public void setEliminadoEn(LocalDateTime eliminadoEn) {
        this.eliminadoEn = eliminadoEn;
    }

    @Generated
    public Tienda() {
    }

    @Generated
    public Tienda(Long id, String slug, TipoDocumentoTienda tipoDoc, String numeroDoc, String nombreDoc, String nombreComercial, String correoContacto, String telefonoContacto, String hashContrasena, EstadoTienda estado, LocalDateTime creadoEn, LocalDateTime actualizadoEn, LocalDateTime eliminadoEn) {
        this.id = id;
        this.slug = slug;
        this.tipoDoc = tipoDoc;
        this.numeroDoc = numeroDoc;
        this.nombreDoc = nombreDoc;
        this.nombreComercial = nombreComercial;
        this.correoContacto = correoContacto;
        this.telefonoContacto = telefonoContacto;
        this.hashContrasena = hashContrasena;
        this.estado = estado;
        this.creadoEn = creadoEn;
        this.actualizadoEn = actualizadoEn;
        this.eliminadoEn = eliminadoEn;
    }
}

