/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tiendas.entity;

import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Sede;
import com.dulcecontrol.bakery.features.superadmin.tiendas.entity.Tienda;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.SQLRestriction;

@Entity
@Table(name="sedes")
@SQLDelete(sql="UPDATE sedes SET eliminado_en = NOW(), activo = false WHERE id = ?")
@SQLRestriction(value="eliminado_en IS NULL")
public class Sede {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="tienda_id", nullable=false)
    private Tienda tienda;
    @Column(name="codigo_interno", length=50)
    private String codigoInterno;
    @Column(nullable=false, length=100)
    private String nombre;
    @Column(nullable=false, columnDefinition="TEXT")
    private String direccion;
    @Column(length=50)
    private String telefono;
    @Column(name="distrito_id")
    private Long distritoId;
    @Column(name="es_principal", nullable=false)
    private Boolean esPrincipal;
    @Column(nullable=false)
    private Boolean activo;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;
    @Column(name="actualizado_en")
    private LocalDateTime actualizadoEn;
    @Column(name="eliminado_en")
    private LocalDateTime eliminadoEn;

    @PrePersist
    void onCreate() {
        LocalDateTime now;
        this.creadoEn = now = LocalDateTime.now();
        this.actualizadoEn = now;
        if (this.esPrincipal == null) {
            this.esPrincipal = Boolean.FALSE;
        }
        if (this.activo == null) {
            this.activo = Boolean.TRUE;
        }
    }

    @PreUpdate
    void onUpdate() {
        this.actualizadoEn = LocalDateTime.now();
    }

    @Generated
    public static SedeBuilder builder() {
        return new SedeBuilder();
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Tienda getTienda() {
        return this.tienda;
    }

    @Generated
    public String getCodigoInterno() {
        return this.codigoInterno;
    }

    @Generated
    public String getNombre() {
        return this.nombre;
    }

    @Generated
    public String getDireccion() {
        return this.direccion;
    }

    @Generated
    public String getTelefono() {
        return this.telefono;
    }

    @Generated
    public Long getDistritoId() {
        return this.distritoId;
    }

    @Generated
    public Boolean getEsPrincipal() {
        return this.esPrincipal;
    }

    @Generated
    public Boolean getActivo() {
        return this.activo;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public LocalDateTime getActualizadoEn() {
        return this.actualizadoEn;
    }

    @Generated
    public LocalDateTime getEliminadoEn() {
        return this.eliminadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTienda(Tienda tienda) {
        this.tienda = tienda;
    }

    @Generated
    public void setCodigoInterno(String codigoInterno) {
        this.codigoInterno = codigoInterno;
    }

    @Generated
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Generated
    public void setDireccion(String direccion) {
        this.direccion = direccion;
    }

    @Generated
    public void setTelefono(String telefono) {
        this.telefono = telefono;
    }

    @Generated
    public void setDistritoId(Long distritoId) {
        this.distritoId = distritoId;
    }

    @Generated
    public void setEsPrincipal(Boolean esPrincipal) {
        this.esPrincipal = esPrincipal;
    }

    @Generated
    public void setActivo(Boolean activo) {
        this.activo = activo;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public void setActualizadoEn(LocalDateTime actualizadoEn) {
        this.actualizadoEn = actualizadoEn;
    }

    @Generated
    public void setEliminadoEn(LocalDateTime eliminadoEn) {
        this.eliminadoEn = eliminadoEn;
    }

    @Generated
    public Sede() {
    }

    @Generated
    public Sede(Long id, Tienda tienda, String codigoInterno, String nombre, String direccion, String telefono, Long distritoId, Boolean esPrincipal, Boolean activo, LocalDateTime creadoEn, LocalDateTime actualizadoEn, LocalDateTime eliminadoEn) {
        this.id = id;
        this.tienda = tienda;
        this.codigoInterno = codigoInterno;
        this.nombre = nombre;
        this.direccion = direccion;
        this.telefono = telefono;
        this.distritoId = distritoId;
        this.esPrincipal = esPrincipal;
        this.activo = activo;
        this.creadoEn = creadoEn;
        this.actualizadoEn = actualizadoEn;
        this.eliminadoEn = eliminadoEn;
    }
}

