/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tiendas.controller;

import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.SedeCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.SedeResponse;
import com.dulcecontrol.bakery.features.superadmin.tiendas.dto.SedeUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.tiendas.service.ISedeSuperAdminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/tiendas/{tiendaId}/sedes"})
@Validated
public class SedeSuperAdminController {
    private final ISedeSuperAdminService sedeService;

    @GetMapping
    public ResponseEntity<List<SedeResponse>> listar(@PathVariable Long tiendaId) {
        return ResponseEntity.ok((Object)this.sedeService.listarPorTienda(tiendaId));
    }

    @GetMapping(value={"/{sedeId}"})
    public ResponseEntity<SedeResponse> obtener(@PathVariable Long tiendaId, @PathVariable Long sedeId) {
        return ResponseEntity.ok((Object)this.sedeService.obtenerPorId(tiendaId, sedeId));
    }

    @PostMapping
    public ResponseEntity<SedeResponse> crear(@PathVariable Long tiendaId, @Valid @RequestBody SedeCreateRequest request) {
        SedeResponse response = this.sedeService.crear(tiendaId, request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{sedeId}"})
    public ResponseEntity<SedeResponse> actualizar(@PathVariable Long tiendaId, @PathVariable Long sedeId, @Valid @RequestBody SedeUpdateRequest request) {
        SedeResponse response = this.sedeService.actualizar(tiendaId, sedeId, request);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{sedeId}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long tiendaId, @PathVariable Long sedeId) {
        this.sedeService.eliminar(tiendaId, sedeId);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public SedeSuperAdminController(ISedeSuperAdminService sedeService) {
        this.sedeService = sedeService;
    }
}

