/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.tablero.service.impl;

import com.dulcecontrol.bakery.features.superadmin.tablero.dto.ActividadSeguridadResponse;
import com.dulcecontrol.bakery.features.superadmin.tablero.dto.DistribucionPlanResponse;
import com.dulcecontrol.bakery.features.superadmin.tablero.dto.FacturacionMensualResponse;
import com.dulcecontrol.bakery.features.superadmin.tablero.dto.MetricaSuperadminResponse;
import com.dulcecontrol.bakery.features.superadmin.tablero.dto.RenovacionProximaResponse;
import com.dulcecontrol.bakery.features.superadmin.tablero.dto.TableroSuperadminResponse;
import com.dulcecontrol.bakery.features.superadmin.tablero.dto.TicketCriticoResponse;
import com.dulcecontrol.bakery.features.superadmin.tablero.service.ITableroSuperadminService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class TableroSuperadminServiceImpl
implements ITableroSuperadminService {
    private final EntityManager entityManager;
    private static final DecimalFormat MONEY_FORMAT = new DecimalFormat("S/ #,##0");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("dd MMM yyyy");
    private static final DateTimeFormatter DATETIME_FORMATTER = DateTimeFormatter.ofPattern("dd MMM HH:mm");

    public TableroSuperadminResponse obtenerEstadisticas() {
        TableroSuperadminResponse response = new TableroSuperadminResponse();
        response.setResumenMetrics(this.obtenerMetricasResumen());
        response.setFacturacionMensual(this.obtenerFacturacionMensual());
        response.setDistribucionPlanes(this.obtenerDistribucionPlanes());
        response.setTicketsCriticos(this.obtenerTicketsCriticos());
        response.setRenovacionesProximas(this.obtenerRenovacionesProximas());
        response.setActividadSeguridad(this.obtenerActividadSeguridad());
        return response;
    }

    private List<MetricaSuperadminResponse> obtenerMetricasResumen() {
        ArrayList<MetricaSuperadminResponse> metricas = new ArrayList<MetricaSuperadminResponse>();
        String sqlTotalTiendas = "SELECT COUNT(*) FROM tiendas";
        Long totalTiendas = ((Number)this.entityManager.createNativeQuery(sqlTotalTiendas).getSingleResult()).longValue();
        String sqlTiendasActivas = "SELECT COUNT(*) FROM tiendas t WHERE t.estado = 'ACTIVA'";
        Long tiendasActivas = ((Number)this.entityManager.createNativeQuery(sqlTiendasActivas).getSingleResult()).longValue();
        Long tiendasInactivas = totalTiendas - tiendasActivas;
        metricas.add(new MetricaSuperadminResponse("total-tiendas", "Total de tiendas", String.valueOf(totalTiendas), tiendasActivas + " activas", (String)(tiendasInactivas > 0L ? tiendasInactivas + " inactivas" : ""), tiendasInactivas > 0L ? "orange" : "green", "store"));
        String sqlSuscripcionesActivas = "SELECT COUNT(*) FROM suscripciones WHERE estado = 'ACTIVA'";
        Long suscripcionesActivas = ((Number)this.entityManager.createNativeQuery(sqlSuscripcionesActivas).getSingleResult()).longValue();
        String sqlSuscripcionesTotal = "SELECT COUNT(*) FROM suscripciones";
        Long suscripcionesTotal = ((Number)this.entityManager.createNativeQuery(sqlSuscripcionesTotal).getSingleResult()).longValue();
        String sqlSuscripcionesPrueba = "SELECT COUNT(*) FROM suscripciones WHERE estado = 'EN_PRUEBA'";
        Long suscripcionesPrueba = ((Number)this.entityManager.createNativeQuery(sqlSuscripcionesPrueba).getSingleResult()).longValue();
        String sqlSuscripcionesVencidas = "SELECT COUNT(*) FROM suscripciones WHERE estado = 'VENCIDA'";
        Long suscripcionesVencidas = ((Number)this.entityManager.createNativeQuery(sqlSuscripcionesVencidas).getSingleResult()).longValue();
        metricas.add(new MetricaSuperadminResponse("suscripciones", "Suscripciones", String.valueOf(suscripcionesTotal), suscripcionesActivas + " activas", (String)(suscripcionesPrueba > 0L ? suscripcionesPrueba + " en prueba" : "") + (String)(suscripcionesVencidas > 0L ? (suscripcionesPrueba > 0L ? " \u00b7 " : "") + suscripcionesVencidas + " vencidas" : ""), suscripcionesVencidas > 0L ? "red" : (suscripcionesPrueba > 0L ? "blue" : "green"), "rocket"));
        String sqlFacturacion = "SELECT COALESCE(SUM(s.precio_pactado_centimos), 0) / 100.0 FROM suscripciones s INNER JOIN tiendas t ON s.tienda_id = t.id WHERE t.estado = 'ACTIVA' AND s.estado = 'ACTIVA'";
        BigDecimal facturacionBruta = (BigDecimal)this.entityManager.createNativeQuery(sqlFacturacion).getSingleResult();
        metricas.add(new MetricaSuperadminResponse("ingresos-brutos", "Facturaci\u00f3n bruta", MONEY_FORMAT.format(facturacionBruta), "Mes en curso", "", "secondary", "cash"));
        Long mensajesTotal = 0L;
        Long ticketsAbiertos = 0L;
        Long ticketsCriticos = 0L;
        try {
            String sqlMensajesTotal = "SELECT COUNT(*) FROM mensajes_ticket";
            mensajesTotal = ((Number)this.entityManager.createNativeQuery(sqlMensajesTotal).getSingleResult()).longValue();
            String sqlTicketsAbiertos = "SELECT COUNT(*) FROM tickets_soporte ts WHERE ts.estado IN ('ABIERTO', 'PENDIENTE_CLIENTE')";
            ticketsAbiertos = ((Number)this.entityManager.createNativeQuery(sqlTicketsAbiertos).getSingleResult()).longValue();
            String sqlTicketsCriticos = "SELECT COUNT(*) FROM tickets_soporte ts WHERE ts.estado IN ('ABIERTO', 'PENDIENTE_CLIENTE') AND ts.prioridad = 'CRITICA'";
            ticketsCriticos = ((Number)this.entityManager.createNativeQuery(sqlTicketsCriticos).getSingleResult()).longValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        metricas.add(new MetricaSuperadminResponse("mensajes-soporte", "Mensajes de soporte", String.valueOf(mensajesTotal), ticketsAbiertos + " tickets abiertos", (String)(ticketsCriticos > 0L ? ticketsCriticos + " cr\u00edticos" : (ticketsAbiertos == 0L ? "Sin tickets" : "Sin cr\u00edticos")), ticketsCriticos > 0L ? "red" : (ticketsAbiertos > 0L ? "orange" : "green"), "alert"));
        return metricas;
    }

    private List<FacturacionMensualResponse> obtenerFacturacionMensual() {
        ArrayList<FacturacionMensualResponse> facturacion = new ArrayList<FacturacionMensualResponse>();
        String sql = "SELECT MONTH(s.creado_en) as mes, COALESCE(SUM(s.precio_pactado_centimos), 0) / 100.0 as total FROM suscripciones s WHERE YEAR(s.creado_en) = YEAR(NOW()) GROUP BY MONTH(s.creado_en) ORDER BY mes ASC";
        List resultados = this.entityManager.createNativeQuery(sql).getResultList();
        String[] meses = new String[]{"Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Set", "Oct", "Nov", "Dic"};
        for (Object[] row : resultados) {
            int mesNum = ((Number)row[0]).intValue();
            BigDecimal total = (BigDecimal)row[1];
            facturacion.add(new FacturacionMensualResponse(meses[mesNum - 1], total));
        }
        return facturacion;
    }

    private List<DistribucionPlanResponse> obtenerDistribucionPlanes() {
        String sql = "SELECT p.nombre, COALESCE(COUNT(s.id), 0) as cant_tiendas, COALESCE(AVG(s.precio_pactado_centimos), p.precio_mensual_centimos) / 100.0 as ticket_promedio FROM planes p LEFT JOIN suscripciones s ON p.id = s.plan_id AND s.estado = 'ACTIVA' LEFT JOIN tiendas t ON s.tienda_id = t.id AND t.estado = 'ACTIVA' WHERE p.activo = TRUE GROUP BY p.id, p.nombre, p.precio_mensual_centimos ORDER BY cant_tiendas DESC, p.nombre";
        List resultados = this.entityManager.createNativeQuery(sql).getResultList();
        return resultados.stream().map(row -> {
            String nombre = (String)row[0];
            Integer tiendas = ((Number)row[1]).intValue();
            BigDecimal precio = row[2] != null ? new BigDecimal(row[2].toString()) : BigDecimal.ZERO;
            return new DistribucionPlanResponse(nombre, tiendas, MONEY_FORMAT.format(precio));
        }).collect(Collectors.toList());
    }

    private List<TicketCriticoResponse> obtenerTicketsCriticos() {
        String sql = "SELECT ts.id, t.nombre_comercial, ts.prioridad, ts.estado, ts.vencimiento_sla_en FROM tickets_soporte ts INNER JOIN tiendas t ON ts.tienda_id = t.id WHERE ts.estado IN ('ABIERTO', 'PENDIENTE_CLIENTE') AND ts.prioridad IN ('CRITICA', 'ALTA') ORDER BY ts.prioridad ASC, ts.vencimiento_sla_en ASC LIMIT 5";
        List resultados = this.entityManager.createNativeQuery(sql).getResultList();
        return resultados.stream().map(row -> {
            String codigo = "#" + row[0].toString();
            String tienda = (String)row[1];
            String prioridad = (String)row[2];
            String estado = (String)row[3];
            Timestamp vencimiento = (Timestamp)row[4];
            return new TicketCriticoResponse(codigo, tienda, prioridad, estado, vencimiento != null ? vencimiento.toLocalDateTime().format(DATETIME_FORMATTER) : "Sin SLA");
        }).collect(Collectors.toList());
    }

    private List<RenovacionProximaResponse> obtenerRenovacionesProximas() {
        LocalDateTime ahora = LocalDateTime.now();
        LocalDateTime limite30Dias = ahora.plusDays(30L);
        String sql = "SELECT t.nombre_comercial, p.nombre, s.ciclo, s.fecha_fin, t.estado FROM suscripciones s INNER JOIN tiendas t ON s.tienda_id = t.id INNER JOIN planes p ON s.plan_id = p.id WHERE s.fecha_fin BETWEEN :ahora AND :limite AND s.estado = 'ACTIVA' ORDER BY s.fecha_fin ASC LIMIT 5";
        Query query = this.entityManager.createNativeQuery(sql);
        query.setParameter("ahora", (Object)ahora);
        query.setParameter("limite", (Object)limite30Dias);
        List resultados = query.getResultList();
        return resultados.stream().map(row -> {
            String tienda = (String)row[0];
            String planNombre = (String)row[1];
            String frecuencia = (String)row[2];
            Timestamp fechaRenov = (Timestamp)row[3];
            String estado = (String)row[4];
            LocalDateTime fechaRenovacion = fechaRenov.toLocalDateTime();
            long diasRestantes = ChronoUnit.DAYS.between(ahora, fechaRenovacion);
            return new RenovacionProximaResponse(tienda, planNombre + " \u00b7 " + frecuencia, fechaRenovacion.format(DATE_FORMATTER), Integer.valueOf((int)diasRestantes), estado);
        }).collect(Collectors.toList());
    }

    private List<ActividadSeguridadResponse> obtenerActividadSeguridad() {
        try {
            String sql = "SELECT al.fecha_evento, al.tipo_evento, al.descripcion, al.nivel_severidad FROM auditoria_logs al WHERE al.modulo = 'SEGURIDAD' ORDER BY al.fecha_evento DESC LIMIT 5";
            List resultados = this.entityManager.createNativeQuery(sql).getResultList();
            return resultados.stream().map(row -> {
                Timestamp fecha = (Timestamp)row[0];
                String evento = (String)row[1];
                String detalle = (String)row[2];
                String severidad = (String)row[3];
                return new ActividadSeguridadResponse(fecha.toLocalDateTime().format(DATETIME_FORMATTER), evento, detalle, severidad);
            }).collect(Collectors.toList());
        }
        catch (Exception e) {
            return new ArrayList<ActividadSeguridadResponse>();
        }
    }

    @Generated
    public TableroSuperadminServiceImpl(EntityManager entityManager) {
        this.entityManager = entityManager;
    }
}

