/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.suscripciones.service.impl;

import com.dulcecontrol.bakery.features.superadmin.suscripciones.dto.PlanCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.dto.PlanResponse;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.dto.PlanUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.entity.Plan;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.repository.PlanRepository;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.service.IPlanSuperadminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import lombok.Generated;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlanSuperadminService
implements IPlanSuperadminService {
    private static final Sort DEFAULT_SORT = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creadoEn"});
    private final PlanRepository planRepository;
    private final ObjectMapper objectMapper;

    @Transactional(readOnly=true)
    public List<PlanResponse> listar(Boolean soloActivos) {
        List planes = Boolean.TRUE.equals(soloActivos) ? this.planRepository.findByActivoTrue(DEFAULT_SORT) : this.planRepository.findAll(DEFAULT_SORT);
        return planes.stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public PlanResponse obtener(Long id) {
        Plan plan = (Plan)this.planRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Plan no encontrado"));
        return this.toResponse(plan);
    }

    @Transactional
    public PlanResponse crear(PlanCreateRequest request) {
        String codigoNormalizado = this.normalizarCodigo(request.getCodigo());
        if (this.planRepository.existsByCodigo(codigoNormalizado)) {
            throw new BadRequestException("Ya existe un plan con ese c\u00f3digo");
        }
        Plan plan = new Plan();
        plan.setCodigo(codigoNormalizado);
        plan.setNombre(request.getNombre().trim());
        plan.setDescripcion(this.normalizarTexto(request.getDescripcion()));
        plan.setPrecioMensualCentimos(request.getPrecioMensualCentimos());
        plan.setPrecioAnualCentimos(request.getPrecioAnualCentimos());
        plan.setMoneda(request.getMoneda().toUpperCase());
        plan.setLimitesJson(this.serializarLimites(request.getLimites()));
        plan.setActivo(request.getActivo() != null ? request.getActivo() : Boolean.TRUE);
        Plan guardado = (Plan)this.planRepository.save((Object)plan);
        return this.toResponse(guardado);
    }

    @Transactional
    public PlanResponse actualizar(Long id, PlanUpdateRequest request) {
        Plan plan = (Plan)this.planRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Plan no encontrado"));
        String codigoNormalizado = this.normalizarCodigo(request.getCodigo());
        if (this.planRepository.existsByCodigoAndIdNot(codigoNormalizado, id)) {
            throw new BadRequestException("Ya existe otro plan con ese c\u00f3digo");
        }
        plan.setCodigo(codigoNormalizado);
        plan.setNombre(request.getNombre().trim());
        plan.setDescripcion(this.normalizarTexto(request.getDescripcion()));
        plan.setPrecioMensualCentimos(request.getPrecioMensualCentimos());
        plan.setPrecioAnualCentimos(request.getPrecioAnualCentimos());
        plan.setMoneda(request.getMoneda().toUpperCase());
        plan.setLimitesJson(this.serializarLimites(request.getLimites()));
        if (request.getActivo() != null) {
            plan.setActivo(request.getActivo());
        }
        Plan actualizado = (Plan)this.planRepository.save((Object)plan);
        return this.toResponse(actualizado);
    }

    private String normalizarCodigo(String codigo) {
        return codigo == null ? null : codigo.trim().toUpperCase();
    }

    private String normalizarTexto(String texto) {
        return texto == null || texto.isBlank() ? null : texto.trim();
    }

    private String serializarLimites(JsonNode limites) {
        try {
            return this.objectMapper.writeValueAsString(limites == null ? this.objectMapper.createObjectNode() : limites);
        }
        catch (JsonProcessingException e) {
            throw new BadRequestException("Los l\u00edmites del plan no tienen un formato v\u00e1lido");
        }
    }

    private JsonNode deserializarLimites(String limitesJson) {
        if (limitesJson == null || limitesJson.isBlank()) {
            return this.objectMapper.createObjectNode();
        }
        try {
            return this.objectMapper.readTree(limitesJson);
        }
        catch (JsonProcessingException e) {
            return this.objectMapper.createObjectNode();
        }
    }

    private PlanResponse toResponse(Plan plan) {
        return PlanResponse.builder().id(plan.getId()).codigo(plan.getCodigo()).nombre(plan.getNombre()).descripcion(plan.getDescripcion()).precioMensualCentimos(plan.getPrecioMensualCentimos()).precioAnualCentimos(plan.getPrecioAnualCentimos()).moneda(plan.getMoneda()).limites(this.deserializarLimites(plan.getLimitesJson())).activo(plan.getActivo()).creadoEn(plan.getCreadoEn()).actualizadoEn(plan.getActualizadoEn()).build();
    }

    @Generated
    public PlanSuperadminService(PlanRepository planRepository, ObjectMapper objectMapper) {
        this.planRepository = planRepository;
        this.objectMapper = objectMapper;
    }
}

