/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.suscripciones.controller;

import com.dulcecontrol.bakery.features.superadmin.suscripciones.dto.PlanCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.dto.PlanResponse;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.dto.PlanUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.suscripciones.service.IPlanSuperadminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/suscripciones/planes"})
@Validated
public class PlanSuperadminController {
    private final IPlanSuperadminService planService;

    @GetMapping
    public ResponseEntity<List<PlanResponse>> listar(@RequestParam(name="soloActivos", required=false) Boolean soloActivos) {
        return ResponseEntity.ok((Object)this.planService.listar(soloActivos));
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PlanResponse> obtener(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.planService.obtener(id));
    }

    @PostMapping
    public ResponseEntity<PlanResponse> crear(@Valid @RequestBody PlanCreateRequest request) {
        PlanResponse response = this.planService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PlanResponse> actualizar(@PathVariable Long id, @Valid @RequestBody PlanUpdateRequest request) {
        return ResponseEntity.ok((Object)this.planService.actualizar(id, request));
    }

    @Generated
    public PlanSuperadminController(IPlanSuperadminService planService) {
        this.planService = planService;
    }
}

