/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.soporte.entity;

import com.dulcecontrol.bakery.features.superadmin.soporte.entity.converter.TipoRemitenteConverter;
import com.dulcecontrol.bakery.features.superadmin.soporte.entity.enums.TipoRemitente;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.PrePersist;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import lombok.Generated;

@Entity
@Table(name="mensajes_ticket")
public class MensajeTicket {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Column(name="ticket_id", nullable=false)
    private Long ticketId;
    @Convert(converter=TipoRemitenteConverter.class)
    @Column(name="tipo_remitente", nullable=false, columnDefinition="ENUM('superadmin','tienda','sistema')")
    private TipoRemitente tipoRemitente;
    @Column(name="autor_admin_id")
    private Long autorAdminId;
    @Column(name="mensaje", columnDefinition="TEXT", nullable=false)
    private String mensaje;
    @Column(name="es_nota_interna", nullable=false)
    private Boolean esNotaInterna = Boolean.FALSE;
    @Column(name="leido_en")
    private LocalDateTime leidoEn;
    @Column(name="creado_en", updatable=false)
    private LocalDateTime creadoEn;

    @PrePersist
    void onCreate() {
        this.creadoEn = LocalDateTime.now();
        if (this.esNotaInterna == null) {
            this.esNotaInterna = Boolean.FALSE;
        }
    }

    @Generated
    public MensajeTicket() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Long getTicketId() {
        return this.ticketId;
    }

    @Generated
    public TipoRemitente getTipoRemitente() {
        return this.tipoRemitente;
    }

    @Generated
    public Long getAutorAdminId() {
        return this.autorAdminId;
    }

    @Generated
    public String getMensaje() {
        return this.mensaje;
    }

    @Generated
    public Boolean getEsNotaInterna() {
        return this.esNotaInterna;
    }

    @Generated
    public LocalDateTime getLeidoEn() {
        return this.leidoEn;
    }

    @Generated
    public LocalDateTime getCreadoEn() {
        return this.creadoEn;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    @Generated
    public void setTipoRemitente(TipoRemitente tipoRemitente) {
        this.tipoRemitente = tipoRemitente;
    }

    @Generated
    public void setAutorAdminId(Long autorAdminId) {
        this.autorAdminId = autorAdminId;
    }

    @Generated
    public void setMensaje(String mensaje) {
        this.mensaje = mensaje;
    }

    @Generated
    public void setEsNotaInterna(Boolean esNotaInterna) {
        this.esNotaInterna = esNotaInterna;
    }

    @Generated
    public void setLeidoEn(LocalDateTime leidoEn) {
        this.leidoEn = leidoEn;
    }

    @Generated
    public void setCreadoEn(LocalDateTime creadoEn) {
        this.creadoEn = creadoEn;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MensajeTicket)) {
            return false;
        }
        MensajeTicket other = (MensajeTicket)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$ticketId = this.getTicketId();
        Long other$ticketId = other.getTicketId();
        if (this$ticketId == null ? other$ticketId != null : !((Object)this$ticketId).equals(other$ticketId)) {
            return false;
        }
        Long this$autorAdminId = this.getAutorAdminId();
        Long other$autorAdminId = other.getAutorAdminId();
        if (this$autorAdminId == null ? other$autorAdminId != null : !((Object)this$autorAdminId).equals(other$autorAdminId)) {
            return false;
        }
        Boolean this$esNotaInterna = this.getEsNotaInterna();
        Boolean other$esNotaInterna = other.getEsNotaInterna();
        if (this$esNotaInterna == null ? other$esNotaInterna != null : !((Object)this$esNotaInterna).equals(other$esNotaInterna)) {
            return false;
        }
        TipoRemitente this$tipoRemitente = this.getTipoRemitente();
        TipoRemitente other$tipoRemitente = other.getTipoRemitente();
        if (this$tipoRemitente == null ? other$tipoRemitente != null : !this$tipoRemitente.equals(other$tipoRemitente)) {
            return false;
        }
        String this$mensaje = this.getMensaje();
        String other$mensaje = other.getMensaje();
        if (this$mensaje == null ? other$mensaje != null : !this$mensaje.equals(other$mensaje)) {
            return false;
        }
        LocalDateTime this$leidoEn = this.getLeidoEn();
        LocalDateTime other$leidoEn = other.getLeidoEn();
        if (this$leidoEn == null ? other$leidoEn != null : !((Object)this$leidoEn).equals(other$leidoEn)) {
            return false;
        }
        LocalDateTime this$creadoEn = this.getCreadoEn();
        LocalDateTime other$creadoEn = other.getCreadoEn();
        return !(this$creadoEn == null ? other$creadoEn != null : !((Object)this$creadoEn).equals(other$creadoEn));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MensajeTicket;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $ticketId = this.getTicketId();
        result = result * 59 + ($ticketId == null ? 43 : ((Object)$ticketId).hashCode());
        Long $autorAdminId = this.getAutorAdminId();
        result = result * 59 + ($autorAdminId == null ? 43 : ((Object)$autorAdminId).hashCode());
        Boolean $esNotaInterna = this.getEsNotaInterna();
        result = result * 59 + ($esNotaInterna == null ? 43 : ((Object)$esNotaInterna).hashCode());
        TipoRemitente $tipoRemitente = this.getTipoRemitente();
        result = result * 59 + ($tipoRemitente == null ? 43 : $tipoRemitente.hashCode());
        String $mensaje = this.getMensaje();
        result = result * 59 + ($mensaje == null ? 43 : $mensaje.hashCode());
        LocalDateTime $leidoEn = this.getLeidoEn();
        result = result * 59 + ($leidoEn == null ? 43 : ((Object)$leidoEn).hashCode());
        LocalDateTime $creadoEn = this.getCreadoEn();
        result = result * 59 + ($creadoEn == null ? 43 : ((Object)$creadoEn).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MensajeTicket(id=" + this.getId() + ", ticketId=" + this.getTicketId() + ", tipoRemitente=" + String.valueOf(this.getTipoRemitente()) + ", autorAdminId=" + this.getAutorAdminId() + ", mensaje=" + this.getMensaje() + ", esNotaInterna=" + this.getEsNotaInterna() + ", leidoEn=" + String.valueOf(this.getLeidoEn()) + ", creadoEn=" + String.valueOf(this.getCreadoEn()) + ")";
    }
}

