/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.seguridad.service.impl;

import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.PerfilUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.RolSuperadminSummaryResponse;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.UsuarioSuperadminCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.UsuarioSuperadminResponse;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.UsuarioSuperadminUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.RolSuperadmin;
import com.dulcecontrol.bakery.features.superadmin.seguridad.entity.UsuarioSuperadmin;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.RolSuperadminRepository;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.UsuarioSuperadminRepository;
import com.dulcecontrol.bakery.features.superadmin.seguridad.service.IUsuarioSuperadminService;
import com.dulcecontrol.bakery.shared.exception.BadRequestException;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Sort;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UsuarioSuperadminService
implements IUsuarioSuperadminService {
    private final UsuarioSuperadminRepository usuarioRepository;
    private final BCryptPasswordEncoder passwordEncoder;
    private final RolSuperadminRepository rolRepository;

    @Transactional(readOnly=true)
    public List<UsuarioSuperadminResponse> listar() {
        return this.usuarioRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"creadoEn"})).stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public UsuarioSuperadminResponse obtenerPorId(Long id) {
        UsuarioSuperadmin usuario = (UsuarioSuperadmin)this.usuarioRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Superadministrador no encontrado"));
        return this.toResponse(usuario);
    }

    @Transactional
    public UsuarioSuperadminResponse crear(UsuarioSuperadminCreateRequest request) {
        String correoNormalizado = request.getCorreo().toLowerCase();
        String numeroDocNormalizado = this.limpiar(request.getNumeroDoc());
        this.validarDuplicadosAlCrear(correoNormalizado, numeroDocNormalizado);
        Set rolesAsignados = this.resolverRoles(request.getRoles(), true);
        UsuarioSuperadmin usuario = new UsuarioSuperadmin();
        usuario.setCorreo(correoNormalizado);
        usuario.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getContrasena()));
        usuario.setTipoDoc(request.getTipoDoc());
        usuario.setNumeroDoc(numeroDocNormalizado);
        usuario.setNombres(request.getNombres());
        usuario.setTelefono(this.limpiar(request.getTelefono()));
        usuario.setActivo(Boolean.TRUE);
        usuario.setRoles(new HashSet(rolesAsignados));
        UsuarioSuperadmin guardado = (UsuarioSuperadmin)this.usuarioRepository.save((Object)usuario);
        return this.toResponse(guardado);
    }

    @Transactional
    public UsuarioSuperadminResponse actualizar(Long id, UsuarioSuperadminUpdateRequest request) {
        UsuarioSuperadmin usuario = (UsuarioSuperadmin)this.usuarioRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Superadministrador no encontrado"));
        String correoNormalizado = request.getCorreo().toLowerCase();
        String numeroDocNormalizado = this.limpiar(request.getNumeroDoc());
        if (!usuario.getCorreo().equalsIgnoreCase(correoNormalizado) && this.usuarioRepository.existsByCorreoAndIdNot(correoNormalizado, id)) {
            throw new BadRequestException("El correo ya est\u00e1 registrado");
        }
        if (numeroDocNormalizado != null) {
            boolean cambioNumeroDoc;
            boolean bl = cambioNumeroDoc = usuario.getNumeroDoc() == null || !usuario.getNumeroDoc().equals(numeroDocNormalizado);
            if (cambioNumeroDoc && this.usuarioRepository.existsByNumeroDocAndIdNot(numeroDocNormalizado, id)) {
                throw new BadRequestException("El documento ya est\u00e1 registrado");
            }
        }
        usuario.setCorreo(correoNormalizado);
        usuario.setTipoDoc(request.getTipoDoc());
        usuario.setNumeroDoc(numeroDocNormalizado);
        usuario.setNombres(request.getNombres());
        usuario.setTelefono(this.limpiar(request.getTelefono()));
        if (request.getActivo() != null) {
            usuario.setActivo(request.getActivo());
        }
        if (request.getNuevaContrasena() != null && !request.getNuevaContrasena().isBlank()) {
            usuario.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getNuevaContrasena()));
        }
        if (request.getRoles() != null) {
            Set roles = this.resolverRoles(request.getRoles(), true);
            usuario.setRoles(new HashSet(roles));
        }
        UsuarioSuperadmin actualizado = (UsuarioSuperadmin)this.usuarioRepository.save((Object)usuario);
        return this.toResponse(actualizado);
    }

    @Transactional
    public void eliminar(Long id) {
        UsuarioSuperadmin usuario = (UsuarioSuperadmin)this.usuarioRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Superadministrador no encontrado"));
        this.usuarioRepository.delete((Object)usuario);
    }

    private void validarDuplicadosAlCrear(String correo, String numeroDoc) {
        if (this.usuarioRepository.existsByCorreo(correo)) {
            throw new BadRequestException("El correo ya est\u00e1 registrado");
        }
        if (numeroDoc != null && this.usuarioRepository.existsByNumeroDoc(numeroDoc)) {
            throw new BadRequestException("El documento ya est\u00e1 registrado");
        }
    }

    private String limpiar(String valor) {
        return valor == null || valor.isBlank() ? null : valor.trim();
    }

    private Set<RolSuperadmin> resolverRoles(Set<Long> rolesIds, boolean obligatorio) {
        if (rolesIds == null || rolesIds.isEmpty()) {
            if (obligatorio) {
                throw new BadRequestException("Debe asignar al menos un rol");
            }
            return Set.of();
        }
        List encontrados = this.rolRepository.findAllById(rolesIds);
        if (encontrados.size() != rolesIds.size()) {
            throw new BadRequestException("Uno o m\u00e1s roles no existen");
        }
        return new HashSet<RolSuperadmin>(encontrados);
    }

    private UsuarioSuperadminResponse toResponse(UsuarioSuperadmin usuario) {
        Set roles = usuario.getRoles() == null ? Set.of() : usuario.getRoles();
        return UsuarioSuperadminResponse.builder().id(usuario.getId()).correo(usuario.getCorreo()).tipoDoc(usuario.getTipoDoc()).numeroDoc(usuario.getNumeroDoc()).nombres(usuario.getNombres()).telefono(usuario.getTelefono()).activo(usuario.getActivo()).creadoEn(usuario.getCreadoEn()).actualizadoEn(usuario.getActualizadoEn()).roles((Set)roles.stream().sorted(Comparator.comparing(RolSuperadmin::getNombre, String.CASE_INSENSITIVE_ORDER)).map(rol -> RolSuperadminSummaryResponse.builder().id(rol.getId()).nombre(rol.getNombre()).esSistema(rol.getEsSistema()).build()).collect(Collectors.toCollection(LinkedHashSet::new))).build();
    }

    @Transactional(readOnly=true)
    public UsuarioSuperadminResponse obtenerMiPerfil(Long usuarioId) {
        UsuarioSuperadmin usuario = (UsuarioSuperadmin)this.usuarioRepository.findById((Object)usuarioId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        return this.toResponse(usuario);
    }

    @Transactional
    public UsuarioSuperadminResponse actualizarMiPerfil(Long usuarioId, PerfilUpdateRequest request) {
        UsuarioSuperadmin usuario = (UsuarioSuperadmin)this.usuarioRepository.findById((Object)usuarioId).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
        if (request.getCorreo() != null && !request.getCorreo().isBlank()) {
            String correoNormalizado = request.getCorreo().toLowerCase();
            if (!usuario.getCorreo().equalsIgnoreCase(request.getCorreo()) && this.usuarioRepository.existsByCorreoAndIdNot(correoNormalizado, usuarioId)) {
                throw new BadRequestException("El correo ya est\u00e1 registrado");
            }
            usuario.setCorreo(correoNormalizado);
        }
        if (request.getNombres() != null && !request.getNombres().isBlank()) {
            usuario.setNombres(request.getNombres());
        }
        if (request.getTelefono() != null && !request.getTelefono().isBlank()) {
            usuario.setTelefono(request.getTelefono());
        }
        if (request.getNuevaContrasena() != null && !request.getNuevaContrasena().isBlank()) {
            if (request.getContrasenaActual() == null || request.getContrasenaActual().isBlank()) {
                throw new BadRequestException("Debes proporcionar tu contrase\u00f1a actual para cambiarla");
            }
            if (!this.passwordEncoder.matches((CharSequence)request.getContrasenaActual(), usuario.getHashContrasena())) {
                throw new BadRequestException("La contrase\u00f1a actual es incorrecta");
            }
            usuario.setHashContrasena(this.passwordEncoder.encode((CharSequence)request.getNuevaContrasena()));
        }
        UsuarioSuperadmin guardado = (UsuarioSuperadmin)this.usuarioRepository.save((Object)usuario);
        return this.toResponse(guardado);
    }

    @Generated
    public UsuarioSuperadminService(UsuarioSuperadminRepository usuarioRepository, BCryptPasswordEncoder passwordEncoder, RolSuperadminRepository rolRepository) {
        this.usuarioRepository = usuarioRepository;
        this.passwordEncoder = passwordEncoder;
        this.rolRepository = rolRepository;
    }
}

