/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.seguridad.controller;

import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.RolSuperadminCreateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.RolSuperadminResponse;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.RolSuperadminUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.service.IRolSuperadminService;
import jakarta.validation.Valid;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/superadmin/seguridad/roles"})
@Validated
public class RolSuperadminController {
    private final IRolSuperadminService rolSuperadminService;

    @GetMapping
    public ResponseEntity<List<RolSuperadminResponse>> listar() {
        return ResponseEntity.ok((Object)this.rolSuperadminService.listar());
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<RolSuperadminResponse> obtener(@PathVariable Long id) {
        return ResponseEntity.ok((Object)this.rolSuperadminService.obtener(id));
    }

    @PostMapping
    public ResponseEntity<RolSuperadminResponse> crear(@Valid @RequestBody RolSuperadminCreateRequest request) {
        RolSuperadminResponse response = this.rolSuperadminService.crear(request);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<RolSuperadminResponse> actualizar(@PathVariable Long id, @Valid @RequestBody RolSuperadminUpdateRequest request) {
        return ResponseEntity.ok((Object)this.rolSuperadminService.actualizar(id, request));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> eliminar(@PathVariable Long id) {
        this.rolSuperadminService.eliminar(id);
        return ResponseEntity.noContent().build();
    }

    @Generated
    public RolSuperadminController(IRolSuperadminService rolSuperadminService) {
        this.rolSuperadminService = rolSuperadminService;
    }
}

