/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.seguridad.controller;

import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.PerfilUpdateRequest;
import com.dulcecontrol.bakery.features.superadmin.seguridad.dto.UsuarioSuperadminResponse;
import com.dulcecontrol.bakery.features.superadmin.seguridad.repository.UsuarioSuperadminRepository;
import com.dulcecontrol.bakery.features.superadmin.seguridad.service.IUsuarioSuperadminService;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import jakarta.validation.Valid;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/superadmin/perfil"})
public class PerfilSuperadminController {
    private final IUsuarioSuperadminService usuarioService;
    private final UsuarioSuperadminRepository usuarioSuperadminRepository;

    private Long resolveUsuarioId(Authentication authentication) {
        String correo = authentication.getName();
        return this.usuarioSuperadminRepository.findByCorreo(correo).map(usuario -> usuario.getId()).orElseThrow(() -> new ResourceNotFoundException("Usuario no encontrado"));
    }

    @GetMapping(value={"/me"})
    public ResponseEntity<UsuarioSuperadminResponse> obtenerMiPerfil(Authentication authentication) {
        Long usuarioId = this.resolveUsuarioId(authentication);
        UsuarioSuperadminResponse perfil = this.usuarioService.obtenerMiPerfil(usuarioId);
        return ResponseEntity.ok((Object)perfil);
    }

    @PutMapping(value={"/me"})
    public ResponseEntity<UsuarioSuperadminResponse> actualizarMiPerfil(Authentication authentication, @Valid @RequestBody PerfilUpdateRequest request) {
        Long usuarioId = this.resolveUsuarioId(authentication);
        UsuarioSuperadminResponse perfil = this.usuarioService.actualizarMiPerfil(usuarioId, request);
        return ResponseEntity.ok((Object)perfil);
    }

    @Generated
    public PerfilSuperadminController(IUsuarioSuperadminService usuarioService, UsuarioSuperadminRepository usuarioSuperadminRepository) {
        this.usuarioService = usuarioService;
        this.usuarioSuperadminRepository = usuarioSuperadminRepository;
    }
}

