/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.facturacion.service.impl;

import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.MetodoPagoRequest;
import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.MetodoPagoResponse;
import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.MetodoPago;
import com.dulcecontrol.bakery.features.superadmin.facturacion.repository.MetodoPagoRepository;
import com.dulcecontrol.bakery.features.superadmin.facturacion.service.IMetodoPagoService;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class MetodoPagoServiceImpl
implements IMetodoPagoService {
    private final MetodoPagoRepository metodoPagoRepository;

    public List<MetodoPagoResponse> listar() {
        return this.metodoPagoRepository.findAll().stream().map(arg_0 -> this.mapToResponse(arg_0)).collect(Collectors.toList());
    }

    public MetodoPagoResponse obtener(Long id) {
        MetodoPago metodoPago = (MetodoPago)this.metodoPagoRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("M\u00e9todo de pago no encontrado"));
        return this.mapToResponse(metodoPago);
    }

    public MetodoPagoResponse crear(MetodoPagoRequest request) {
        MetodoPago metodoPago = new MetodoPago();
        metodoPago.setNombre(request.getNombre());
        metodoPago.setCodigo(request.getCodigo());
        metodoPago.setActivo(request.getActivo());
        MetodoPago guardado = (MetodoPago)this.metodoPagoRepository.save((Object)metodoPago);
        return this.mapToResponse(guardado);
    }

    public MetodoPagoResponse actualizar(Long id, MetodoPagoRequest request) {
        MetodoPago metodoPago = (MetodoPago)this.metodoPagoRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("M\u00e9todo de pago no encontrado"));
        metodoPago.setNombre(request.getNombre());
        metodoPago.setCodigo(request.getCodigo());
        metodoPago.setActivo(request.getActivo());
        MetodoPago actualizado = (MetodoPago)this.metodoPagoRepository.save((Object)metodoPago);
        return this.mapToResponse(actualizado);
    }

    public void eliminar(Long id) {
        if (!this.metodoPagoRepository.existsById((Object)id)) {
            throw new ResourceNotFoundException("M\u00e9todo de pago no encontrado");
        }
        this.metodoPagoRepository.deleteById((Object)id);
    }

    private MetodoPagoResponse mapToResponse(MetodoPago entity) {
        MetodoPagoResponse response = new MetodoPagoResponse();
        response.setId(entity.getId());
        response.setNombre(entity.getNombre());
        response.setCodigo(entity.getCodigo());
        response.setActivo(entity.getActivo());
        return response;
    }

    @Generated
    public MetodoPagoServiceImpl(MetodoPagoRepository metodoPagoRepository) {
        this.metodoPagoRepository = metodoPagoRepository;
    }
}

