/*
 * Decompiled with CFR 0.152.
 */
package com.dulcecontrol.bakery.features.superadmin.facturacion.service.impl;

import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.ComprobanteResponse;
import com.dulcecontrol.bakery.features.superadmin.facturacion.dto.DetalleComprobanteResponse;
import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.Comprobante;
import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.DetalleComprobante;
import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.enums.EstadoSunat;
import com.dulcecontrol.bakery.features.superadmin.facturacion.entity.enums.TipoComprobante;
import com.dulcecontrol.bakery.features.superadmin.facturacion.repository.ComprobanteRepository;
import com.dulcecontrol.bakery.features.superadmin.facturacion.repository.DetalleComprobanteRepository;
import com.dulcecontrol.bakery.features.superadmin.facturacion.service.IComprobanteService;
import com.dulcecontrol.bakery.shared.exception.ResourceNotFoundException;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComprobanteService
implements IComprobanteService {
    private final ComprobanteRepository comprobanteRepository;
    private final DetalleComprobanteRepository detalleRepository;

    @Transactional(readOnly=true)
    public List<ComprobanteResponse> listar(Long tiendaId, EstadoSunat estadoSunat, TipoComprobante tipo) {
        List items = tiendaId != null ? this.comprobanteRepository.findByTiendaIdOrderByFechaEmisionDesc(tiendaId) : (estadoSunat != null ? this.comprobanteRepository.findByEstadosSunatOrderByFechaEmisionDesc(estadoSunat) : (tipo != null ? this.comprobanteRepository.findByTiposComprobanteOrderByCorrelativoDesc(tipo) : this.comprobanteRepository.findAll()));
        return items.stream().map(arg_0 -> this.toResponse(arg_0)).toList();
    }

    @Transactional(readOnly=true)
    public ComprobanteResponse obtener(Long id) {
        Comprobante c = (Comprobante)this.comprobanteRepository.findById((Object)id).orElseThrow(() -> new ResourceNotFoundException("Comprobante no encontrado"));
        return this.toResponse(c);
    }

    @Transactional(readOnly=true)
    public List<DetalleComprobanteResponse> listarDetalles(Long comprobanteId) {
        return this.detalleRepository.findByComprobanteId(comprobanteId).stream().map(arg_0 -> this.toDetalleResponse(arg_0)).toList();
    }

    private ComprobanteResponse toResponse(Comprobante c) {
        return ComprobanteResponse.builder().id(c.getId()).tiendaId(c.getTiendaId()).serieId(c.getSerieId()).tiposComprobante(c.getTiposComprobante()).correlativo(c.getCorrelativo()).estadoPago(c.getEstadoPago()).estadosSunat(c.getEstadosSunat()).fechaEmision(c.getFechaEmision()).clienteTipoDoc(c.getClienteTipoDoc()).clienteNumDoc(c.getClienteNumDoc()).clienteNombreDoc(c.getClienteNombreDoc()).clienteDireccion(c.getClienteDireccion()).moneda(c.getMoneda()).totalGravadoCentimos(c.getTotalGravadoCentimos()).totalIgvCentimos(c.getTotalIgvCentimos()).totalImporteCentimos(c.getTotalImporteCentimos()).urlXml(c.getUrlXml()).urlCdr(c.getUrlCdr()).urlPdf(c.getUrlPdf()).creadoEn(c.getCreadoEn()).build();
    }

    private DetalleComprobanteResponse toDetalleResponse(DetalleComprobante d) {
        return DetalleComprobanteResponse.builder().id(d.getId()).comprobanteId(d.getComprobanteId()).descripcion(d.getDescripcion()).cantidad(d.getCantidad()).valorUnitarioCentimos(d.getValorUnitarioCentimos()).precioUnitarioCentimos(d.getPrecioUnitarioCentimos()).igvItemCentimos(d.getIgvItemCentimos()).totalItemCentimos(d.getTotalItemCentimos()).build();
    }

    @Generated
    public ComprobanteService(ComprobanteRepository comprobanteRepository, DetalleComprobanteRepository detalleRepository) {
        this.comprobanteRepository = comprobanteRepository;
        this.detalleRepository = detalleRepository;
    }
}

